/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.eclipse.compare.internal.BaseCompareAction;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.texteditor.ITextEditor;

public class ClipboardReplace
extends BaseCompareAction {
    @Override
    protected void run(ISelection selection) {
        IFile[] files;
        IFile[] iFileArray = files = Utilities.getFiles(selection);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            try {
                ITextEditor txtEditor;
                ISelection selection2;
                IEditorInput input;
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart editor = page.getActiveEditor();
                if (editor instanceof FormEditor) {
                    FormEditor fromEditor = (FormEditor)editor;
                    editor = fromEditor.getActiveEditor();
                }
                if ((input = editor.getEditorInput()) instanceof IFileEditorInput) {
                    IFileEditorInput ed = (IFileEditorInput)input;
                    IFile file2 = ed.getFile();
                    String fileName2 = file2.getName();
                    if (!file.getName().equals(fileName2)) {
                        ByteArrayInputStream source = new ByteArrayInputStream(this.getClipboard().toString().getBytes(StandardCharsets.UTF_8));
                        file.setContents((InputStream)source, 1, null);
                        return;
                    }
                }
                if (editor instanceof ITextEditor && (selection2 = (txtEditor = (ITextEditor)editor).getSelectionProvider().getSelection()) instanceof ITextSelection) {
                    ITextSelection textSelection = (ITextSelection)selection2;
                    int offset = textSelection.getOffset();
                    int len = textSelection.getLength();
                    if (len > 0) {
                        IDocument doc = ((ITextEditor)editor).getDocumentProvider().getDocument((Object)editor.getEditorInput());
                        doc.replace(offset, len, this.getClipboard().toString());
                        return;
                    }
                    ByteArrayInputStream source = new ByteArrayInputStream(this.getClipboard().toString().getBytes(StandardCharsets.UTF_8));
                    file.setContents((InputStream)source, 1, null);
                }
            }
            catch (Exception e) {
                Shell parentShell = CompareUIPlugin.getShell();
                MessageDialog.openError((Shell)parentShell, (String)"Replace Failed", (String)e.getMessage());
            }
            ++n2;
        }
    }

    @Override
    protected boolean isEnabled(ISelection selection) {
        return Utilities.getFiles(selection).length == 1 && this.getClipboard() != null;
    }

    private Object getClipboard() {
        Clipboard clip = new Clipboard(Display.getDefault());
        return clip.getContents((Transfer)TextTransfer.getInstance());
    }
}

