/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.figures;

import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.gef.figures.AbstractShadowBorder;
import org.eclipse.fordiac.ide.gef.figures.FBShape;
import org.eclipse.swt.graphics.Color;

public class FBShapeShadowBorder
extends AbstractShadowBorder {
    private static Rectangle topShadowRect = new Rectangle();
    private static Rectangle middleShadowRect = new Rectangle();
    private static Rectangle bottomShadowRect = new Rectangle();

    public void paintBackground(IFigure figure, Graphics graphics, Insets insets) {
        Assert.isTrue((boolean)(figure instanceof FBShape));
        FBShape fbShape = (FBShape)figure;
        Color backgroundColor = graphics.getBackgroundColor();
        int alpha = graphics.getAlpha();
        graphics.setBackgroundColor(figure.getForegroundColor());
        topShadowRect.setBounds(fbShape.getTop().getBounds()).expand(2, 2);
        middleShadowRect.setBounds(fbShape.getMiddle().getBounds()).expand(2, 0);
        bottomShadowRect.setBounds(fbShape.getBottom().getBounds()).expand(2, 2);
        FBShapeShadowBorder.drawShadowHalo(graphics, topShadowRect, middleShadowRect, bottomShadowRect);
        FBShapeShadowBorder.drawDropShadow(graphics, topShadowRect, middleShadowRect, bottomShadowRect);
        graphics.setBackgroundColor(backgroundColor);
        graphics.setAlpha(alpha);
    }

    private static void drawShadowHalo(Graphics graphics, Rectangle topShadowRect, Rectangle middleShadowRect, Rectangle bottomShadowRect) {
        graphics.setAlpha(30);
        FBShapeShadowBorder.drawShadowFigure(graphics, topShadowRect, middleShadowRect, bottomShadowRect);
        topShadowRect.shrink(1, 1);
        middleShadowRect.shrink(1, 0);
        bottomShadowRect.shrink(1, 1);
        graphics.setAlpha(60);
        FBShapeShadowBorder.drawShadowFigure(graphics, topShadowRect, middleShadowRect, bottomShadowRect);
    }

    private static void drawDropShadow(Graphics graphics, Rectangle topShadowRect, Rectangle middleShadowRect, Rectangle bottomShadowRect) {
        graphics.setAlpha(30);
        double horInc = 0.7;
        double horI = 0.0;
        int i = 0;
        while (i < 4) {
            topShadowRect.translate((int)(horI += 0.7), 1);
            middleShadowRect.translate((int)horI, 1);
            bottomShadowRect.translate((int)horI, 1);
            FBShapeShadowBorder.drawShadowFigure(graphics, topShadowRect, middleShadowRect, bottomShadowRect);
            if (horI >= 1.0) {
                horI -= 1.0;
            }
            ++i;
        }
    }

    private static void drawShadowFigure(Graphics graphics, Rectangle topShadowRect, Rectangle middleShadowRect, Rectangle bottomShadowRect) {
        graphics.fillRoundRectangle(topShadowRect, 8, 8);
        graphics.fillRectangle(middleShadowRect);
        graphics.fillRoundRectangle(bottomShadowRect, 8, 8);
    }
}

