/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import org.eclipse.core.runtime.Assert;
import org.eclipse.fordiac.ide.gef.properties.AbstractDoubleColumnSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeValueCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractInterfaceSection
extends AbstractDoubleColumnSection {
    protected Text nameText;
    protected Text commentText;
    private TableViewer inputViewer;
    private static final String NAME_PROPERTY = "name";
    private static final String VALUE_PROPERTY = "value";
    private static final String COMMENT_PROPERTY = "comment";

    protected AbstractInterfaceSection() {
    }

    protected INamedElement getType() {
        Object object = this.type;
        if (object instanceof BlockFBNetworkElement) {
            BlockFBNetworkElement fbnEl = (BlockFBNetworkElement)object;
            return fbnEl;
        }
        Object object2 = this.type;
        if (object2 instanceof Device) {
            Device dev = (Device)object2;
            return dev;
        }
        Object object3 = this.type;
        if (object3 instanceof Resource) {
            Resource res = (Resource)object3;
            return res;
        }
        return null;
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createFBInfoGroup(parent);
        this.createInputInfoGroup(parent);
    }

    protected void createFBInfoGroup(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(composite, FordiacMessages.InstanceName + ":");
        this.nameText = this.createGroupText(composite, true);
        this.nameText.addModifyListener(event -> {
            this.removeContentAdapter();
            this.executeCommand((Command)ChangeNameCommand.forName((INamedElement)this.getType(), (String)this.nameText.getText()));
            this.addContentAdapter();
        });
        CLabel commentLabel = this.getWidgetFactory().createCLabel(composite, FordiacMessages.InstanceComment + ":");
        commentLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.commentText = this.createGroupText(composite, true, 2562);
        GridData gridData = new GridData(4, 128, true, false);
        gridData.heightHint = 3 * this.commentText.getLineHeight();
        this.commentText.setLayoutData((Object)gridData);
        this.commentText.addModifyListener(event -> {
            this.removeContentAdapter();
            this.executeCommand((Command)new ChangeCommentCommand(this.getType(), this.commentText.getText()));
            this.addContentAdapter();
        });
    }

    private void createInputInfoGroup(Composite parent) {
        Group inputGroup = this.getWidgetFactory().createGroup(parent, FordiacMessages.Inputs);
        inputGroup.setLayout((Layout)new GridLayout(1, false));
        inputGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.inputViewer = TableWidgetFactory.createPropertyTableViewer((Composite)inputGroup, (int)0);
        this.configureTableLayout(this.inputViewer.getTable());
        this.inputViewer.setContentProvider((IContentProvider)new InputContentProvider());
        this.inputViewer.setLabelProvider((IBaseLabelProvider)new InputLabelProvider());
        this.inputViewer.setCellModifier((ICellModifier)new ValueCommentCellModifier());
    }

    private void configureTableLayout(Table table) {
        TableColumn column1 = new TableColumn(this.inputViewer.getTable(), 16384);
        column1.setText(FordiacMessages.Name);
        TableColumn column2 = new TableColumn(this.inputViewer.getTable(), 16384);
        column2.setText(FordiacMessages.InitialValue);
        TableColumn column3 = new TableColumn(this.inputViewer.getTable(), 16384);
        column3.setText(FordiacMessages.Comment);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 70));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, 70));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 90));
        table.setLayout((Layout)layout);
        this.inputViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)});
        this.inputViewer.setColumnProperties(new String[]{NAME_PROPERTY, VALUE_PROPERTY, COMMENT_PROPERTY});
    }

    private static String getVarDeclarationValue(VarDeclaration v) {
        return v.getValue() != null ? v.getValue().getValue() : "";
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        this.setCurrentCommandStack(part, input);
        if (this.getCurrentCommandStack() == null) {
            this.disableAllFields();
        }
        this.setType(input);
    }

    protected void disableAllFields() {
        this.nameText.setEnabled(false);
        this.commentText.setEnabled(false);
        this.inputViewer.setCellModifier(null);
    }

    @Override
    protected void performRefresh() {
        Display.getDefault().asyncExec(() -> {
            if (!this.nameText.isDisposed() && !this.nameText.getParent().isDisposed()) {
                CommandStack commandStackBuffer = this.getCurrentCommandStack();
                this.setCurrentCommandStack(null);
                if (this.type instanceof AdapterFB) {
                    this.nameText.setEnabled(false);
                }
                this.nameText.setText(this.getType().getName() != null ? this.getType().getName() : "");
                this.commentText.setText(this.getType().getComment() != null ? this.getType().getComment() : "");
                this.inputViewer.setInput((Object)this.getType());
                this.setCurrentCommandStack(commandStackBuffer);
            }
        });
    }

    @Override
    protected void setInputInit() {
    }

    @Override
    protected void setInputCode() {
    }

    public static class InputContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof BlockFBNetworkElement) {
                BlockFBNetworkElement fbnEl = (BlockFBNetworkElement)inputElement;
                return fbnEl.getInterface().getInputVars().toArray();
            }
            if (inputElement instanceof Device) {
                Device dev = (Device)inputElement;
                return dev.getVarDeclarations().toArray();
            }
            if (inputElement instanceof Resource) {
                Resource res = (Resource)inputElement;
                return res.getVarDeclarations().toArray();
            }
            return new Object[0];
        }
    }

    public static class InputLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof VarDeclaration) {
                VarDeclaration varDecl = (VarDeclaration)element;
                switch (columnIndex) {
                    case 0: {
                        return varDecl.getName();
                    }
                    case 1: {
                        return AbstractInterfaceSection.getVarDeclarationValue(varDecl);
                    }
                    case 2: {
                        return varDecl.getComment() != null ? varDecl.getComment() : "";
                    }
                }
            }
            return element.toString();
        }
    }

    private class ValueCommentCellModifier
    implements ICellModifier {
        private ValueCommentCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return AbstractInterfaceSection.VALUE_PROPERTY.equals(property) || AbstractInterfaceSection.COMMENT_PROPERTY.equals(property);
        }

        public Object getValue(Object element, String property) {
            return switch (property) {
                case AbstractInterfaceSection.VALUE_PROPERTY -> AbstractInterfaceSection.getVarDeclarationValue((VarDeclaration)element);
                case AbstractInterfaceSection.COMMENT_PROPERTY -> {
                    if (((INamedElement)element).getComment() != null) {
                        yield ((INamedElement)element).getComment();
                    }
                    yield "";
                }
                default -> null;
            };
        }

        public void modify(Object element, String property, Object value) {
            TableItem tableItem = (TableItem)element;
            Object data = tableItem.getData();
            ChangeValueCommand cmd = null;
            switch (property) {
                case "value": {
                    cmd = new ChangeValueCommand((VarDeclaration)data, value.toString());
                    break;
                }
                case "comment": {
                    cmd = new ChangeCommentCommand((INamedElement)data, value.toString());
                    break;
                }
            }
            if (cmd != null && AbstractInterfaceSection.this.getCurrentCommandStack() != null) {
                AbstractInterfaceSection.this.executeCommand((Command)cmd);
                AbstractInterfaceSection.this.inputViewer.refresh(data);
            }
        }
    }
}

