/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.contracts.model.AbstractTime;
import org.eclipse.fordiac.ide.contracts.model.Contract;
import org.eclipse.fordiac.ide.contracts.model.Instant;
import org.eclipse.fordiac.ide.contracts.model.Interval;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;

public abstract class ContractElement {
    private AbstractTime time;
    private String inputEvent;
    private Contract owner;

    ContractElement() {
    }

    ContractElement(String inputEvent, AbstractTime time) {
        this.inputEvent = inputEvent;
        this.time = time;
    }

    AbstractTime getTime() {
        return this.time;
    }

    void setTime(AbstractTime time) {
        this.time = time;
    }

    public String getInputEvent() {
        return this.inputEvent;
    }

    void setInputEvent(String inputEvent) {
        this.inputEvent = inputEvent;
    }

    public int getMin() {
        return this.time.getMin();
    }

    public int getMax() {
        return this.time.getMax();
    }

    public AbstractTime getBounds() {
        if (this.time.getMax() == -1) {
            return new Instant(this.time.getMin());
        }
        return new Interval(this.time.getMin(), this.time.getMax());
    }

    public Contract getContract() {
        return this.owner;
    }

    void setContract(Contract owner) {
        this.owner = owner;
    }

    boolean hasValidOwner() {
        return this.getContract().getOwner() instanceof SubApp;
    }

    List<AbstractTime> getOccurrences() {
        return this.getOccurrences(5);
    }

    List<AbstractTime> getOccurrences(int number) {
        ArrayList<AbstractTime> timestamps = new ArrayList<AbstractTime>();
        AbstractTime timeOccurrenc = this.getBounds();
        AbstractTime toAdd = timeOccurrenc.getCopy();
        int count = 0;
        while (count < number) {
            timestamps.add(toAdd.getCopy());
            toAdd = toAdd.add(timeOccurrenc);
            ++count;
        }
        return timestamps;
    }

    List<AbstractTime> getOccurrences(Interval range) {
        ArrayList<AbstractTime> timestamps = new ArrayList<AbstractTime>();
        if (this.getMax() == -1) {
            int timeMin = this.getMin();
            while (timeMin <= range.getMax()) {
                if (timeMin >= range.getMin()) {
                    timestamps.add(new Instant(timeMin));
                }
                timeMin += this.getMin();
            }
        } else {
            int minTime = this.getMin();
            int maxTime = this.getMax();
            while (minTime <= range.getMax()) {
                if (maxTime >= range.getMin()) {
                    timestamps.add(new Interval(minTime, maxTime));
                }
                minTime += this.getMin();
                maxTime += this.getMax();
            }
        }
        return timestamps;
    }

    abstract boolean isValid();

    abstract String asString();

    void setRangeFromInterval(String[] parts, int position) {
        parts = parts[position].split(",");
        int min = Integer.parseInt(parts[0].substring(1));
        parts = parts[1].split("]");
        int max = Integer.parseInt(parts[0]);
        this.setTime(new Interval(min, max));
    }
}

