/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts.model;

import org.eclipse.fordiac.ide.contracts.model.AbstractTime;
import org.eclipse.fordiac.ide.contracts.model.Instant;

public class Interval
extends AbstractTime {
    private final int minTime;
    private final int maxTime;

    public Interval(int minTime, int maxTime) {
        this.minTime = minTime;
        this.maxTime = maxTime;
    }

    public boolean isValid() {
        return this.minTime <= this.maxTime;
    }

    public Interval calculateOverlap(Interval other) {
        if (other == null) {
            return null;
        }
        int min = Math.max(other.getMin(), this.getMin());
        int max = Math.min(other.getMax(), this.getMax());
        return new Interval(min, max);
    }

    public Interval merge(Interval other) {
        if (other == null) {
            return null;
        }
        if (this.hasNoOverlap(other)) {
            return new Interval(0, -1);
        }
        int min = Math.min(other.getMin(), this.getMin());
        int max = Math.max(other.maxTime, this.getMax());
        return new Interval(min, max);
    }

    private boolean hasNoOverlap(Interval other) {
        return other.getMax() < this.getMin() && other.getMin() > this.getMax();
    }

    private Interval add(Interval other) {
        return new Interval(this.getMin() + other.getMin(), this.getMax() + other.getMax());
    }

    private Interval add(Instant other) {
        return new Interval(this.getMin() + other.getMin(), this.getMax() + other.getMin());
    }

    @Override
    public Interval add(AbstractTime other) {
        if (other instanceof Instant) {
            Instant otherInstant = (Instant)other;
            return this.add(otherInstant);
        }
        if (other instanceof Interval) {
            Interval otherInterval = (Interval)other;
            return this.add(otherInterval);
        }
        return null;
    }

    @Override
    public int getMin() {
        return this.minTime;
    }

    @Override
    public int getMax() {
        return this.maxTime;
    }

    @Override
    public AbstractTime getCopy() {
        return new Interval(this.minTime, this.maxTime);
    }
}

