/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts.model.helpers;

import org.eclipse.fordiac.ide.contracts.model.ContractElement;
import org.eclipse.fordiac.ide.contracts.model.helpers.ContractElementBuilder;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;

public final class ContractUtils {
    private ContractUtils() {
    }

    public static boolean isContractSubapp(FBNetworkElement element) {
        SubApp containedSubapp;
        return element instanceof SubApp && (containedSubapp = (SubApp)element).getName().startsWith("_CONTRACT");
    }

    public static boolean isInterval(String[] parts, int pos, CharSequence div) {
        return parts[pos].contains(div);
    }

    public static String createInterval(ContractElement source) {
        StringBuilder interval = new StringBuilder();
        interval.append("[");
        interval.append(source.getMin());
        interval.append(",");
        interval.append(source.getMax());
        interval.append("]");
        return interval.toString();
    }

    public static int getStartPosition(String[] parts, int posTime) {
        return parts[posTime].length() - "ms".length();
    }

    public static String createAssumptionString(String event, String time) {
        ContractElementBuilder elementStr = new ContractElementBuilder();
        elementStr.addAssumption().addEventSpace(event).addOccurs().addEvery().addTime(time).addTimeUnit();
        return elementStr.getString();
    }

    public static String createOffsetString(String time) {
        ContractElementBuilder elementStr = new ContractElementBuilder();
        elementStr.addWith().addTime(time).addTimeUnit().addSpace().addOffet();
        return elementStr.getString();
    }

    public static String createReactionString(String inputEvent, String outputEvent, String time) {
        ContractElementBuilder elementStr = new ContractElementBuilder();
        elementStr.addGuarantee().addReaction().addEOpen().addEvent(inputEvent).addComma().addEvent(outputEvent).addEClose();
        elementStr.addWithin().addTime(time).addTimeUnit();
        return elementStr.getString();
    }

    public static String createGuaranteeString(String inputEvent, String outputEvent, String time) {
        ContractElementBuilder elementStr = new ContractElementBuilder();
        elementStr.addGuarantee().addWhenever().addEvent().addEventSpace(inputEvent).addOccursComma();
        elementStr.addThen().addEvent().addEventSpace(outputEvent).addOccurs().addWithin().addTime(time).addTimeUnit();
        return elementStr.getString();
    }

    public static String createGuaranteeTwoEvents(String inputEvent, String outputEvent, String secondOutputEvent, String time) {
        ContractElementBuilder elementStr = new ContractElementBuilder();
        elementStr.addGuarantee().addWhenever().addEvent().addEventSpace(inputEvent).addOccursComma();
        elementStr.addThen().addEvents().addEOpen().addEvent(outputEvent).addComma().addEvent(secondOutputEvent);
        elementStr.addEClose().addOccur().addWithin().addTime(time).addTimeUnit();
        return elementStr.getString();
    }
}

