/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug;

import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.fordiac.ide.deployment.debug.Messages;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.typelibrary.SystemEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;

public final class DeploymentLaunchConfigurationAttributes {
    public static final String ID = "org.eclipse.fordiac.ide.deployment.debug.deployLaunch";
    public static final String SYSTEM = "org.eclipse.fordiac.ide.deployment.debug.system";
    public static final String SELECTION = "org.eclipse.fordiac.ide.deployment.debug.selection";
    public static final String POLLING_INTERVAL = "org.eclipse.fordiac.ide.deployment.debug.pollingInterval";
    public static final int POLLING_INTERVAL_DEFAULT = 300;
    public static final String ALLOW_TERMINATE = "org.eclipse.fordiac.ide.deployment.debug.allowTerminate";
    public static final String ALLOW_TERMINATE_DEFAULT = AllowTerminate.DEBUG_ONLY.name();

    public static IResource getSystemResource(ILaunchConfiguration configuration) throws CoreException {
        String systemAttribute = configuration.getAttribute(SYSTEM, "");
        if (systemAttribute != null && !systemAttribute.isEmpty()) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(systemAttribute));
        }
        return null;
    }

    public static SystemEntry getSystemEntry(ILaunchConfiguration configuration) throws CoreException {
        IResource systemResource = DeploymentLaunchConfigurationAttributes.getSystemResource(configuration);
        if (systemResource instanceof IFile) {
            TypeEntry typeEntry;
            IFile systemFile = (IFile)systemResource;
            if (systemResource.exists() && (typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(systemFile)) instanceof SystemEntry) {
                SystemEntry systemEntry = (SystemEntry)typeEntry;
                return systemEntry;
            }
        }
        return null;
    }

    public static AutomationSystem getSystem(ILaunchConfiguration configuration) throws CoreException {
        SystemEntry systemEntry = DeploymentLaunchConfigurationAttributes.getSystemEntry(configuration);
        if (systemEntry != null) {
            return systemEntry.getSystem();
        }
        return null;
    }

    public static Set<INamedElement> getSelection(ILaunchConfiguration configuration, AutomationSystem system) throws CoreException {
        Set selectionAttribute = configuration.getAttribute(SELECTION, Collections.emptySet());
        if (selectionAttribute != null && system != null) {
            return selectionAttribute.stream().map(qualifiedName -> DeploymentLaunchConfigurationAttributes.findSelectedElement(qualifiedName, system)).flatMap(Optional::stream).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private static Optional<INamedElement> findSelectedElement(String qualifiedName, AutomationSystem system) {
        int separatorIndex = qualifiedName.indexOf(46);
        if (separatorIndex <= 0) {
            return Optional.ofNullable(system.getSystemConfiguration().getDeviceNamed(qualifiedName));
        }
        String deviceName = qualifiedName.substring(0, separatorIndex);
        String resourceName = qualifiedName.substring(separatorIndex + 1);
        Device device = system.getSystemConfiguration().getDeviceNamed(deviceName);
        if (device != null) {
            return Optional.ofNullable(device.getResourceNamed(resourceName));
        }
        return Optional.empty();
    }

    public static Duration getPollingInterval(ILaunchConfiguration configuration) throws CoreException {
        return Duration.ofMillis(configuration.getAttribute(POLLING_INTERVAL, 300));
    }

    public static AllowTerminate getAllowTerminate(ILaunchConfiguration configuration) throws CoreException {
        String allowTerminate = configuration.getAttribute(ALLOW_TERMINATE, ALLOW_TERMINATE_DEFAULT);
        return AllowTerminate.valueOf(allowTerminate);
    }

    private DeploymentLaunchConfigurationAttributes() {
        throw new UnsupportedOperationException();
    }

    public static enum AllowTerminate {
        NEVER(Messages.DeploymentLaunchConfigurationAttributes_AllowTerminate_Never),
        DEBUG_ONLY(Messages.DeploymentLaunchConfigurationAttributes_AllowTerminate_DebugOnly),
        ALWAYS(Messages.DeploymentLaunchConfigurationAttributes_AllowTerminate_Always);

        private final String displayString;

        private AllowTerminate(String displayString) {
            this.displayString = displayString;
        }

        public String getDisplayString() {
            return this.displayString;
        }
    }
}

