/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.watch;

import java.lang.runtime.SwitchBootstraps;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;

public final class DeploymentDebugWatchUtils {
    public static Resource getResource(INamedElement element) {
        Resource resource;
        INamedElement iNamedElement = element;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IInterfaceElement.class, AdapterFB.class, FBNetworkElement.class}, (Object)iNamedElement, n)) {
                case 0: {
                    IInterfaceElement interfaceElement = (IInterfaceElement)iNamedElement;
                    resource = DeploymentDebugWatchUtils.getResource((INamedElement)interfaceElement.getFBNetworkElement());
                    break block5;
                }
                case 1: {
                    AdapterFB adapterFB = (AdapterFB)iNamedElement;
                    EObject eObject = adapterFB.eContainer();
                    if (!(eObject instanceof AdapterDeclaration)) {
                        n = 2;
                        continue block5;
                    }
                    AdapterDeclaration adapterDeclaration = (AdapterDeclaration)eObject;
                    resource = DeploymentDebugWatchUtils.getResource((INamedElement)adapterDeclaration);
                    break block5;
                }
                case 2: {
                    FBNetworkElement networkElement = (FBNetworkElement)iNamedElement;
                    resource = networkElement.getResource();
                    break block5;
                }
                default: {
                    resource = null;
                }
            }
            break;
        }
        return resource;
    }

    public static Device getDevice(INamedElement element) {
        Resource resource = DeploymentDebugWatchUtils.getResource(element);
        return resource != null ? resource.getDevice() : null;
    }

    public static String getResourceRelativeName(INamedElement element, Resource resource) {
        String resourceName;
        if (element == null) {
            return "";
        }
        String qualifiedName = element.getQualifiedName();
        if (resource != null && qualifiedName.startsWith(resourceName = resource.getQualifiedName())) {
            return qualifiedName.substring(resourceName.length() + 1);
        }
        return qualifiedName;
    }

    public static boolean isSubAppInterfaceElement(IInterfaceElement interfaceElement) {
        AdapterFB adapterFB;
        FBNetworkElement fbNetworkElement = interfaceElement.getFBNetworkElement();
        return fbNetworkElement instanceof SubApp || fbNetworkElement instanceof AdapterFB && DeploymentDebugWatchUtils.isSubAppInterfaceElement((IInterfaceElement)(adapterFB = (AdapterFB)fbNetworkElement).getAdapterDecl());
    }

    public static <T extends IInterfaceElement> Stream<T> resolveSubappInterfaceConnections(T element) {
        if (element == null) {
            return Stream.empty();
        }
        FBNetworkElement fBNetworkElement = element.getFBNetworkElement();
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SubApp.class, AdapterFB.class}, (Object)fBNetworkElement, n)) {
            case -1 -> Stream.empty();
            case 0 -> {
                SubApp subapp = (SubApp)fBNetworkElement;
                subapp.loadSubAppNetwork();
                if (element.isIsInput()) {
                    yield element.getOutputConnections().stream().map(Connection::getDestination).filter(IInterfaceElement::isIsInput).flatMap(DeploymentDebugWatchUtils::resolveSubappInterfaceConnections);
                }
                yield element.getInputConnections().stream().map(Connection::getSource).filter(Predicate.not(IInterfaceElement::isIsInput)).flatMap(DeploymentDebugWatchUtils::resolveSubappInterfaceConnections);
            }
            case 1 -> {
                AdapterFB adapterFB = (AdapterFB)fBNetworkElement;
                yield DeploymentDebugWatchUtils.resolveSubappInterfaceConnections(adapterFB.getAdapterDecl()).map(AdapterDeclaration::getAdapterFB).flatMap(resolved -> resolved.findBySimpleName(element.getName())).filter(IInterfaceElement.class::isInstance);
            }
            default -> Stream.of(element);
        };
    }

    private DeploymentDebugWatchUtils() {
        throw new UnsupportedOperationException();
    }
}

