/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.iec61499.handlers;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class QueryResponseHandler
extends DefaultHandler {
    private Set<String> queryResult = new HashSet<String>();
    private boolean response = false;
    private boolean nameList = false;
    private static final String PATTERN = "([A-Za-z_]\\w+)(\\1,\\s*[A-Za-z_]\\w+)*";

    public void reset() {
        this.queryResult = new HashSet<String>();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equalsIgnoreCase("Response")) {
            this.response = true;
        } else if (qName.equalsIgnoreCase("NameList")) {
            this.nameList = true;
        } else {
            this.response = false;
            this.nameList = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.response && this.nameList) {
            String query = new String(ch, start, length);
            Pattern pattern = Pattern.compile(PATTERN);
            Matcher matcher = pattern.matcher(query);
            while (matcher.find()) {
                this.queryResult.add(matcher.group());
            }
            this.response = false;
            this.nameList = false;
        }
    }

    public Set<String> getQueryResult() {
        return this.queryResult;
    }
}

