/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import java.text.MessageFormat;
import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotation;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationStyles;
import org.eclipse.fordiac.ide.gef.editparts.IConnectionEditPartCreator;
import org.eclipse.fordiac.ide.gef.editparts.IEditPartCreator;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.ui.parts.GraphicalEditor;

public abstract class Abstract4diacEditPartFactory
implements EditPartFactory {
    private final GraphicalEditor editor;

    protected Abstract4diacEditPartFactory(GraphicalEditor editor) {
        this.editor = editor;
    }

    public GraphicalEditor getEditor() {
        return this.editor;
    }

    public EditPart createEditPart(EditPart context, Object modelElement) {
        EditPart part = null;
        try {
            if (modelElement instanceof IEditPartCreator) {
                IEditPartCreator epCreator = (IEditPartCreator)modelElement;
                part = epCreator.createEditPart();
            } else if (modelElement instanceof IConnectionEditPartCreator) {
                IConnectionEditPartCreator connCreator = (IConnectionEditPartCreator)modelElement;
                part = connCreator.createEditPart();
            } else if (modelElement instanceof GraphicalAnnotation) {
                GraphicalAnnotation annotation = (GraphicalAnnotation)modelElement;
                part = GraphicalAnnotationStyles.getAnnotationEditPart(annotation);
            } else {
                part = this.getPartForElement(context, modelElement);
            }
            if (part != null) {
                part.setModel(modelElement);
            }
        }
        catch (RuntimeException e) {
            FordiacLogHelper.logError((String)Messages.Abstract4diacEditPartFactory_ERROR_CantCreatePartForModelElement, (Throwable)e);
        }
        return part;
    }

    protected abstract EditPart getPartForElement(EditPart var1, Object var2);

    protected static RuntimeException createEditpartCreationException(Object modelElement) {
        return new RuntimeException(MessageFormat.format(Messages.Abstract4diacEditPartFactory_LABEL_RUNTIMEException_CantCreateModelForElement, modelElement != null ? modelElement.getClass().getName() : "null"));
    }
}

