/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.hierarchymanager.ui.listeners;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLMapImpl;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.HierarchyPackage;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.Leaf;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.RootLevel;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.util.HierarchyResourceFactoryImpl;
import org.eclipse.fordiac.ide.hierarchymanager.ui.handlers.AbstractHierarchyHandler;
import org.eclipse.fordiac.ide.hierarchymanager.ui.operations.AbstractChangeHierarchyOperation;
import org.eclipse.fordiac.ide.hierarchymanager.ui.operations.UpdateLeafRefOperation;
import org.eclipse.fordiac.ide.hierarchymanager.ui.util.HierarchyManagerUtil;
import org.eclipse.fordiac.ide.hierarchymanager.ui.view.PlantHierarchyView;
import org.eclipse.fordiac.ide.model.commands.QualNameChange;
import org.eclipse.fordiac.ide.model.commands.QualNameChangeListener;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class HierachyManagerUpdateListener
extends QualNameChangeListener {
    private static EObject loadPlantHierachy(IProject project) {
        HashMap<String, Object> loadOptions = new HashMap<String, Object>();
        ResourceSetImpl hierarchyResouceSet = new ResourceSetImpl();
        hierarchyResouceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("HIER", new HierarchyResourceFactoryImpl());
        hierarchyResouceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("HIER".toLowerCase(), new HierarchyResourceFactoryImpl());
        loadOptions.put("EXTENDED_META_DATA", Boolean.TRUE);
        XMLMapImpl map = new XMLMapImpl();
        map.setNoNamespacePackage((EPackage)HierarchyPackage.eINSTANCE);
        loadOptions.put("XML_MAP", map);
        hierarchyResouceSet.getLoadOptions().put("XML_MAP", map);
        return PlantHierarchyView.loadHierachyForProject(project, (ResourceSet)hierarchyResouceSet, loadOptions);
    }

    public List<AbstractOperation> constructExecutableUndoOperations(QualNameChange change, Object o) {
        return HierachyManagerUpdateListener.constructOperation(change, o, true);
    }

    protected List<AbstractOperation> constructExecutableOperations(QualNameChange qualNameChange, Object rootLevel) {
        return HierachyManagerUpdateListener.constructOperation(qualNameChange, rootLevel, false);
    }

    protected static List<AbstractOperation> constructOperation(QualNameChange qualNameChange, Object rootLevel, boolean isUndo) {
        String identifier = isUndo ? qualNameChange.newQualName() : qualNameChange.oldQualName();
        ArrayList<AbstractOperation> result = new ArrayList<AbstractOperation>();
        List<Leaf> leafs = HierarchyManagerUtil.searchLeaf((RootLevel)rootLevel, leafRef -> leafRef.contains(identifier));
        if (leafs == null || leafs.isEmpty()) {
            return Collections.emptyList();
        }
        String newRef = isUndo ? qualNameChange.oldQualName() : qualNameChange.newQualName();
        for (Leaf leaf : leafs) {
            result.add(new UpdateLeafRefOperation(leaf, newRef, identifier));
        }
        return result;
    }

    protected Object getReceiver(TypeEntry key) {
        return HierachyManagerUpdateListener.getPlantHierachy(key);
    }

    protected void executeOperation(AbstractOperation op) {
        AbstractHierarchyHandler.executeOperation((AbstractChangeHierarchyOperation)op);
    }

    private static RootLevel getPlantHierachy(TypeEntry key) {
        PlantHierarchyView view;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null && (view = (PlantHierarchyView)page.findView("org.eclipse.fordiac.ide.hierarchymanager.view")) != null) {
            return (RootLevel)view.getCommonViewer().getInput();
        }
        IProject project = key.getFile().getProject();
        return (RootLevel)HierachyManagerUpdateListener.loadPlantHierachy(project);
    }

    protected boolean isEnabled(INamedElement element) {
        return element instanceof UntypedSubApp;
    }
}

