/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.st;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.EvaluatorPrepareException;
import org.eclipse.fordiac.ide.model.eval.st.Messages;
import org.eclipse.fordiac.ide.model.eval.st.StructuredTextEvaluator;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarInOutDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarInputDeclarationBlock;

public abstract class STCallableEvaluator
extends StructuredTextEvaluator {
    private Variable<?> returnVariable;

    protected STCallableEvaluator(String name, Variable<?> context, Iterable<Variable<?>> variables, Evaluator parent) {
        super(name, context, variables, parent);
    }

    protected void prepareCallableVariables(List<? extends STVarDeclarationBlock> variables, String returnVariableName, DataType returnType) throws EvaluatorException {
        try {
            for (STVarDeclarationBlock sTVarDeclarationBlock : variables) {
                if (!STCallableEvaluator.isInput(sTVarDeclarationBlock)) continue;
                for (STVarDeclaration varDeclaration : sTVarDeclarationBlock.getVarDeclarations()) {
                    if (this.getVariables().containsKey(varDeclaration.getName()) || !varDeclaration.getCount().isEmpty()) continue;
                    this.evaluateVariableInitialization(varDeclaration);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new EvaluatorPrepareException(Messages.STCallableEvaluator_InterruptedInInitializer, (Throwable)interruptedException, (Evaluator)this);
        }
        if (returnType != null) {
            this.returnVariable = this.getVariables().computeIfAbsent(returnVariableName, name -> VariableOperations.newVariable((String)name, (INamedElement)returnType));
        }
    }

    protected void evaluateCallableVariables(List<? extends STVarDeclarationBlock> variables) throws EvaluatorException, InterruptedException {
        for (STVarDeclarationBlock sTVarDeclarationBlock : variables) {
            if (STCallableEvaluator.isInput(sTVarDeclarationBlock)) continue;
            for (STVarDeclaration varDeclaration2 : sTVarDeclarationBlock.getVarDeclarations()) {
                Variable<?> variable = this.getVariables().get(varDeclaration2.getName());
                if (variable != null) {
                    this.evaluateInitializerExpression(variable, varDeclaration2.getDefaultValue());
                    continue;
                }
                this.evaluateVariableInitialization(varDeclaration2);
            }
        }
        variables.stream().map(STVarDeclarationBlock::getVarDeclarations).flatMap(Collection::stream).filter(varDeclaration -> !this.getVariables().containsKey(varDeclaration.getName())).forEach(varDeclaration -> {
            throw new IllegalArgumentException(MessageFormat.format(Messages.STCallableEvaluator_MissingArgument, varDeclaration.getName(), this.getSourceElement().getName()));
        });
    }

    protected static boolean isInput(STVarDeclarationBlock block) {
        return block instanceof STVarInputDeclarationBlock || block instanceof STVarInOutDeclarationBlock;
    }

    public abstract ICallable getSourceElement();

    public Variable<?> getReturnVariable() {
        return this.returnVariable;
    }
}

