/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.fb;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.eval.AbstractEvaluator;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluatorEventQueue;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.variable.FBVariable;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public abstract class FBEvaluator<T extends FBType>
extends AbstractEvaluator {
    private final T type;
    private FBEvaluatorEventQueue eventQueue;

    protected FBEvaluator(T type, Variable<?> context, Iterable<Variable<?>> variables, Evaluator parent) {
        super(new FBVariable("THIS", (FBType)type, variables), parent);
        this.type = type;
    }

    @Override
    public Value evaluate() throws EvaluatorException, InterruptedException {
        if (this.eventQueue != null) {
            Event event;
            while ((event = this.eventQueue.receiveInputEvent()) != null) {
                if (!this.isApplicable(event)) {
                    throw new UnsupportedOperationException("The event " + event.getName() + " is not applicable for this evaluator");
                }
                this.evaluate(event);
            }
        }
        return null;
    }

    public abstract void evaluate(Event var1) throws EvaluatorException, InterruptedException;

    public boolean isApplicable(Event event) {
        if (event.eContainer() != null) {
            boolean bl;
            EObject eObject = event.eContainer().eContainer();
            int n = 0;
            block4: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FBType.class, AdapterFB.class}, (Object)eObject, n)) {
                    case 0: {
                        FBType fbType = (FBType)eObject;
                        if (fbType != this.type) {
                            n = 1;
                            continue block4;
                        }
                        bl = event.isIsInput();
                        break block4;
                    }
                    case 1: {
                        AdapterFB adapterFB = (AdapterFB)eObject;
                        if (adapterFB.getAdapterDecl() == null || adapterFB.getAdapterDecl().eContainer() == null || adapterFB.getAdapterDecl().eContainer().eContainer() != this.type) {
                            n = 2;
                            continue block4;
                        }
                        if (event.isIsInput()) {
                            bl = false;
                            break block4;
                        }
                        bl = true;
                        break block4;
                    }
                    default: {
                        bl = false;
                    }
                }
                break;
            }
            if (bl) {
                return true;
            }
        }
        return false;
    }

    protected boolean sendOutputEvent(Event event) {
        return this.eventQueue == null || this.eventQueue.sendOutputEvent(event);
    }

    protected boolean sendOutputEvents(Iterable<Event> events) {
        if (this.eventQueue != null) {
            for (Event event : events) {
                if (this.sendOutputEvent(event)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String getName() {
        return this.type.getName();
    }

    public FBVariable getContext() {
        return (FBVariable)super.getContext();
    }

    @Override
    public Object getSourceElement() {
        return this.type;
    }

    @Override
    public Set<String> getDependencies() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.type.eAllContents(), 0), false).map(content -> {
            EObject eObject = content;
            Objects.requireNonNull(eObject);
            EObject eObject2 = eObject;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Attribute.class, VarDeclaration.class}, (Object)eObject2, n)) {
                case 0 -> {
                    Attribute attribute = (Attribute)eObject2;
                    yield VariableOperations.getDependencies(attribute);
                }
                case 1 -> {
                    VarDeclaration varDeclaration = (VarDeclaration)eObject2;
                    yield VariableOperations.getDependencies(varDeclaration);
                }
                default -> Collections.emptySet();
            };
        }).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Map<String, Variable<?>> getVariables() {
        return this.getContext().getValue().getMembers();
    }

    @Override
    public void reset(Iterable<Variable<?>> variables) {
        this.getContext().setValue(new FBVariable("THIS", (FBType)this.type, variables).getValue());
        this.update(this.getContext().getValue().getMembers().values());
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    public T getType() {
        return this.type;
    }

    public FBEvaluatorEventQueue getEventQueue() {
        return this.eventQueue;
    }

    public void setEventQueue(FBEvaluatorEventQueue eventQueue) {
        this.eventQueue = eventQueue;
    }
}

