/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class EndpointConfiguration
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=331");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=332");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=333");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15199");
    private final Integer operationTimeout;
    private final Boolean useBinaryEncoding;
    private final Integer maxStringLength;
    private final Integer maxByteStringLength;
    private final Integer maxArrayLength;
    private final Integer maxMessageSize;
    private final Integer maxBufferSize;
    private final Integer channelLifetime;
    private final Integer securityTokenLifetime;

    public EndpointConfiguration(Integer operationTimeout, Boolean useBinaryEncoding, Integer maxStringLength, Integer maxByteStringLength, Integer maxArrayLength, Integer maxMessageSize, Integer maxBufferSize, Integer channelLifetime, Integer securityTokenLifetime) {
        this.operationTimeout = operationTimeout;
        this.useBinaryEncoding = useBinaryEncoding;
        this.maxStringLength = maxStringLength;
        this.maxByteStringLength = maxByteStringLength;
        this.maxArrayLength = maxArrayLength;
        this.maxMessageSize = maxMessageSize;
        this.maxBufferSize = maxBufferSize;
        this.channelLifetime = channelLifetime;
        this.securityTokenLifetime = securityTokenLifetime;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public Integer getOperationTimeout() {
        return this.operationTimeout;
    }

    public Boolean getUseBinaryEncoding() {
        return this.useBinaryEncoding;
    }

    public Integer getMaxStringLength() {
        return this.maxStringLength;
    }

    public Integer getMaxByteStringLength() {
        return this.maxByteStringLength;
    }

    public Integer getMaxArrayLength() {
        return this.maxArrayLength;
    }

    public Integer getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public Integer getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public Integer getChannelLifetime() {
        return this.channelLifetime;
    }

    public Integer getSecurityTokenLifetime() {
        return this.securityTokenLifetime;
    }

    protected EndpointConfiguration(EndpointConfigurationBuilder<?, ?> b) {
        super(b);
        this.operationTimeout = ((EndpointConfigurationBuilder)b).operationTimeout;
        this.useBinaryEncoding = ((EndpointConfigurationBuilder)b).useBinaryEncoding;
        this.maxStringLength = ((EndpointConfigurationBuilder)b).maxStringLength;
        this.maxByteStringLength = ((EndpointConfigurationBuilder)b).maxByteStringLength;
        this.maxArrayLength = ((EndpointConfigurationBuilder)b).maxArrayLength;
        this.maxMessageSize = ((EndpointConfigurationBuilder)b).maxMessageSize;
        this.maxBufferSize = ((EndpointConfigurationBuilder)b).maxBufferSize;
        this.channelLifetime = ((EndpointConfigurationBuilder)b).channelLifetime;
        this.securityTokenLifetime = ((EndpointConfigurationBuilder)b).securityTokenLifetime;
    }

    public static EndpointConfigurationBuilder<?, ?> builder() {
        return new EndpointConfigurationBuilderImpl();
    }

    public EndpointConfigurationBuilder<?, ?> toBuilder() {
        return new EndpointConfigurationBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EndpointConfiguration)) {
            return false;
        }
        EndpointConfiguration other = (EndpointConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$operationTimeout = this.getOperationTimeout();
        Integer other$operationTimeout = other.getOperationTimeout();
        if (this$operationTimeout == null ? other$operationTimeout != null : !((Object)this$operationTimeout).equals(other$operationTimeout)) {
            return false;
        }
        Boolean this$useBinaryEncoding = this.getUseBinaryEncoding();
        Boolean other$useBinaryEncoding = other.getUseBinaryEncoding();
        if (this$useBinaryEncoding == null ? other$useBinaryEncoding != null : !((Object)this$useBinaryEncoding).equals(other$useBinaryEncoding)) {
            return false;
        }
        Integer this$maxStringLength = this.getMaxStringLength();
        Integer other$maxStringLength = other.getMaxStringLength();
        if (this$maxStringLength == null ? other$maxStringLength != null : !((Object)this$maxStringLength).equals(other$maxStringLength)) {
            return false;
        }
        Integer this$maxByteStringLength = this.getMaxByteStringLength();
        Integer other$maxByteStringLength = other.getMaxByteStringLength();
        if (this$maxByteStringLength == null ? other$maxByteStringLength != null : !((Object)this$maxByteStringLength).equals(other$maxByteStringLength)) {
            return false;
        }
        Integer this$maxArrayLength = this.getMaxArrayLength();
        Integer other$maxArrayLength = other.getMaxArrayLength();
        if (this$maxArrayLength == null ? other$maxArrayLength != null : !((Object)this$maxArrayLength).equals(other$maxArrayLength)) {
            return false;
        }
        Integer this$maxMessageSize = this.getMaxMessageSize();
        Integer other$maxMessageSize = other.getMaxMessageSize();
        if (this$maxMessageSize == null ? other$maxMessageSize != null : !((Object)this$maxMessageSize).equals(other$maxMessageSize)) {
            return false;
        }
        Integer this$maxBufferSize = this.getMaxBufferSize();
        Integer other$maxBufferSize = other.getMaxBufferSize();
        if (this$maxBufferSize == null ? other$maxBufferSize != null : !((Object)this$maxBufferSize).equals(other$maxBufferSize)) {
            return false;
        }
        Integer this$channelLifetime = this.getChannelLifetime();
        Integer other$channelLifetime = other.getChannelLifetime();
        if (this$channelLifetime == null ? other$channelLifetime != null : !((Object)this$channelLifetime).equals(other$channelLifetime)) {
            return false;
        }
        Integer this$securityTokenLifetime = this.getSecurityTokenLifetime();
        Integer other$securityTokenLifetime = other.getSecurityTokenLifetime();
        return !(this$securityTokenLifetime == null ? other$securityTokenLifetime != null : !((Object)this$securityTokenLifetime).equals(other$securityTokenLifetime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EndpointConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $operationTimeout = this.getOperationTimeout();
        result = result * 59 + ($operationTimeout == null ? 43 : ((Object)$operationTimeout).hashCode());
        Boolean $useBinaryEncoding = this.getUseBinaryEncoding();
        result = result * 59 + ($useBinaryEncoding == null ? 43 : ((Object)$useBinaryEncoding).hashCode());
        Integer $maxStringLength = this.getMaxStringLength();
        result = result * 59 + ($maxStringLength == null ? 43 : ((Object)$maxStringLength).hashCode());
        Integer $maxByteStringLength = this.getMaxByteStringLength();
        result = result * 59 + ($maxByteStringLength == null ? 43 : ((Object)$maxByteStringLength).hashCode());
        Integer $maxArrayLength = this.getMaxArrayLength();
        result = result * 59 + ($maxArrayLength == null ? 43 : ((Object)$maxArrayLength).hashCode());
        Integer $maxMessageSize = this.getMaxMessageSize();
        result = result * 59 + ($maxMessageSize == null ? 43 : ((Object)$maxMessageSize).hashCode());
        Integer $maxBufferSize = this.getMaxBufferSize();
        result = result * 59 + ($maxBufferSize == null ? 43 : ((Object)$maxBufferSize).hashCode());
        Integer $channelLifetime = this.getChannelLifetime();
        result = result * 59 + ($channelLifetime == null ? 43 : ((Object)$channelLifetime).hashCode());
        Integer $securityTokenLifetime = this.getSecurityTokenLifetime();
        result = result * 59 + ($securityTokenLifetime == null ? 43 : ((Object)$securityTokenLifetime).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "EndpointConfiguration(operationTimeout=" + this.getOperationTimeout() + ", useBinaryEncoding=" + this.getUseBinaryEncoding() + ", maxStringLength=" + this.getMaxStringLength() + ", maxByteStringLength=" + this.getMaxByteStringLength() + ", maxArrayLength=" + this.getMaxArrayLength() + ", maxMessageSize=" + this.getMaxMessageSize() + ", maxBufferSize=" + this.getMaxBufferSize() + ", channelLifetime=" + this.getChannelLifetime() + ", securityTokenLifetime=" + this.getSecurityTokenLifetime() + ")";
    }

    private static final class EndpointConfigurationBuilderImpl
    extends EndpointConfigurationBuilder<EndpointConfiguration, EndpointConfigurationBuilderImpl> {
        private EndpointConfigurationBuilderImpl() {
        }

        @Override
        protected EndpointConfigurationBuilderImpl self() {
            return this;
        }

        @Override
        public EndpointConfiguration build() {
            return new EndpointConfiguration(this);
        }
    }

    public static abstract class EndpointConfigurationBuilder<C extends EndpointConfiguration, B extends EndpointConfigurationBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private Integer operationTimeout;
        private Boolean useBinaryEncoding;
        private Integer maxStringLength;
        private Integer maxByteStringLength;
        private Integer maxArrayLength;
        private Integer maxMessageSize;
        private Integer maxBufferSize;
        private Integer channelLifetime;
        private Integer securityTokenLifetime;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            EndpointConfigurationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(EndpointConfiguration instance, EndpointConfigurationBuilder<?, ?> b) {
            b.operationTimeout(instance.operationTimeout);
            b.useBinaryEncoding(instance.useBinaryEncoding);
            b.maxStringLength(instance.maxStringLength);
            b.maxByteStringLength(instance.maxByteStringLength);
            b.maxArrayLength(instance.maxArrayLength);
            b.maxMessageSize(instance.maxMessageSize);
            b.maxBufferSize(instance.maxBufferSize);
            b.channelLifetime(instance.channelLifetime);
            b.securityTokenLifetime(instance.securityTokenLifetime);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B operationTimeout(Integer operationTimeout) {
            this.operationTimeout = operationTimeout;
            return (B)this.self();
        }

        public B useBinaryEncoding(Boolean useBinaryEncoding) {
            this.useBinaryEncoding = useBinaryEncoding;
            return (B)this.self();
        }

        public B maxStringLength(Integer maxStringLength) {
            this.maxStringLength = maxStringLength;
            return (B)this.self();
        }

        public B maxByteStringLength(Integer maxByteStringLength) {
            this.maxByteStringLength = maxByteStringLength;
            return (B)this.self();
        }

        public B maxArrayLength(Integer maxArrayLength) {
            this.maxArrayLength = maxArrayLength;
            return (B)this.self();
        }

        public B maxMessageSize(Integer maxMessageSize) {
            this.maxMessageSize = maxMessageSize;
            return (B)this.self();
        }

        public B maxBufferSize(Integer maxBufferSize) {
            this.maxBufferSize = maxBufferSize;
            return (B)this.self();
        }

        public B channelLifetime(Integer channelLifetime) {
            this.channelLifetime = channelLifetime;
            return (B)this.self();
        }

        public B securityTokenLifetime(Integer securityTokenLifetime) {
            this.securityTokenLifetime = securityTokenLifetime;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "EndpointConfiguration.EndpointConfigurationBuilder(super=" + super.toString() + ", operationTimeout=" + this.operationTimeout + ", useBinaryEncoding=" + this.useBinaryEncoding + ", maxStringLength=" + this.maxStringLength + ", maxByteStringLength=" + this.maxByteStringLength + ", maxArrayLength=" + this.maxArrayLength + ", maxMessageSize=" + this.maxMessageSize + ", maxBufferSize=" + this.maxBufferSize + ", channelLifetime=" + this.channelLifetime + ", securityTokenLifetime=" + this.securityTokenLifetime + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<EndpointConfiguration> {
        @Override
        public Class<EndpointConfiguration> getType() {
            return EndpointConfiguration.class;
        }

        @Override
        public EndpointConfiguration decode(SerializationContext context, UaDecoder decoder) {
            Integer operationTimeout = decoder.readInt32("OperationTimeout");
            Boolean useBinaryEncoding = decoder.readBoolean("UseBinaryEncoding");
            Integer maxStringLength = decoder.readInt32("MaxStringLength");
            Integer maxByteStringLength = decoder.readInt32("MaxByteStringLength");
            Integer maxArrayLength = decoder.readInt32("MaxArrayLength");
            Integer maxMessageSize = decoder.readInt32("MaxMessageSize");
            Integer maxBufferSize = decoder.readInt32("MaxBufferSize");
            Integer channelLifetime = decoder.readInt32("ChannelLifetime");
            Integer securityTokenLifetime = decoder.readInt32("SecurityTokenLifetime");
            return new EndpointConfiguration(operationTimeout, useBinaryEncoding, maxStringLength, maxByteStringLength, maxArrayLength, maxMessageSize, maxBufferSize, channelLifetime, securityTokenLifetime);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, EndpointConfiguration value) {
            encoder.writeInt32("OperationTimeout", value.getOperationTimeout());
            encoder.writeBoolean("UseBinaryEncoding", value.getUseBinaryEncoding());
            encoder.writeInt32("MaxStringLength", value.getMaxStringLength());
            encoder.writeInt32("MaxByteStringLength", value.getMaxByteStringLength());
            encoder.writeInt32("MaxArrayLength", value.getMaxArrayLength());
            encoder.writeInt32("MaxMessageSize", value.getMaxMessageSize());
            encoder.writeInt32("MaxBufferSize", value.getMaxBufferSize());
            encoder.writeInt32("ChannelLifetime", value.getChannelLifetime());
            encoder.writeInt32("SecurityTokenLifetime", value.getSecurityTokenLifetime());
        }
    }
}

