/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.filterrow.combobox;

import java.util.Collection;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowDataLayer;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterRowComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterRowComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;

public final class ComboBoxFilterUtils {
    private ComboBoxFilterUtils() {
    }

    public static boolean isAllSelected(int columnIndex, Object cellData, IComboBoxDataProvider comboBoxDataProvider) {
        if ("SELECT_ALL".equals(cellData)) {
            return true;
        }
        if (cellData instanceof Collection) {
            Collection dataCollection = (Collection)cellData;
            List<?> dataProviderList = comboBoxDataProvider instanceof FilterRowComboBoxDataProvider ? ((FilterRowComboBoxDataProvider)comboBoxDataProvider).getAllValues(columnIndex) : comboBoxDataProvider.getValues(columnIndex, 0);
            return dataCollection.containsAll(dataProviderList);
        }
        return false;
    }

    public static boolean isFilterRowComboBoxCellEditor(IConfigRegistry configRegistry, int columnIndex) {
        ICellEditor cellEditor = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITOR, DisplayMode.NORMAL, "FILTER_COLUMN_" + columnIndex, "FILTER_ROW");
        return cellEditor instanceof FilterRowComboBoxCellEditor;
    }

    public static <T> boolean isFilterActive(FilterRowDataLayer<T> filterRowDataLayer, IComboBoxDataProvider comboBoxDataProvider, IConfigRegistry configRegistry) {
        int column = 0;
        while (column < filterRowDataLayer.getFilterRowDataProvider().getColumnCount()) {
            Object filterValue = filterRowDataLayer.getDataValue(column, 0);
            if (ComboBoxFilterUtils.isFilterRowComboBoxCellEditor(configRegistry, column) ? !ComboBoxFilterUtils.isAllSelected(column, filterValue, comboBoxDataProvider) : filterValue != null && !filterValue.toString().isEmpty()) {
                return true;
            }
            ++column;
        }
        return false;
    }
}

