/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.util;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.Messages;
import org.osgi.framework.Bundle;

public class MessageTranslator {
    public static final MessageTranslator INSTANCE = new MessageTranslator();
    private static final String PERCENT = "%";
    private static final String EMPTY = "";

    public String getMessage(Bundle bundle, String value) {
        String result = value;
        if (bundle != null && result != null && result.startsWith(PERCENT)) {
            if (bundle != null && result != null && result.startsWith("%%")) {
                return result.replaceFirst(PERCENT, EMPTY);
            }
            try {
                result = Platform.getResourceBundle((Bundle)bundle).getString(result.substring(PERCENT.length()));
            }
            catch (MissingResourceException mre) {
                DslCommonPlugin.INSTANCE.log(new Status(2, bundle.getSymbolicName(), 0, MessageFormat.format(Messages.MessageTranslator_missingResourceMessage, value), (Throwable)mre));
            }
        }
        return result;
    }

    public String getMessage(EObject eObject, String value) {
        URI uri;
        if (eObject != null && eObject.eResource() != null && (uri = eObject.eResource().getURI()) != null && uri.isPlatformPlugin() && uri.segmentCount() > 1) {
            Bundle bundle = Platform.getBundle((String)uri.segment(1));
            return INSTANCE.getMessage(bundle, value);
        }
        return value;
    }
}

