/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.widgets;

import java.util.List;
import java.util.stream.Stream;
import org.eclipse.fordiac.ide.fb.interpreter.mm.ServiceSequenceUtils;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.Messages;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.ui.widget.ComboBoxWidgetFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RecordSequenceDialog
extends MessageDialog {
    private static final int DEFAULT_RANDOMCOUNT = 3;
    private Text inputEventText;
    private Text inputParameterText;
    private Text inputCount;
    private Button appendCheckbox;
    private Button randomEventsCheckbox;
    private Button randomParametersCheckbox;
    private CCombo inputStartStateCombo;
    private final List<String> events;
    private final List<String> parameters;
    private boolean append;
    private boolean isEventBoxChecked;
    private boolean isParameterBoxChecked;
    private int count;
    private String startState;
    private Label labeldialog;
    private final FBType type;

    public RecordSequenceDialog(Shell parentShell, List<String> events, List<String> parameters, FBType type) {
        super(parentShell, Messages.RecordSequenceDialog_Title, null, Messages.RecordSequenceDialog_Info, 2, 0, new String[]{Messages.RecordSequenceDialog_Button});
        this.events = events;
        this.parameters = parameters;
        this.type = type;
    }

    protected Control createCustomArea(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Composite dialogArea = new Composite(parent, 0);
        dialogArea.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        GridLayout layout = new GridLayout(1, false);
        dialogArea.setLayout((Layout)layout);
        Composite dialogTop = new Composite(dialogArea, 0);
        dialogTop.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        dialogTop.setLayout((Layout)new GridLayout(3, false));
        this.randomEventsCheckbox = new Button(dialogTop, 32);
        this.randomEventsCheckbox.setText(Messages.RecordSequenceDialog_AddRandomEvents);
        this.randomEventsCheckbox.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.randomEventsCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RecordSequenceDialog.this.inputEventText.setEnabled(!RecordSequenceDialog.this.randomEventsCheckbox.getSelection());
                RecordSequenceDialog.this.inputParameterText.setEnabled(!RecordSequenceDialog.this.randomEventsCheckbox.getSelection());
                RecordSequenceDialog.this.inputCount.setVisible(RecordSequenceDialog.this.randomEventsCheckbox.getSelection());
                RecordSequenceDialog.this.labeldialog.setVisible(RecordSequenceDialog.this.randomEventsCheckbox.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.labeldialog = new Label(dialogTop, 0);
        this.labeldialog.setText("n=");
        this.labeldialog.setVisible(false);
        this.inputCount = new Text(dialogTop, 0);
        this.inputCount.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.inputCount.setVisible(false);
        this.randomParametersCheckbox = new Button(dialogTop, 32);
        this.randomParametersCheckbox.setText(Messages.RecordSequenceDialog_AddRandomValues);
        this.randomParametersCheckbox.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Group group = new Group(dialogArea, 0);
        group.setText(Messages.RecordSequenceDialog_ProvideInputs);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.RecordSequenceDialog_InputEvents);
        this.inputEventText = new Text((Composite)group, 16384);
        this.inputEventText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.inputEventText.setToolTipText(Messages.RecordSequenceDialog_SpecifyEventsTooltipText);
        label = new Label((Composite)group, 0);
        label.setText(Messages.RecordSequenceDialog_InitialData);
        this.inputParameterText = new Text((Composite)group, 16384);
        this.inputParameterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.inputParameterText.setToolTipText(Messages.RecordSequenceDialog_SpecifyParametersTooltipText);
        label = new Label((Composite)group, 0);
        label.setText(Messages.RecordSequenceDialog_StartState);
        this.inputStartStateCombo = ComboBoxWidgetFactory.createCombo((Composite)group);
        this.inputStartStateCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        FBType fBType = this.type;
        if (fBType instanceof BasicFBType) {
            BasicFBType bfbType = (BasicFBType)fBType;
            String[] startnames = (String[])Stream.concat(bfbType.getECC().getECState().stream().map(INamedElement::getName), Stream.of("")).toArray(String[]::new);
            this.inputStartStateCombo.setItems(startnames);
            this.inputStartStateCombo.select(0);
        } else {
            this.inputStartStateCombo.setEnabled(false);
        }
        this.appendCheckbox = new Button((Composite)group, 32);
        this.appendCheckbox.setText("Append Sequence to current Record");
        this.appendCheckbox.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        return dialogArea;
    }

    protected void buttonPressed(int buttonId) {
        this.events.addAll(this.getEvents());
        this.parameters.addAll(this.getParameters());
        this.append = this.appendCheckbox.getSelection();
        this.isEventBoxChecked = this.randomEventsCheckbox.getSelection();
        this.isParameterBoxChecked = this.randomParametersCheckbox.getSelection();
        this.count = !this.getCountText().isBlank() ? Integer.parseInt(this.getCountText()) : 3;
        int selectedStartState = this.inputStartStateCombo.getSelectionIndex();
        this.startState = selectedStartState == -1 ? "START" : this.inputStartStateCombo.getItem(selectedStartState);
        super.buttonPressed(buttonId);
    }

    private List<String> getEvents() {
        return ServiceSequenceUtils.splitAndCleanList((String)this.inputEventText.getText(), (String)";");
    }

    private List<String> getParameters() {
        return ServiceSequenceUtils.splitAndCleanList((String)this.inputParameterText.getText(), (String)";");
    }

    private String getCountText() {
        return this.inputCount.getText();
    }

    public boolean isAppend() {
        return this.append;
    }

    public boolean isRandomEventBoxChecked() {
        return this.isEventBoxChecked;
    }

    public boolean isRandomParameterBoxChecked() {
        return this.isParameterBoxChecked;
    }

    public int getCount() {
        return this.count;
    }

    public String getStartState() {
        return this.startState;
    }
}

