/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.marker.resolution;

import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.application.marker.resolution.AbstractCommandMarkerResolution;
import org.eclipse.fordiac.ide.model.commands.change.ChangeAttributeDeclarationCommand;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.typelibrary.AttributeTypeEntry;
import org.eclipse.fordiac.ide.typemanagement.util.TypeFromTemplateCreator;
import org.eclipse.fordiac.ide.typemanagement.wizards.NewTypeWizard;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Image;

public class CreateAttributMarkerResolution
extends AbstractCommandMarkerResolution<Attribute> {
    private static final String TEMPLATE_PATH = Platform.getInstallLocation().getURL().getFile() + File.separatorChar + "template" + File.separatorChar + "AttributeDeclaration.atp";
    private AttributeTypeEntry newEntry;

    protected CreateAttributMarkerResolution(IMarker marker) {
        super(marker, Attribute.class);
    }

    @Override
    protected boolean prepare(IMarker[] markers, IProgressMonitor monitor) throws CoreException {
        File template = new File(TEMPLATE_PATH);
        String typeName = this.getMarker().getAttributes().get("location").toString();
        IFile targetFile = CreateAttributMarkerResolution.getTargetFile(typeName, markers[0].getResource().getProject());
        TypeFromTemplateCreator creator = new TypeFromTemplateCreator(targetFile, template, PackageNameHelper.extractPackageName((String)typeName));
        creator.createTypeFromTemplate((IProgressMonitor)new NullProgressMonitor());
        NewTypeWizard.openTypeEditor((IFile)targetFile);
        this.newEntry = (AttributeTypeEntry)creator.getTypeEntry();
        return this.newEntry != null;
    }

    private static IFile getTargetFile(String typeName, IProject project) {
        return project.getFile(Path.fromOSString((String)"Type Library").append(typeName.replace("::", String.valueOf('/'))).addFileExtension("ATP".toLowerCase()));
    }

    @Override
    protected Command createCommand(Attribute element, IProgressMonitor monitor) throws CoreException {
        Attribute attribute = element;
        Objects.requireNonNull(attribute);
        Attribute attribute2 = attribute;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Attribute.class}, (Object)attribute2, 0)) {
            default: 
        }
        Attribute attr = attribute2;
        return ChangeAttributeDeclarationCommand.forName((Attribute)attr, (String)this.newEntry.getFullTypeName());
    }

    public String getDescription() {
        return FordiacMessages.Repair_Dialog_New_Attribute;
    }

    public Image getImage() {
        return null;
    }

    public String getLabel() {
        return FordiacMessages.Repair_Dialog_New_Attribute;
    }
}

