/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.opcua;

import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.fordiac.ide.deployment.data.ConnectionDeploymentData;
import org.eclipse.fordiac.ide.deployment.data.FBDeploymentData;
import org.eclipse.fordiac.ide.deployment.devResponse.DevResponseFactory;
import org.eclipse.fordiac.ide.deployment.devResponse.Response;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.iec61499.ResponseMapping;
import org.eclipse.fordiac.ide.deployment.interactors.ForteTypeNameCreator;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.deployment.opcua.Messages;
import org.eclipse.fordiac.ide.deployment.opcua.helpers.Constants;
import org.eclipse.fordiac.ide.deployment.util.DeploymentHelper;
import org.eclipse.fordiac.ide.deployment.util.IDeploymentListener;
import org.eclipse.fordiac.ide.deployment.util.IDeploymentListener2;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.GlobalConstantsEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.util.LibraryElementHashException;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.SessionActivityListener;
import org.eclipse.milo.opcua.sdk.client.api.UaSession;
import org.eclipse.milo.opcua.sdk.client.api.config.OpcUaClientConfig;
import org.eclipse.milo.opcua.sdk.client.api.config.OpcUaClientConfigBuilder;
import org.eclipse.milo.opcua.stack.client.DiscoveryClient;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseResultMask;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodResult;
import org.eclipse.milo.opcua.stack.core.types.structured.CallResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceDescription;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.xml.sax.InputSource;

public class OPCUADeploymentExecutor
implements IDeviceManagementInteractor {
    private final OpcUaClient client;
    private ConnectionStatus connectionStatus;
    private final Device device;
    private NodeId resourceNode;
    private final List<CallMethodRequest> requests = new ArrayList<CallMethodRequest>();
    private final List<String> requestMessages = new ArrayList<String>();
    private boolean combinedRequest = false;
    private final List<IDeploymentListener> listeners = new ArrayList<IDeploymentListener>();
    private final Map<String, NodeId> availableResources = new HashMap<String, NodeId>();
    private final ResponseMapping respMapping = new ResponseMapping();

    public OPCUADeploymentExecutor(Device dev) {
        this.device = dev;
        this.client = this.createClient();
        this.resourceNode = null;
        this.connectionStatus = ConnectionStatus.NOT_CONNECTED;
    }

    protected OpcUaClient createClient() {
        try {
            String mgrId = DeploymentHelper.getMgrID((Device)this.device);
            mgrId = mgrId.substring(1, mgrId.length() - 1);
            List endpoints = (List)DiscoveryClient.getEndpoints((String)mgrId).get();
            OpcUaClientConfigBuilder cfg = new OpcUaClientConfigBuilder();
            cfg.setEndpoint((EndpointDescription)endpoints.get(0));
            OpcUaClient newClient = OpcUaClient.create((OpcUaClientConfig)cfg.build());
            newClient.addSessionActivityListener(new SessionActivityListener(){

                public void onSessionActive(UaSession session) {
                    super.onSessionActive(session);
                    OPCUADeploymentExecutor.this.connectionStatus = ConnectionStatus.CONNECTED;
                }

                public void onSessionInactive(UaSession session) {
                    super.onSessionInactive(session);
                    OPCUADeploymentExecutor.this.connectionStatus = ConnectionStatus.DISCONNECTED;
                }
            });
            return newClient;
        }
        catch (DeploymentException e) {
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_GetMgrIDFailed, e.getMessage()), (Throwable)e);
        }
        catch (ExecutionException | UaException e) {
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_CreateClientFailed, e.getMessage()), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
        }
        return null;
    }

    protected Device getDevice() {
        return this.device;
    }

    public boolean isConnected() {
        return this.connectionStatus == ConnectionStatus.CONNECTED;
    }

    public void connect() throws DeploymentException {
        if (this.client == null) {
            throw new DeploymentException(Messages.OPCUADeploymentExecutor_CouldNotConnectToDevice);
        }
        try {
            this.client.connect().get();
            for (IDeploymentListener listener : this.listeners) {
                listener.connectionOpened(this.device);
            }
        }
        catch (ExecutionException e) {
            throw new DeploymentException(Messages.OPCUADeploymentExecutor_CouldNotConnectToDevice, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
        }
    }

    public void disconnect() throws DeploymentException {
        if (this.isConnected()) {
            try {
                this.client.disconnect().get();
                for (IDeploymentListener listener : this.listeners) {
                    listener.connectionClosed(this.device);
                }
            }
            catch (ExecutionException e) {
                throw new DeploymentException(Messages.OPCUADeploymentExecutor_CouldNotDisconnectFromDevice, (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
            }
        }
    }

    private synchronized CompletableFuture<CallMethodResult> sendREQ(String destination, CallMethodRequest request, String message) {
        return this.client.call(request).thenCompose(result -> {
            if (!result.getStatusCode().isGood()) {
                this.displayCommand((CallMethodResult)result, destination, message);
            }
            return CompletableFuture.completedFuture(result);
        });
    }

    private synchronized List<CallMethodResult> sendREQ(String destination) throws IOException {
        CallResponse response;
        try {
            response = (CallResponse)this.client.call(this.requests).get();
        }
        catch (ExecutionException e) {
            throw new IOException(MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestFailed, destination), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
            return Collections.emptyList();
        }
        return this.handleResponse(response, destination);
    }

    public void addDeploymentListener(IDeploymentListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeDeploymentListener(IDeploymentListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void createResource(Resource resource) throws DeploymentException {
        this.combinedRequest = true;
        String resName = resource.getName();
        String resType = ForteTypeNameCreator.getForteTypeName((TypeEntry)resource.getTypeEntry());
        CallMethodRequest request = new CallMethodRequest(Constants.MGMT_NODE, Constants.CREATE_RESOURCE_NODE, new Variant[]{new Variant((Object)resName), new Variant((Object)resType)});
        String message = MessageFormat.format("<Request Action=\"CREATE RESOURCE\"><FB Name=\"{0}\" Type=\"{1}\" /></Request>", resName, resType);
        CallMethodResult result = null;
        try {
            result = this.sendREQ(resName, request, message).get();
        }
        catch (ExecutionException e) {
            throw new DeploymentException(MessageFormat.format(Messages.OPCUADeploymentExecutor_CreateResourceFailed, resName), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
        }
        if (result != null) {
            this.resourceNode = OPCUADeploymentExecutor.processResult(result);
        }
    }

    public void writeResourceParameter(Resource resource, String parameter, String value) throws DeploymentException {
        String resName = resource.getName();
        CallMethodRequest request = new CallMethodRequest(Constants.MGMT_NODE, Constants.WRITE_RESOURCE_NODE, new Variant[]{new Variant((Object)resName), new Variant((Object)value)});
        String message = MessageFormat.format("<Request Action=\"WRITE RESOURCE\"><Name=\"{0}\" Value=\"{1}\" /></Request>", value);
        try {
            this.sendREQ(resName, request, message).get();
        }
        catch (ExecutionException e) {
            throw new DeploymentException(MessageFormat.format(Messages.OPCUADeploymentExecutor_WriteResourceFailed, resName), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
        }
    }

    public void writeDeviceParameter(Device device, String parameter, String value) throws DeploymentException {
        String devName = device.getName();
        CallMethodRequest request = new CallMethodRequest(Constants.MGMT_NODE, Constants.WRITE_DEVICE_NODE, new Variant[]{new Variant((Object)value)});
        String message = MessageFormat.format("<Request Action=\"WRITE DEVICE\"><Name=\"{0}\" Value=\"{1}\" /></Request>", value);
        try {
            this.sendREQ(devName, request, message).get();
        }
        catch (ExecutionException e) {
            throw new DeploymentException(MessageFormat.format(Messages.OPCUADeploymentExecutor_WriteDeviceFailed, devName), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
        }
    }

    public void createFBInstance(FBDeploymentData fbData, Resource res) throws DeploymentException {
        if (this.resourceNode == null) {
            return;
        }
        String fbType = ForteTypeNameCreator.getForteTypeName((FBNetworkElement)fbData.getFb());
        String fullFbName = MessageFormat.format("{0}{1}", fbData.getPrefix(), fbData.getFb().getName());
        if (fbType.isEmpty()) {
            throw new DeploymentException(MessageFormat.format(Messages.OPCUADeploymentExecutor_CreateFBInstanceFailedNoTypeFound, fullFbName));
        }
        CallMethodRequest request = new CallMethodRequest(this.resourceNode, Constants.CREATE_FB_NODE, new Variant[]{new Variant((Object)fullFbName), new Variant((Object)fbType)});
        String message = MessageFormat.format("<Request Action=\"CREATE FB\"><FB Name=\"{0}\" Type=\"{1}\" /></Request>", fullFbName, fbType);
        this.requests.add(request);
        this.requestMessages.add(message);
    }

    public void writeFBParameter(Resource resource, String value, FBDeploymentData fbData, VarDeclaration varDecl) throws DeploymentException {
        String destination = MessageFormat.format("{0}{1}.{2}{3}", fbData.getPrefix(), fbData.getFb().getName(), varDecl.getName(), "");
        this.writeFBParameter(resource, destination, value);
    }

    public void writeFBParameter(Resource resource, String destination, String value) throws DeploymentException {
        String message = MessageFormat.format("<Request Action=\"WRITE FB\"><Connection Destination=\"{0}\" Source=\"{1}\" /></Request>", destination, value);
        if (this.combinedRequest) {
            this.writeFBParameterCombined(destination, value, message);
        } else {
            this.writeFBParameterSingle(resource.getName(), destination, value, message);
        }
    }

    public void createConnection(Resource res, ConnectionDeploymentData connData) throws DeploymentException {
        if (this.resourceNode == null) {
            return;
        }
        IInterfaceElement sourceData = connData.source();
        IInterfaceElement destinationData = connData.destination();
        if (sourceData == null || sourceData.getBlockFBNetworkElement() == null || destinationData == null || destinationData.getBlockFBNetworkElement() == null) {
            throw new DeploymentException(MessageFormat.format(Messages.OPCUADeploymentExecutor_CreateConnectionFailedNoDataFound, res.getName()));
        }
        BlockFBNetworkElement sourceFB = sourceData.getBlockFBNetworkElement();
        BlockFBNetworkElement destinationFB = destinationData.getBlockFBNetworkElement();
        String source = MessageFormat.format("{0}{1}.{2}{3}", connData.sourcePrefix(), sourceFB.getName(), sourceData.getName(), connData.sourceSuffix());
        String destination = MessageFormat.format("{0}{1}.{2}{3}", connData.destinationPrefix(), destinationFB.getName(), destinationData.getName(), "");
        CallMethodRequest request = new CallMethodRequest(this.resourceNode, Constants.CREATE_CONNECTION_NODE, new Variant[]{new Variant((Object)source), new Variant((Object)destination)});
        String message = MessageFormat.format("<Request Action=\"CREATE CONNECTION\"><Connection Destination=\"{0}\" Source=\"{1}\" /></Request>", destination, source);
        this.requests.add(request);
        this.requestMessages.add(message);
    }

    public void startFB(Resource res, FBDeploymentData fbData) throws DeploymentException {
        if (this.resourceNode == null) {
            return;
        }
        String fullFbName = MessageFormat.format("{0}{1}", fbData.getPrefix(), fbData.getFb().getName());
        CallMethodRequest request = new CallMethodRequest(this.resourceNode, Constants.START_FB_NODE, new Variant[]{new Variant((Object)fullFbName)});
        String message = MessageFormat.format("<Request Action=\"START FB\"><FB Name=\"{0}\" Type=\"{1}\" /></Request>", fullFbName);
        try {
            this.sendREQ(res.getName(), request, message).get();
        }
        catch (ExecutionException e) {
            throw new DeploymentException(MessageFormat.format(Messages.OPCUADeploymentExecutor_StartFBFailed, fullFbName), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
        }
    }

    public void startResource(Resource resource) throws DeploymentException {
        if (this.resourceNode == null) {
            return;
        }
        String resourceName = resource.getName();
        CallMethodRequest request = new CallMethodRequest(Constants.MGMT_NODE, Constants.START_RESOURCE_NODE, new Variant[]{new Variant((Object)resourceName)});
        String message = MessageFormat.format("<Request Action=\"START RESOURCE\"/>", resourceName);
        this.requests.add(request);
        this.requestMessages.add(message);
        try {
            this.sendREQ(resourceName);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.OPCUADeploymentExecutor_StartResourceFailed, resourceName), (Throwable)e);
        }
        this.requests.clear();
        this.requestMessages.clear();
        this.combinedRequest = false;
    }

    public void startDevice(Device dev) throws DeploymentException {
        String devName = dev.getName();
        CallMethodRequest request = new CallMethodRequest(Constants.MGMT_NODE, Constants.START_DEVICE_NODE, new Variant[0]);
        String message = MessageFormat.format("<Request Action=\"START DEVICE\"/>", devName);
        try {
            this.sendREQ(devName, request, message).get();
        }
        catch (ExecutionException e) {
            throw new DeploymentException(MessageFormat.format(Messages.OPCUADeploymentExecutor_StartDeviceFailed, devName), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
        }
    }

    public void deleteResource(String resName) throws DeploymentException {
        CallMethodRequest killRequest = new CallMethodRequest(Constants.MGMT_NODE, Constants.KILL_RESOURCE_NODE, new Variant[]{new Variant((Object)resName)});
        String message = MessageFormat.format("<Request Action=\"KILL RESOURCE\"/>", resName);
        try {
            this.sendREQ(resName, killRequest, message).get();
        }
        catch (ExecutionException e) {
            throw new DeploymentException(MessageFormat.format(Messages.OPCUADeploymentExecutor_KillResourceFailed, resName), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
        }
        CallMethodRequest deleteRequest = new CallMethodRequest(Constants.MGMT_NODE, Constants.DELETE_RESOURCE_NODE, new Variant[]{new Variant((Object)resName)});
        message = MessageFormat.format("<Request Action=\"DELETE RESOURCE\"><FB Name=\"{0}\" Type=\"{1}\" /></Request>", resName);
        try {
            this.sendREQ(resName, deleteRequest, message).get();
        }
        catch (ExecutionException e) {
            throw new DeploymentException(MessageFormat.format(Messages.OPCUADeploymentExecutor_DeleteResourceFailed, resName), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
        }
    }

    public void deleteFB(Resource res, FBDeploymentData fbData) throws DeploymentException {
        if (!this.getResourcesHandle()) {
            return;
        }
        String fullFbName = MessageFormat.format("{0}{1}", fbData.getPrefix(), fbData.getFb().getName());
        String resName = res.getName();
        CallMethodRequest request = new CallMethodRequest(this.availableResources.get(resName), Constants.DELETE_FB_NODE, new Variant[]{new Variant((Object)fullFbName)});
        String message = MessageFormat.format("<Request Action=\"DELETE FB\"><FB Name=\"{0}\" /></Request>", fullFbName);
        try {
            this.sendREQ(resName, request, message).get();
        }
        catch (ExecutionException e) {
            throw new DeploymentException(MessageFormat.format(Messages.OPCUADeploymentExecutor_DeleteFBFailed, fullFbName), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
        }
    }

    public void deleteConnection(Resource res, ConnectionDeploymentData connData) throws DeploymentException {
        if (!this.getResourcesHandle()) {
            return;
        }
        IInterfaceElement sourceData = connData.source();
        IInterfaceElement destinationData = connData.destination();
        if (sourceData == null || sourceData.getBlockFBNetworkElement() == null || destinationData == null || destinationData.getBlockFBNetworkElement() == null) {
            throw new DeploymentException(Messages.OPCUADeploymentExecutor_CreateConnectionFailedNoDataFound);
        }
        BlockFBNetworkElement sourceFB = sourceData.getBlockFBNetworkElement();
        BlockFBNetworkElement destinationFB = destinationData.getBlockFBNetworkElement();
        String source = MessageFormat.format("{0}{1}.{2}{3}", connData.sourcePrefix(), sourceFB.getName(), sourceData.getName(), connData.sourceSuffix());
        String destination = MessageFormat.format("{0}{1}.{2}{3}", connData.destinationPrefix(), destinationFB.getName(), destinationData.getName(), "");
        String resName = res.getName();
        CallMethodRequest request = new CallMethodRequest(this.availableResources.get(resName), Constants.DELETE_CONNECTION_NODE, new Variant[]{new Variant((Object)source), new Variant((Object)destination)});
        String message = MessageFormat.format("<Request Action=\"DELETE CONNECTION\"><Connection Destination=\"{0}\" Source=\"{1}\" /></Request>", destination, source);
        try {
            this.sendREQ(resName, request, message).get();
        }
        catch (ExecutionException e) {
            throw new DeploymentException(MessageFormat.format(Messages.OPCUADeploymentExecutor_DeleteConnectionFailed, destination, source), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
        }
    }

    public void killDevice(Device dev) throws DeploymentException {
        String devName = dev.getName();
        CallMethodRequest request = new CallMethodRequest(Constants.MGMT_NODE, Constants.KILL_DEVICE_NODE, new Variant[0]);
        String message = MessageFormat.format("<Request Action=\"KILL DEVICE\"/>", devName);
        try {
            this.sendREQ(devName, request, message).get();
        }
        catch (ExecutionException e) {
            throw new DeploymentException(MessageFormat.format(Messages.OPCUADeploymentExecutor_KillDeviceFailed, devName), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
        }
    }

    public List<org.eclipse.fordiac.ide.deployment.devResponse.Resource> queryResources() throws DeploymentException {
        CallMethodRequest request = new CallMethodRequest(Constants.MGMT_NODE, Constants.QUERY_RESOURCES_NODE, new Variant[0]);
        String message = "<Request Action=\"QUERY\"></Request>";
        try {
            CallMethodResult result = this.sendREQ("", request, "<Request Action=\"QUERY\"></Request>").get();
            Response response = this.parseResponse(result, "<Response>\n  <FBList>\n    {0}\n  </FBList>\n</Response>");
            if (response == Constants.EMPTY_RESPONSE) {
                FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_ErrorOnQueryResources, OPCUADeploymentExecutor.getIEC61499Status(result.getStatusCode())));
            }
            return OPCUADeploymentExecutor.getQueryElements(response);
        }
        catch (IOException | ExecutionException e) {
            throw new DeploymentException(Messages.OPCUADeploymentExecutor_QueryResourcesFailed, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public Response queryFBType(FBTypeEntry entry) throws DeploymentException {
        try {
            String hashedFBType = OPCUADeploymentExecutor.getTypeNameWithHash((TypeEntry)entry);
            CallMethodRequest request = new CallMethodRequest(Constants.MGMT_NODE, Constants.QUERY_FB_TYPE_NODE, new Variant[]{new Variant((Object)hashedFBType)});
            String message = MessageFormat.format("<Request Action=\"QUERY\"><FBType Name=\"{0}\" /></Request>", hashedFBType);
            CallMethodResult result = this.sendREQ("", request, message).get();
            Response response = this.parseResponse(result, "<Response>\n  {0}\n</Response>");
            if (response == Constants.EMPTY_RESPONSE) {
                FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_ErrorOnQueryDataType, OPCUADeploymentExecutor.getIEC61499Status(result.getStatusCode())));
            }
            return response;
        }
        catch (IOException | ExecutionException | LibraryElementHashException e) {
            throw new DeploymentException(Messages.OPCUADeploymentExecutor_QueryFBTypeFailed, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
            return Constants.EMPTY_RESPONSE;
        }
    }

    public Response queryDataType(DataTypeEntry entry) throws DeploymentException {
        try {
            String hashedDataType = OPCUADeploymentExecutor.getTypeNameWithHash((TypeEntry)entry);
            CallMethodRequest request = new CallMethodRequest(Constants.MGMT_NODE, Constants.QUERY_DATA_TYPE_NODE, new Variant[]{new Variant((Object)hashedDataType)});
            String message = MessageFormat.format("<Request Action=\"QUERY\"><DataType Name=\"{0}\" /></Request>", hashedDataType);
            CallMethodResult result = this.sendREQ("", request, message).get();
            Response response = this.parseResponse(result, "<Response>\n  {0}\n</Response>");
            if (response == Constants.EMPTY_RESPONSE) {
                FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_ErrorOnQueryDataType, OPCUADeploymentExecutor.getIEC61499Status(result.getStatusCode())));
            }
            return response;
        }
        catch (IOException | ExecutionException | LibraryElementHashException e) {
            throw new DeploymentException(Messages.OPCUADeploymentExecutor_QueryDataTypeFailed, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
            return Constants.EMPTY_RESPONSE;
        }
    }

    public Response queryGlobalConstType(GlobalConstantsEntry entry) throws DeploymentException {
        try {
            String hashedGlobalConstType = OPCUADeploymentExecutor.getTypeNameWithHash((TypeEntry)entry);
            CallMethodRequest request = new CallMethodRequest(Constants.MGMT_NODE, Constants.QUERY_GLOBAL_CONST_TYPE_NODE, new Variant[]{new Variant((Object)hashedGlobalConstType)});
            String message = MessageFormat.format("<Request Action=\"QUERY\"><GlobalConstType Name=\"{0}\" /></Request>", hashedGlobalConstType);
            CallMethodResult result = this.sendREQ("", request, message).get();
            Response response = this.parseResponse(result, "<Response>\n  {0}\n</Response>");
            if (response == Constants.EMPTY_RESPONSE) {
                FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_ErrorOnQueryDataType, OPCUADeploymentExecutor.getIEC61499Status(result.getStatusCode())));
            }
            return response;
        }
        catch (IOException | ExecutionException | LibraryElementHashException e) {
            throw new DeploymentException(Messages.OPCUADeploymentExecutor_QueryGlobalConstTypeFailed, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
            return Constants.EMPTY_RESPONSE;
        }
    }

    private static String getTypeNameWithHash(TypeEntry entry) throws LibraryElementHashException {
        String hash = entry.getTypeHash();
        if (hash.isEmpty()) {
            return ForteTypeNameCreator.getForteTypeName((TypeEntry)entry);
        }
        return ForteTypeNameCreator.getForteTypeName((TypeEntry)entry) + "#" + hash;
    }

    public Response readWatches() throws DeploymentException {
        CallMethodRequest request = new CallMethodRequest(Constants.MGMT_NODE, Constants.READ_WATCHES_NODE, new Variant[0]);
        String message = "<Request Action=\"READ\"><Watches/></Request>";
        try {
            CallMethodResult result = this.sendREQ("", request, "<Request Action=\"READ\"><Watches/></Request>").get();
            return this.parseResponse(result, "<Response>\n  <Watches>\n    {0}\n  </Watches>\n</Response>");
        }
        catch (IOException | ExecutionException e) {
            throw new DeploymentException(Messages.OPCUADeploymentExecutor_ReadWatchesFailed, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
            return Constants.EMPTY_RESPONSE;
        }
    }

    public boolean addWatch(Resource resource, String fullFbName) throws DeploymentException {
        CallMethodResult result;
        if (this.availableResources.isEmpty() && !this.getResourcesHandle()) {
            return false;
        }
        String resName = resource.getName();
        CallMethodRequest request = new CallMethodRequest(this.availableResources.get(resName), Constants.ADD_WATCH_NODE, new Variant[]{new Variant((Object)fullFbName)});
        String message = MessageFormat.format("<Request Action=\"ADD WATCH\"><Connection Destination=\"{0}\" /></Request>", fullFbName);
        try {
            result = this.sendREQ(resName, request, message).get();
        }
        catch (ExecutionException e) {
            throw new DeploymentException(MessageFormat.format(Messages.OPCUADeploymentExecutor_AddWatchFailed, fullFbName), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
            return false;
        }
        StatusCode opcuaStatus = result.getStatusCode();
        OPCUADeploymentExecutor.logResponseStatus(opcuaStatus, resName, fullFbName, Messages.OPCUADeploymentExecutor_ErrorOnMonitoringRequest);
        return !"Unknown".equals(OPCUADeploymentExecutor.getIEC61499Status(opcuaStatus));
    }

    public boolean removeWatch(Resource resource, String fullFbName) throws DeploymentException {
        CallMethodResult result;
        if (this.availableResources.isEmpty() && !this.getResourcesHandle()) {
            return false;
        }
        String resName = resource.getName();
        CallMethodRequest request = new CallMethodRequest(this.availableResources.get(resName), Constants.REMOVE_WATCH_NODE, new Variant[]{new Variant((Object)fullFbName)});
        String message = MessageFormat.format("<Request Action=\"REMOVE WATCH\"><Connection Destination=\"{0}\" /></Request>", fullFbName);
        try {
            result = this.sendREQ(resName, request, message).get();
        }
        catch (ExecutionException e) {
            throw new DeploymentException(MessageFormat.format(Messages.OPCUADeploymentExecutor_RemoveWatchFailed, fullFbName), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
            return false;
        }
        StatusCode opcuaStatus = result.getStatusCode();
        OPCUADeploymentExecutor.logResponseStatus(opcuaStatus, resName, fullFbName, Messages.OPCUADeploymentExecutor_ErrorOnMonitoringRequest);
        return !"Unknown".equals(OPCUADeploymentExecutor.getIEC61499Status(opcuaStatus));
    }

    public void triggerEvent(Resource resource, String fullFbName) throws DeploymentException {
        CallMethodResult result;
        if (this.availableResources.isEmpty() && !this.getResourcesHandle()) {
            return;
        }
        String resName = resource.getName();
        CallMethodRequest request = new CallMethodRequest(this.availableResources.get(resName), Constants.TRIGGER_EVENT_NODE, new Variant[]{new Variant((Object)fullFbName)});
        String message = MessageFormat.format("<Request Action=\"WRITE\"><Connection Destination=\"{0}\" /></Request>", fullFbName);
        try {
            result = this.sendREQ(resName, request, message).get();
        }
        catch (ExecutionException e) {
            throw new DeploymentException(MessageFormat.format(Messages.OPCUADeploymentExecutor_TriggerEventFailed, fullFbName), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
            return;
        }
        OPCUADeploymentExecutor.logResponseStatus(result.getStatusCode(), resName, fullFbName, Messages.OPCUADeploymentExecutor_ErrorOnMonitoringRequest);
    }

    public void forceValue(Resource resource, String fullFbName, String value) throws DeploymentException {
        CallMethodResult result;
        if (this.availableResources.isEmpty() && !this.getResourcesHandle()) {
            return;
        }
        String resName = resource.getName();
        CallMethodRequest request = new CallMethodRequest(this.availableResources.get(resName), Constants.FORCE_VALUE_NODE, new Variant[]{new Variant((Object)fullFbName), new Variant((Object)value)});
        String message = MessageFormat.format("<Request Action=\"WRITE\"><Connection Destination=\"{0}\" Value=\"{1}\" /></Request>", fullFbName);
        try {
            result = this.sendREQ(resName, request, message).get();
        }
        catch (ExecutionException e) {
            throw new DeploymentException(MessageFormat.format(Messages.OPCUADeploymentExecutor_ForceValueFailed, fullFbName), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
            return;
        }
        OPCUADeploymentExecutor.logResponseStatus(result.getStatusCode(), resName, fullFbName, Messages.OPCUADeploymentExecutor_ErrorOnMonitoringRequest);
    }

    public void clearForce(Resource resource, String fullFbName) throws DeploymentException {
        CallMethodResult result;
        if (this.availableResources.isEmpty() && !this.getResourcesHandle()) {
            return;
        }
        String resName = resource.getName();
        CallMethodRequest request = new CallMethodRequest(this.availableResources.get(resName), Constants.CLEAR_FORCE_NODE, new Variant[]{new Variant((Object)fullFbName)});
        String message = MessageFormat.format("<Request Action=\"WRITE\"><Connection Destination=\"{0}\" /></Request>", fullFbName);
        try {
            result = this.sendREQ(resName, request, message).get();
        }
        catch (ExecutionException e) {
            throw new DeploymentException(MessageFormat.format(Messages.OPCUADeploymentExecutor_ClearForceFailed, fullFbName), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
            return;
        }
        OPCUADeploymentExecutor.logResponseStatus(result.getStatusCode(), resName, fullFbName, Messages.OPCUADeploymentExecutor_ErrorOnMonitoringRequest);
    }

    public void readTraces(Device device, String path) throws DeploymentException {
        String devName = device.getName();
        try {
            CallMethodRequest request = new CallMethodRequest(Constants.MGMT_NODE, Constants.READ_TRACES_NODE, new Variant[]{new Variant((Object)path)});
            CallMethodResult result = this.sendREQ(devName, request, MessageFormat.format("<Request Action=\"READ TRACES\"><Connection Destination=\"{0}\" Source=\"{1}\" /></Request>", devName, path)).get();
            if (!result.getStatusCode().isGood()) {
                throw new DeploymentException(MessageFormat.format(Messages.OPCUADeploymentExecutor_ReadTracesFailed, devName));
            }
        }
        catch (ExecutionException e) {
            throw new DeploymentException(MessageFormat.format(Messages.OPCUADeploymentExecutor_ReadTracesFailed, devName), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
        }
    }

    public Optional<String> replayNextEvent(Resource resource) throws DeploymentException {
        String resName = resource.getName();
        if (this.availableResources.isEmpty() && !this.getResourcesHandle()) {
            throw new DeploymentException(MessageFormat.format(Messages.OPCUADeploymentExecutor_ResourceNotFoundError, resName, this.device.getName()));
        }
        try {
            CallMethodRequest request = new CallMethodRequest(this.availableResources.get(resName), Constants.REPLAY_NEXT_EVENT_NODE, new Variant[0]);
            CallMethodResult result = this.sendREQ(resName, request, MessageFormat.format("<Request Action=\"REPLAY NEXT EVENT\"><Connection Destination=\"{0}\"/></Request>", resName)).get();
            if (!result.getStatusCode().isGood()) {
                throw new DeploymentException(MessageFormat.format(Messages.OPCUADeploymentExecutor_ReplayNextEventFailed, resName));
            }
            String returnedValue = (String)result.getOutputArguments()[0].getValue();
            return returnedValue.isEmpty() ? Optional.empty() : Optional.of(returnedValue);
        }
        catch (ExecutionException e) {
            throw new DeploymentException(MessageFormat.format(Messages.OPCUADeploymentExecutor_ReplayNextEventFailed, resName), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
            return Optional.empty();
        }
    }

    private CompletableFuture<StatusCode> browseResources() {
        BrowseDescription browse = new BrowseDescription(Constants.MGMT_NODE, BrowseDirection.Forward, Identifiers.References, Boolean.TRUE, Unsigned.uint((int)NodeClass.Object.getValue()), Unsigned.uint((int)BrowseResultMask.All.getValue()));
        return this.client.browse(browse).thenCompose(result -> {
            List references = ConversionUtil.toList((Object[])result.getReferences());
            for (ReferenceDescription rd : references) {
                rd.getNodeId().toNodeId(this.client.getNamespaceTable()).ifPresent(nodeId -> {
                    NodeId nodeId2 = this.availableResources.put(rd.getBrowseName().getName(), (NodeId)nodeId);
                });
            }
            return CompletableFuture.completedFuture(result.getStatusCode());
        });
    }

    private boolean getResourcesHandle() throws DeploymentException {
        StatusCode status = StatusCode.BAD;
        try {
            status = this.browseResources().get();
        }
        catch (ExecutionException e) {
            throw new DeploymentException(Messages.OPCUADeploymentExecutor_BrowseOPCUAFailed);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
        }
        return status.isGood() && !this.availableResources.isEmpty();
    }

    private void writeFBParameterCombined(String destination, String value, String message) {
        if (this.resourceNode == null) {
            return;
        }
        CallMethodRequest request = new CallMethodRequest(this.resourceNode, Constants.WRITE_FB_NODE, new Variant[]{new Variant((Object)destination), new Variant((Object)value)});
        this.requests.add(request);
        this.requestMessages.add(message);
    }

    private void writeFBParameterSingle(String resName, String destination, String value, String message) throws DeploymentException {
        CallMethodResult result;
        if (!this.availableResources.containsKey(resName) && !this.getResourcesHandle()) {
            return;
        }
        CallMethodRequest request = new CallMethodRequest(this.availableResources.get(resName), Constants.WRITE_FB_NODE, new Variant[]{new Variant((Object)destination), new Variant((Object)value)});
        try {
            result = this.sendREQ(resName, request, message).get();
        }
        catch (ExecutionException e) {
            throw new DeploymentException(MessageFormat.format(Messages.OPCUADeploymentExecutor_WriteFBFailed, destination, value), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_RequestInterrupted, e.getMessage()), (Throwable)e);
            return;
        }
        OPCUADeploymentExecutor.logResponseStatus(result.getStatusCode(), resName, destination, Messages.OPCUADeploymentExecutor_ErrorOnWriteRequest);
    }

    private String getDestinationInfo(String destination) {
        Object info = this.client.getConfig().getEndpoint().getEndpointUrl();
        if (!destination.equals("")) {
            info = (String)info + ": " + destination;
        }
        return info;
    }

    private static List<org.eclipse.fordiac.ide.deployment.devResponse.Resource> getQueryElements(Response response) {
        if (response.getFblist() == null || response.getFblist().getFbs() == null) {
            return Collections.emptyList();
        }
        return response.getFblist().getFbs().stream().map(fb -> {
            org.eclipse.fordiac.ide.deployment.devResponse.Resource res = DevResponseFactory.eINSTANCE.createResource();
            res.setName(fb.getName());
            res.setType(fb.getType());
            return res;
        }).toList();
    }

    /*
     * WARNING - void declaration
     */
    private Response parseResponse(CallMethodResult result, String responseTyp) throws IOException {
        void response;
        Object object;
        if (result == null || !((object = result.getOutputArguments()[0].getValue()) instanceof String)) {
            return Constants.EMPTY_RESPONSE;
        }
        String string = (String)object;
        return this.parseXMLResponse(MessageFormat.format(responseTyp, response));
    }

    private Response parseXMLResponse(String encodedResponse) throws IOException {
        if (encodedResponse != null) {
            InputSource source = new InputSource(new StringReader(encodedResponse));
            XMLResourceImpl xmlResource = new XMLResourceImpl();
            xmlResource.load(source, this.respMapping.getLoadOptions());
            for (EObject object : xmlResource.getContents()) {
                if (!(object instanceof Response)) continue;
                Response response = (Response)object;
                return response;
            }
        }
        return Constants.EMPTY_RESPONSE;
    }

    private static NodeId processResult(CallMethodResult result) {
        StatusCode statusCode = result.getStatusCode();
        if (statusCode.isGood()) {
            return (NodeId)result.getOutputArguments()[0].getValue();
        }
        StatusCode[] inputArgumentResults = result.getInputArgumentResults();
        if (inputArgumentResults != null) {
            int i = 0;
            while (i < inputArgumentResults.length) {
                FordiacLogHelper.logInfo((String)MessageFormat.format("Input Argument Result {0}: {1}", i, inputArgumentResults[i]));
                ++i;
            }
        }
        return null;
    }

    private List<CallMethodResult> handleResponse(CallResponse response, String destination) {
        List<CallMethodResult> results = Arrays.asList(response.getResults());
        if (results.size() != this.requestMessages.size()) {
            FordiacLogHelper.logInfo((String)"Result list size does not match number of requests!");
        }
        int i = 0;
        while (i < results.size()) {
            CallMethodResult result = results.get(i);
            if (!result.getStatusCode().isGood()) {
                String message = this.requestMessages.get(i);
                this.displayCommand(result, destination, message);
            }
            ++i;
        }
        return results;
    }

    private void displayCommand(CallMethodResult result, String destination, String requestMessage) {
        String info = this.getDestinationInfo(destination);
        String responseMessage = OPCUADeploymentExecutor.getMessagFromResult(result);
        for (IDeploymentListener listener : this.listeners) {
            listener.postCommandSent(info, destination, requestMessage);
        }
        for (IDeploymentListener listener : this.listeners) {
            if (listener instanceof IDeploymentListener2) {
                IDeploymentListener2 listener2 = (IDeploymentListener2)listener;
                listener2.postResponseReceived(info, requestMessage, responseMessage, destination);
                continue;
            }
            listener.postResponseReceived(responseMessage, destination);
        }
    }

    private static String getMessagFromResult(CallMethodResult result) {
        Object object;
        Variant outArg = result.getOutputArguments()[0];
        if (outArg != null && (object = outArg.getValue()) instanceof String) {
            String response = (String)object;
            return MessageFormat.format("<Response Reason=\"{0}\">{1}</Response>", OPCUADeploymentExecutor.getIEC61499Status(result.getStatusCode()), response);
        }
        return MessageFormat.format("<Response Reason=\"{0}\"/>", OPCUADeploymentExecutor.getIEC61499Status(result.getStatusCode()));
    }

    private static void logResponseStatus(StatusCode opcuaStatus, String resourceName, String errorElement, String messageTemplate) {
        if (!opcuaStatus.isGood()) {
            FordiacLogHelper.logError((String)MessageFormat.format(messageTemplate, OPCUADeploymentExecutor.getIEC61499Status(opcuaStatus), resourceName, errorElement));
        }
    }

    private static String getIEC61499Status(StatusCode opcuaStatus) {
        String status = Constants.RESPONSE_MAP.get(opcuaStatus.getValue());
        if (status != null) {
            return status;
        }
        FordiacLogHelper.logInfo((String)MessageFormat.format(Messages.OPCUADeploymentExecutor_UnknownResponseCode, opcuaStatus.toString()));
        return "Unknown";
    }

    public void resetResource(String resName) throws DeploymentException {
    }

    public void killResource(String resName) throws DeploymentException {
    }

    public void stopResource(Resource res) throws DeploymentException {
    }

    public static enum ConnectionStatus {
        CONNECTED,
        DISCONNECTED,
        NOT_CONNECTED;

    }
}

