/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search.st;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.search.st.StructuredTextSearchSupport;
import org.eclipse.fordiac.ide.structuredtextalgorithm.util.STAlgorithmParseUtil;
import org.eclipse.xtext.parser.IParseResult;

public class VarDeclarationSearchSupport
extends StructuredTextSearchSupport {
    private final VarDeclaration varDeclaration;
    private IParseResult parseResultType;
    private IParseResult parseResult;

    public VarDeclarationSearchSupport(VarDeclaration varDeclaration) {
        this.varDeclaration = varDeclaration;
    }

    @Override
    public Set<String> getImportedNamespaces() {
        Set<String> result = super.getImportedNamespaces();
        if (!VarDeclarationSearchSupport.isContainedInTypedInstance((EObject)this.varDeclaration) && !PackageNameHelper.getPackageName((LibraryElement)this.varDeclaration.getType()).isEmpty()) {
            result.add(PackageNameHelper.getFullTypeName((LibraryElement)this.varDeclaration.getType()));
        }
        return result;
    }

    @Override
    public Stream<EObject> prepare() {
        return Stream.of(this.prepareResultType(), this.prepareInitialValue()).filter(Objects::nonNull).map(IParseResult::getRootASTElement);
    }

    protected IParseResult prepareResultType() {
        if (this.parseResultType == null && this.varDeclaration.isArray() && !VarDeclarationSearchSupport.isContainedInTypedInstance((EObject)this.varDeclaration)) {
            this.parseResultType = STAlgorithmParseUtil.parseTypeDeclaration((String)this.varDeclaration.getFullTypeName(), (EObject)this.varDeclaration);
        }
        return this.parseResultType;
    }

    protected IParseResult prepareInitialValue() {
        if (this.parseResult == null && this.varDeclaration.getValue() != null && this.varDeclaration.getValue().getValue() != null && !this.varDeclaration.getValue().getValue().isBlank()) {
            this.parseResult = STAlgorithmParseUtil.parseInitializerExpression((String)this.varDeclaration.getValue().getValue(), null, (EObject)this.varDeclaration);
        }
        return this.parseResult;
    }

    public boolean isIncompleteResult() {
        return this.parseResultType != null && this.parseResultType.hasSyntaxErrors() || this.parseResult != null && this.parseResult.hasSyntaxErrors();
    }

    public static boolean isContainedInTypedInstance(EObject element) {
        while ((element = element.eContainer()) != null) {
            FBNetworkElement fbne;
            if (!(element instanceof FBNetworkElement) || (fbne = (FBNetworkElement)element).getTypeEntry() == null) continue;
            return true;
        }
        return false;
    }
}

