/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.marker.resolution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.fordiac.ide.model.errormarker.FordiacErrorMarker;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.systemmanagement.nature.FordiacNature;
import org.eclipse.fordiac.ide.systemmanagement.ui.Messages;
import org.eclipse.fordiac.ide.systemmanagement.ui.marker.resolution.WorkspaceMarkerResolution;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class WrongBuilderOrderMarkerResolution
extends WorkspaceMarkerResolution {
    @Override
    protected void runInWorkspace(IMarker[] markers, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)markers.length);
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            subMonitor.subTask(marker.getAttribute("message", ""));
            IProject project = marker.getResource().getProject();
            IProjectDescription description = project.getDescription();
            ArrayList<ICommand> commands = new ArrayList<ICommand>(Arrays.asList(description.getBuildSpec()));
            commands.sort((o1, o2) -> Integer.compare(FordiacNature.getBuilderPriority((String)o2.getBuilderName()), FordiacNature.getBuilderPriority((String)o1.getBuilderName())));
            description.setBuildSpec((ICommand[])commands.toArray(ICommand[]::new));
            project.setDescription(description, (IProgressMonitor)subMonitor.split(1));
            SystemManager.validateProjectNature((IProject)project);
            ++n2;
        }
    }

    public String getLabel() {
        return Messages.WrongBuilderOrderMarkerResolution_Label;
    }

    public String getDescription() {
        return Messages.WrongBuilderOrderMarkerResolution_Description;
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD");
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        return (IMarker[])Stream.of(markers).filter(other -> FordiacNature.class.getName().equals(FordiacErrorMarker.getSource((IMarker)other)) && 4 == FordiacErrorMarker.getCode((IMarker)other)).toArray(IMarker[]::new);
    }
}

