/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ui.interpreter.completeocl.internal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import org.eclipse.acceleo.ui.interpreter.language.CompilationResult;
import org.eclipse.acceleo.ui.interpreter.language.EvaluationContext;
import org.eclipse.acceleo.ui.interpreter.language.SplitExpression;
import org.eclipse.acceleo.ui.interpreter.language.SubExpression;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.pivot.CallExp;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.IfExp;
import org.eclipse.ocl.examples.pivot.LetExp;
import org.eclipse.ocl.examples.pivot.LiteralExp;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.VariableExp;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.util.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteOCLExpressionSplittingTask
implements Callable<SplitExpression> {
    private EvaluationContext context;
    private final MetaModelManager metaModelManager;

    public CompleteOCLExpressionSplittingTask(EvaluationContext context, MetaModelManager metaModelManager) {
        this.context = context;
        this.metaModelManager = metaModelManager;
    }

    @Override
    public SplitExpression call() throws Exception {
        this.checkCancelled();
        CompilationResult compilationResult = this.context.getCompilationResult();
        if (compilationResult == null || compilationResult.getStatus() != null && compilationResult.getStatus().getSeverity() != 0) {
            return null;
        }
        Object expression = compilationResult.getCompiledExpression();
        SplitExpression result = expression instanceof Root ? this.splitCompleteOCLExpression((Root)expression) : null;
        return result;
    }

    private SplitExpression splitCompleteOCLExpression(Root root) {
        ArrayList<SubExpression> children = new ArrayList<SubExpression>();
        for (Package pack : root.getNestedPackage()) {
            this.checkCancelled();
            children.add(this.splitCompleteOCLExpression(pack));
        }
        return new SplitExpression((Object)root, children, "All Expressions");
    }

    private SubExpression splitCompleteOCLExpression(Package pack) {
        SubExpression packageStep = new SubExpression((Object)pack, "Package - " + pack.getName());
        LinkedHashMap<Type, LinkedHashSet<Type>> types = new LinkedHashMap<Type, LinkedHashSet<Type>>();
        for (Type type : pack.getOwnedType()) {
            Type key = this.metaModelManager.getTypeServer((DomainType)type).getPivotType();
            LinkedHashSet<Type> relatedTypes = (LinkedHashSet<Type>)types.get(key);
            if (relatedTypes == null) {
                relatedTypes = new LinkedHashSet<Type>();
                types.put(key, relatedTypes);
            }
            relatedTypes.add(type);
        }
        this.checkCancelled();
        for (Map.Entry entry : types.entrySet()) {
            this.checkCancelled();
            packageStep.addSubStep(this.splitCompleteOCLExpression(entry));
        }
        for (Constraint constraint : pack.getOwnedRule()) {
            this.checkCancelled();
            packageStep.addSubStep(this.splitCompleteOCLExpression(constraint));
        }
        return packageStep;
    }

    private SubExpression splitCompleteOCLExpression(Map.Entry<Type, Set<Type>> relatedTypes) {
        SubExpression typeStep = new SubExpression((Object)relatedTypes.getKey(), "Context - " + relatedTypes.getKey());
        for (Type type : relatedTypes.getValue()) {
            this.checkCancelled();
            for (Constraint constraint : type.getOwnedInvariant()) {
                this.checkCancelled();
                typeStep.addSubStep(this.splitCompleteOCLExpression(constraint));
            }
            for (Operation operation : type.getOwnedOperation()) {
                this.checkCancelled();
                if (operation.getParameterTypes().get().length != 0) continue;
                typeStep.addSubStep(this.splitCompleteOCLExpression(operation));
            }
        }
        return typeStep;
    }

    private SubExpression splitCompleteOCLExpression(Constraint constraint) {
        SubExpression constraintSteps = new SubExpression((Object)constraint, "Constraint - " + constraint.getName());
        constraintSteps.addSubStep(this.splitExpression(constraint.getSpecification().getExpressionInOCL()));
        return constraintSteps;
    }

    private SubExpression splitCompleteOCLExpression(Operation operation) {
        SubExpression operationSteps = new SubExpression((Object)operation, "Operation - " + operation.getName());
        operationSteps.addSubStep(this.splitExpression(operation.getBodyExpression().getExpressionInOCL()));
        return operationSteps;
    }

    private SubExpression splitExpression(ExpressionInOCL expression) {
        SplittingVisitor visitor = new SplittingVisitor(expression);
        visitor.visitExpressionInOCL(expression);
        SubExpression expressionStep = new SubExpression((Object)expression);
        for (SubExpression subStep : visitor.getSubExpressions()) {
            expressionStep.addSubStep(subStep);
        }
        return expressionStep;
    }

    private void checkCancelled() {
        if (Thread.currentThread().isInterrupted()) {
            throw new CancellationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SplittingVisitor
    extends AbstractExtendingVisitor<SubExpression, ExpressionInOCL> {
        private LinkedList<SubExpression> expressionStack = new LinkedList();

        public SplittingVisitor(ExpressionInOCL expressionInOCL) {
            super((Object)expressionInOCL);
        }

        public SubExpression visitExpressionInOCL(ExpressionInOCL object) {
            this.expressionStack.addFirst(new SubExpression((Object)object.getBodyExpression()));
            return (SubExpression)object.getBodyExpression().accept((Visitor)this);
        }

        public SubExpression visiting(Visitable visitable) {
            return null;
        }

        public SubExpression visitOperationCallExp(OperationCallExp object) {
            for (OCLExpression expression : object.getArgument()) {
                this.addAndVisitSubStep(expression);
            }
            SubExpression result = (SubExpression)super.visitOperationCallExp(object);
            return result;
        }

        public SubExpression visitLetExp(LetExp object) {
            this.addChild(new SubExpression((Object)object));
            object.getVariable().accept((Visitor)this);
            return this.addAndVisitSubStep(object.getIn());
        }

        public SubExpression visitVariable(Variable object) {
            return this.addAndVisitSubStep(object.getInitExpression());
        }

        public SubExpression visitIfExp(IfExp object) {
            this.addChild(new SubExpression((Object)object));
            SubExpression result = (SubExpression)super.visitIfExp(object);
            this.addAndVisitSubStep(object.getCondition());
            this.addAndVisitSubStep(object.getThenExpression());
            this.addAndVisitSubStep(object.getElseExpression());
            return result;
        }

        public SubExpression visitVariableExp(VariableExp object) {
            this.addChild(new SubExpression((Object)object));
            return (SubExpression)super.visitVariableExp(object);
        }

        public SubExpression visitLiteralExp(LiteralExp object) {
            this.addChild(new SubExpression((Object)object));
            return (SubExpression)super.visitLiteralExp(object);
        }

        public SubExpression visitCallExp(CallExp object) {
            this.addChild(new SubExpression((Object)object));
            return this.addAndVisitSubStep(object.getSource());
        }

        public List<SubExpression> getSubExpressions() {
            return this.expressionStack.pop().getSubSteps();
        }

        private SubExpression addAndVisitSubStep(OCLExpression subStep) {
            SubExpression subExpression = new SubExpression((Object)subStep);
            this.addChild(subExpression);
            this.expressionStack.addFirst(subExpression);
            subStep.accept((Visitor)this);
            this.expressionStack.pop();
            return subExpression;
        }

        private void addChild(SubExpression subExpression) {
            SubExpression parent = this.expressionStack.peek();
            if (!parent.getExpression().equals(subExpression.getExpression())) {
                parent.addSubStep(subExpression);
            }
        }
    }
}

