/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor;

import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoSourceContent;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.AbstractRefactoringWithVariableContextAction;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.acceleo.parser.cst.ModuleElement;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class ExtractAsTemplateAction
extends AbstractRefactoringWithVariableContextAction {
    public static final String ACTION_ID = "org.eclipse.acceleo.ide.ui.editors.template.actions.refactor.extractAsTemplate";
    public static final String COMMAND_ID = "org.eclipse.acceleo.ide.ui.extractAsTemplate";

    protected int modify(IDocument document, AcceleoSourceContent content, int offset, int length) throws BadLocationException {
        CSTNode parentNode;
        int newOffset = document.getLength();
        CSTNode currentNode = content.getCSTNode(offset, offset + length);
        String paramType = this.getCurrentVariableTypeName(currentNode, "Type");
        String paramName = this.getCurrentVariableName(currentNode, "arg");
        if (currentNode instanceof ModuleElement) {
            newOffset = ((ModuleElement)currentNode).getEndPosition();
        } else if (currentNode != null && (parentNode = content.getCSTParent(currentNode, ModuleElement.class)) instanceof ModuleElement) {
            newOffset = ((ModuleElement)parentNode).getEndPosition();
        }
        String templateName = "new" + paramType + "Template";
        StringBuilder newText = new StringBuilder();
        if (newOffset > 0) {
            newText.append('\n');
            if (!"\n".equals(document.get(newOffset - 1, 1))) {
                newText.append("\n");
            }
        }
        int selectAndReveal = newOffset + newText.length();
        String templateContent = document.get(offset, length);
        newText.append(this.getNewTemplateText(templateName, paramType, paramName, templateContent));
        document.replace(newOffset, 0, newText.toString());
        String templateCall = "[new" + paramType + "Template()/]";
        document.replace(offset, length, templateCall);
        return selectAndReveal += templateCall.length() - length;
    }

    private String getNewTemplateText(String templateName, String paramType, String paramName, String templateContent) {
        StringBuilder newText = new StringBuilder();
        newText.append("[template public " + templateName + " (");
        newText.append(paramName);
        newText.append(" : ");
        newText.append(paramType);
        newText.append(") ]\n");
        newText.append(templateContent);
        newText.append('\n');
        newText.append("[/template]");
        return newText.toString();
    }
}

