/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ui.interpreter.ocl;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import org.eclipse.acceleo.ui.interpreter.language.CompilationResult;
import org.eclipse.acceleo.ui.interpreter.language.EvaluationContext;
import org.eclipse.acceleo.ui.interpreter.language.EvaluationResult;
import org.eclipse.acceleo.ui.interpreter.ocl.AbstractOCLEvaluator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLEvaluationTask
extends AbstractOCLEvaluator
implements Callable<EvaluationResult> {
    private final EvaluationContext context;
    private final MetaModelManager metaModelManager;

    public OCLEvaluationTask(EvaluationContext context, MetaModelManager metaModelManager) {
        this.context = context;
        this.metaModelManager = metaModelManager;
    }

    @Override
    protected MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    @Override
    public EvaluationResult call() throws Exception {
        this.checkCancelled();
        CompilationResult compilationResult = this.context.getCompilationResult();
        EvaluationResult shortcut = null;
        if (compilationResult == null || !this.checkExpression(compilationResult)) {
            shortcut = new EvaluationResult((IStatus)new Status(4, "org.eclipse.acceleo.ui.interpreter.ocl", "Compilation error in expression."));
        } else if (compilationResult.getStatus() != null && compilationResult.getStatus().getSeverity() != 0) {
            shortcut = new EvaluationResult(null);
        }
        if (shortcut != null) {
            return shortcut;
        }
        this.checkCancelled();
        EvaluationResult result = new EvaluationResult((IStatus)new Status(4, "org.eclipse.acceleo.ui.interpreter.ocl", "Unknown error evaluating expression."));
        EObject evaluationTarget = (EObject)this.context.getTargetEObjects().get(0);
        assert (compilationResult != null);
        if (compilationResult.getCompiledExpression() instanceof ExpressionInOCL) {
            ExpressionInOCL expression = (ExpressionInOCL)compilationResult.getCompiledExpression();
            result = this.evaluateExpression(expression, evaluationTarget);
        } else if (compilationResult.getCompiledExpression() instanceof OCLExpression) {
            OCLExpression compiledExpression = (OCLExpression)compilationResult.getCompiledExpression();
            result = this.evaluateExpression(compiledExpression, evaluationTarget);
        }
        return result;
    }

    private boolean checkExpression(CompilationResult compilationResult) {
        Object expression = compilationResult.getCompiledExpression();
        return expression instanceof ExpressionInOCL || expression instanceof OCLExpression;
    }

    private void checkCancelled() {
        if (Thread.currentThread().isInterrupted()) {
            throw new CancellationException();
        }
    }
}

