/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.query.ast.AstPackage;
import org.eclipse.acceleo.query.ast.BooleanLiteral;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.CallType;
import org.eclipse.acceleo.query.ast.CollectionTypeLiteral;
import org.eclipse.acceleo.query.ast.EnumLiteral;
import org.eclipse.acceleo.query.ast.ErrorCollectionCall;
import org.eclipse.acceleo.query.ast.ErrorExpression;
import org.eclipse.acceleo.query.ast.ErrorFeatureAccessOrCall;
import org.eclipse.acceleo.query.ast.ErrorTypeLiteral;
import org.eclipse.acceleo.query.ast.ErrorVariableDeclaration;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.FeatureAccess;
import org.eclipse.acceleo.query.ast.IntegerLiteral;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.ast.NullLiteral;
import org.eclipse.acceleo.query.ast.RealLiteral;
import org.eclipse.acceleo.query.ast.SequenceInExtensionLiteral;
import org.eclipse.acceleo.query.ast.SetInExtensionLiteral;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.parser.AstEvaluator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class AstBuilder {
    public EnumLiteral enumLiteral(EEnumLiteral eLiteral) {
        EnumLiteral literal = (EnumLiteral)EcoreUtil.create((EClass)AstPackage.Literals.ENUM_LITERAL);
        literal.setLiteral(eLiteral);
        return literal;
    }

    public IntegerLiteral integerLiteral(int i) {
        IntegerLiteral literal = (IntegerLiteral)EcoreUtil.create((EClass)AstPackage.Literals.INTEGER_LITERAL);
        literal.setValue(i);
        return literal;
    }

    public RealLiteral realLiteral(double i) {
        RealLiteral literal = (RealLiteral)EcoreUtil.create((EClass)AstPackage.Literals.REAL_LITERAL);
        literal.setValue(i);
        return literal;
    }

    public StringLiteral stringLiteral(String str) {
        StringLiteral literal = (StringLiteral)EcoreUtil.create((EClass)AstPackage.Literals.STRING_LITERAL);
        literal.setValue(AstBuilder.stripSlashes(str));
        return literal;
    }

    public static String stripSlashes(String text) {
        int end = text.length();
        StringBuilder res = new StringBuilder(end);
        int i = 0;
        while (i < end) {
            char c = text.charAt(i);
            if (c != '\\') {
                res.append(c);
            } else {
                char c1 = text.charAt(++i);
                switch (c1) {
                    case 'b': {
                        res.append('\b');
                        break;
                    }
                    case 't': {
                        res.append('\t');
                        break;
                    }
                    case 'n': {
                        res.append('\n');
                        break;
                    }
                    case 'f': {
                        res.append('\f');
                        break;
                    }
                    case 'r': {
                        res.append('\r');
                        break;
                    }
                    case '\\': {
                        res.append('\\');
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid escape sequence : " + c + c1);
                    }
                }
            }
            ++i;
        }
        return res.toString();
    }

    public BooleanLiteral booleanLiteral(boolean bool) {
        BooleanLiteral literal = (BooleanLiteral)EcoreUtil.create((EClass)AstPackage.Literals.BOOLEAN_LITERAL);
        literal.setValue(bool);
        return literal;
    }

    public CollectionTypeLiteral collectionTypeLiteral(Object type, TypeLiteral elementType) {
        if (type != List.class && type != Set.class) {
            throw new IllegalArgumentException("collection type must be either list or set.");
        }
        CollectionTypeLiteral literal = (CollectionTypeLiteral)EcoreUtil.create((EClass)AstPackage.Literals.COLLECTION_TYPE_LITERAL);
        literal.setValue(type);
        literal.setElementType(elementType);
        return literal;
    }

    public TypeLiteral typeLiteral(Object type) {
        if (!(type instanceof Class) && !(type instanceof EClassifier)) {
            throw new IllegalArgumentException("type argument must be a Class or an EClass instance : " + type);
        }
        TypeLiteral typeLiteral = (TypeLiteral)EcoreUtil.create((EClass)AstPackage.Literals.TYPE_LITERAL);
        typeLiteral.setValue(type);
        return typeLiteral;
    }

    public Call callService(CallType type, String serviceName, Expression ... args) {
        Call call = (Call)EcoreUtil.create((EClass)AstPackage.Literals.CALL);
        call.setType(type);
        call.setServiceName(serviceName);
        call.getArguments().addAll((Collection)Lists.newArrayList((Object[])args));
        return call;
    }

    public VarRef varRef(String name) {
        VarRef ref = (VarRef)EcoreUtil.create((EClass)AstPackage.Literals.VAR_REF);
        ref.setVariableName(name);
        return ref;
    }

    public FeatureAccess featureAccess(Expression target, String featureName) {
        FeatureAccess res = (FeatureAccess)EcoreUtil.create((EClass)AstPackage.Literals.FEATURE_ACCESS);
        res.setTarget(target);
        res.setFeatureName(featureName);
        return res;
    }

    public Lambda lambda(Expression expression, AstEvaluator evaluator, VariableDeclaration ... parameters) {
        Lambda lambda = (Lambda)EcoreUtil.create((EClass)AstPackage.Literals.LAMBDA);
        lambda.setExpression(expression);
        lambda.setEvaluator(evaluator);
        ArrayList params = Lists.newArrayList((Object[])parameters);
        lambda.getParameters().addAll((Collection)params);
        return lambda;
    }

    public ErrorExpression errorExpression() {
        return (ErrorExpression)EcoreUtil.create((EClass)AstPackage.Literals.ERROR_EXPRESSION);
    }

    public ErrorTypeLiteral errorTypeLiteral(String ... segments) {
        ErrorTypeLiteral result = (ErrorTypeLiteral)EcoreUtil.create((EClass)AstPackage.Literals.ERROR_TYPE_LITERAL);
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (segment != null && segment.length() != 0) {
                result.getSegments().add((Object)segment);
            }
            ++n2;
        }
        return result;
    }

    public ErrorFeatureAccessOrCall errorFeatureAccessOrCall(Expression target) {
        ErrorFeatureAccessOrCall result = (ErrorFeatureAccessOrCall)EcoreUtil.create((EClass)AstPackage.Literals.ERROR_FEATURE_ACCESS_OR_CALL);
        result.setTarget(target);
        return result;
    }

    public ErrorCollectionCall errorCollectionCall(Expression target) {
        ErrorCollectionCall result = (ErrorCollectionCall)EcoreUtil.create((EClass)AstPackage.Literals.ERROR_COLLECTION_CALL);
        result.setTarget(target);
        return result;
    }

    public VariableDeclaration variableDeclaration(String name, Expression expression) {
        VariableDeclaration result = (VariableDeclaration)EcoreUtil.create((EClass)AstPackage.Literals.VARIABLE_DECLARATION);
        result.setName(name);
        result.setExpression(expression);
        return result;
    }

    public VariableDeclaration variableDeclaration(String name, TypeLiteral type, Expression expression) {
        VariableDeclaration result = this.variableDeclaration(name, expression);
        result.setType(type);
        return result;
    }

    public NullLiteral nullLiteral() {
        return (NullLiteral)EcoreUtil.create((EClass)AstPackage.Literals.NULL_LITERAL);
    }

    public SetInExtensionLiteral setInExtension(List<Expression> expressions) {
        SetInExtensionLiteral result = (SetInExtensionLiteral)EcoreUtil.create((EClass)AstPackage.Literals.SET_IN_EXTENSION_LITERAL);
        result.getValues().addAll(expressions);
        return result;
    }

    public SequenceInExtensionLiteral sequenceInExtension(List<Expression> expressions) {
        SequenceInExtensionLiteral result = (SequenceInExtensionLiteral)EcoreUtil.create((EClass)AstPackage.Literals.SEQUENCE_IN_EXTENSION_LITERAL);
        result.getValues().addAll(expressions);
        return result;
    }

    public ErrorVariableDeclaration errorVariableDeclaration(Expression expression) {
        ErrorVariableDeclaration result = (ErrorVariableDeclaration)EcoreUtil.create((EClass)AstPackage.Literals.ERROR_VARIABLE_DECLARATION);
        result.setExpression(expression);
        return result;
    }
}

