/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.acceleo.query.collections.LazyList;
import org.eclipse.acceleo.query.runtime.CrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.impl.AbstractServiceProvider;
import org.eclipse.acceleo.query.runtime.impl.EPackageProvider;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.runtime.lookup.basic.Service;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;

public class EObjectServices
extends AbstractServiceProvider {
    private CrossReferenceProvider crossReferencer;

    @Override
    protected IService getService(Method publicMethod) {
        Service result = publicMethod.getParameterTypes().length == 2 && EClassifier.class.isAssignableFrom(publicMethod.getParameterTypes()[1]) ? new Service(publicMethod, this){

            @Override
            public Set<IType> getType(ValidationServices services, EPackageProvider provider, List<IType> argTypes) {
                LinkedHashSet<IType> result = new LinkedHashSet<IType>();
                EClassifierType rawType = new EClassifierType(((EClassifierLiteralType)argTypes.get(1)).getType());
                if (List.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                    result.add(new SequenceType(rawType));
                } else if (Set.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                    result.add(new SetType(rawType));
                } else {
                    result.add(rawType);
                }
                return result;
            }
        } : ("eContents".equals(publicMethod.getName()) ? new Service(publicMethod, this){

            @Override
            public Set<IType> getType(ValidationServices services, EPackageProvider provider, List<IType> argTypes) {
                Set<IType> result;
                if (argTypes.size() == 1 && argTypes.get(0).getType() instanceof EClass) {
                    EClass eCls = (EClass)argTypes.get(0).getType();
                    result = new LinkedHashSet<IType>();
                    for (EStructuralFeature feature : eCls.getEAllStructuralFeatures()) {
                        if (!(feature instanceof EReference) || !((EReference)feature).isContainment() || !(feature.getEType() instanceof EClass)) continue;
                        result.add(new SequenceType(new EClassifierType(((EReference)feature).getEType())));
                    }
                } else {
                    result = super.getType(services, provider, argTypes);
                }
                return result;
            }
        } : ("eContainer".equals(publicMethod.getName()) ? new Service(publicMethod, this){

            @Override
            public Set<IType> getType(ValidationServices services, EPackageProvider provider, List<IType> argTypes) {
                Set<IType> result;
                if (argTypes.size() == 1 && argTypes.get(0).getType() instanceof EClass) {
                    EClass eCls = (EClass)argTypes.get(0).getType();
                    result = new LinkedHashSet<IType>();
                    for (EClass containingEClass : provider.getAllContainingEClasses(eCls)) {
                        result.add(new EClassifierType((EClassifier)containingEClass));
                    }
                    if (result.size() == 0) {
                        result.add(new NothingType("No EObject can contain " + eCls.getName()));
                    }
                } else {
                    result = super.getType(services, provider, argTypes);
                }
                return result;
            }
        } : new Service(publicMethod, this)));
        return result;
    }

    public List<EObject> eAllContents(EObject eObject) {
        return new LazyList<EObject>(new EObjectIterableAdapter(eObject));
    }

    public List<EObject> eAllContents(EObject eObject, final EClass type) {
        return new LazyList<EObject>(Iterables.filter((Iterable)new EObjectIterableAdapter(eObject), (Predicate)new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return type.isSuperTypeOf(input.eClass());
            }
        }));
    }

    public List<EObject> eContents(EObject eObject) {
        return eObject.eContents();
    }

    public List<EObject> eContents(EObject eObject, final EClass type) {
        return new LazyList<EObject>(Iterables.filter((Iterable)eObject.eContents(), (Predicate)new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return type.isSuperTypeOf(input.eClass());
            }
        }));
    }

    public EObject eContainer(EObject eObject) {
        return eObject.eContainer();
    }

    public EObject eContainer(EObject eObject, EClass type) {
        EObject current = eObject.eContainer();
        while (current != null && !type.isSuperTypeOf(current.eClass())) {
            current = current.eContainer();
        }
        EObject result = current != null && type.isSuperTypeOf(current.eClass()) ? current : null;
        return result;
    }

    public EClass eClass(EObject eObject) {
        return eObject.eClass();
    }

    public void setCrossReferencer(CrossReferenceProvider crossReferencer) {
        this.crossReferencer = crossReferencer;
    }

    public Set<EObject> eInverse(EObject self) {
        LinkedHashSet result;
        Collection<EStructuralFeature.Setting> settings = this.crossReferencer.getInverseReferences(self);
        if (settings == null) {
            result = Collections.emptySet();
        } else {
            result = Sets.newLinkedHashSet();
            for (EStructuralFeature.Setting setting : settings) {
                result.add(setting.getEObject());
            }
        }
        return result;
    }

    public Set<EObject> eInverse(EObject self, EClassifier filter) {
        LinkedHashSet result;
        Collection<EStructuralFeature.Setting> settings = this.crossReferencer.getInverseReferences(self);
        if (settings == null || filter == null) {
            result = Collections.emptySet();
        } else {
            result = Sets.newLinkedHashSet();
            for (EStructuralFeature.Setting setting : settings) {
                if (!filter.isInstance((Object)setting.getEObject())) continue;
                result.add(setting.getEObject());
            }
        }
        return result;
    }

    public Set<EObject> eInverse(EObject self, String featureName) {
        LinkedHashSet result;
        Collection<EStructuralFeature.Setting> settings = this.crossReferencer.getInverseReferences(self);
        if (settings == null) {
            result = Collections.emptySet();
        } else {
            result = Sets.newLinkedHashSet();
            for (EStructuralFeature.Setting setting : settings) {
                if (!setting.getEStructuralFeature().getName().equals(featureName)) continue;
                result.add(setting.getEObject());
            }
        }
        return result;
    }

    public List<EObject> ancestors(EObject object) {
        return this.ancestors(object, null);
    }

    public List<EObject> ancestors(EObject object, EClassifier filter) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        EObject container = object.eContainer();
        while (container != null) {
            if (filter == null || filter.isInstance((Object)container)) {
                result.add(container);
            }
            container = container.eContainer();
        }
        return result;
    }

    public Object eGet(EObject source, String featureName) {
        for (EStructuralFeature feature : source.eClass().getEAllStructuralFeatures()) {
            if (!feature.getName().equals(featureName)) continue;
            return source.eGet(feature);
        }
        return null;
    }

    public Object followingSiblings(EObject eObject) {
        return this.siblings(eObject, null, false);
    }

    public Object followingSiblings(EObject eObject, EClassifier filter) {
        return this.siblings(eObject, filter, false);
    }

    public Object precedingSiblings(EObject eObject) {
        return this.siblings(eObject, null, true);
    }

    public Object precedingSiblings(EObject eObject, EClassifier filter) {
        return this.siblings(eObject, filter, true);
    }

    public Object siblings(EObject eObject) {
        return this.siblings(eObject, null);
    }

    public Object siblings(final EObject eObject, final EClassifier filter) {
        Object container = this.getContainer(eObject);
        if (container != null) {
            return new LazyList(Iterables.filter(this.getContents(container), (Predicate)new Predicate<EObject>(){

                public boolean apply(EObject input) {
                    return input != eObject && (filter == null || filter.isInstance((Object)input.eClass()) || filter.equals(input.eClass()));
                }
            }));
        }
        return Collections.emptyList();
    }

    private List<EObject> siblings(EObject eObject, final EClassifier filter, Boolean preceding) {
        Object container = this.getContainer(eObject);
        if (container != null) {
            List<EObject> siblings = this.getContents(container);
            int startIndex = 0;
            int endIndex = siblings.size();
            if (preceding.booleanValue()) {
                endIndex = siblings.indexOf(eObject);
            } else {
                startIndex = siblings.indexOf(eObject) + 1;
            }
            return new LazyList<EObject>(Iterables.filter(siblings.subList(startIndex, endIndex), (Predicate)new Predicate<EObject>(){

                public boolean apply(EObject input) {
                    return filter == null || filter.isInstance((Object)input.eClass()) || filter.equals(input.eClass());
                }
            }));
        }
        return Collections.emptyList();
    }

    private Object getContainer(EObject object) {
        EObject result = object.eContainer();
        if (result == null && object instanceof InternalEObject) {
            result = ((InternalEObject)object).eDirectResource();
        }
        return result;
    }

    private List<EObject> getContents(Object container) {
        List<Object> contents = container instanceof EObject ? this.getContents((EObject)container) : (container instanceof Resource ? this.getRoots((Resource)container) : Collections.emptyList());
        return contents;
    }

    private List<EObject> getContents(EObject eObject) {
        ArrayList<EObject> result = new ArrayList<EObject>((Collection<EObject>)eObject.eContents());
        for (EReference reference : eObject.eClass().getEAllReferences()) {
            if (!reference.isContainment() || !reference.isDerived()) continue;
            Object value = eObject.eGet((EStructuralFeature)reference);
            if (value instanceof Collection) {
                for (Object newValue : (Collection)value) {
                    if (result.contains(newValue) || !(newValue instanceof EObject)) continue;
                    result.add((EObject)newValue);
                }
                continue;
            }
            if (result.contains(value) || !(value instanceof EObject)) continue;
            result.add((EObject)value);
        }
        return result;
    }

    private List<EObject> getRoots(Resource resource) {
        Object result = resource.getContents();
        ListIterator iter = result.listIterator();
        while (iter.hasNext()) {
            if (((EObject)iter.next()).eContainer() == null) continue;
            int where = iter.previousIndex();
            ArrayList newResult = new ArrayList(result.size() - 1);
            newResult.addAll(result.subList(0, where));
            result = newResult;
            while (iter.hasNext()) {
                EObject next = (EObject)iter.next();
                if (next.eContainer() != null) continue;
                result.add(next);
            }
        }
        return result;
    }

    private class EObjectIterableAdapter
    implements Iterable<EObject> {
        private EObject root;

        public EObjectIterableAdapter(EObject root) {
            this.root = root;
        }

        @Override
        public Iterator<EObject> iterator() {
            return this.root.eAllContents();
        }
    }
}

