/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.acceleo.query.ast.Binding;
import org.eclipse.acceleo.query.ast.BooleanLiteral;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.CollectionTypeLiteral;
import org.eclipse.acceleo.query.ast.Conditional;
import org.eclipse.acceleo.query.ast.EnumLiteral;
import org.eclipse.acceleo.query.ast.Error;
import org.eclipse.acceleo.query.ast.ErrorCollectionCall;
import org.eclipse.acceleo.query.ast.ErrorExpression;
import org.eclipse.acceleo.query.ast.ErrorFeatureAccessOrCall;
import org.eclipse.acceleo.query.ast.ErrorTypeLiteral;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.FeatureAccess;
import org.eclipse.acceleo.query.ast.IntegerLiteral;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.ast.Let;
import org.eclipse.acceleo.query.ast.NullLiteral;
import org.eclipse.acceleo.query.ast.RealLiteral;
import org.eclipse.acceleo.query.ast.SequenceInExtensionLiteral;
import org.eclipse.acceleo.query.ast.SetInExtensionLiteral;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.ast.util.AstSwitch;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.ValidationMessageLevel;
import org.eclipse.acceleo.query.runtime.impl.ValidationMessage;
import org.eclipse.acceleo.query.runtime.impl.ValidationResult;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.LambdaType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.ecore.EClassifier;

public class AstValidator
extends AstSwitch<Set<IType>> {
    private static final String VARIABLE_OVERRIDES_AN_EXISTING_VALUE = "Variable %s overrides an existing value.";
    private static final String SHOULD_NEVER_HAPPEN = "should never happen";
    protected ValidationResult validationResult;
    private final ValidationServices services;
    private final Stack<Map<String, Set<IType>>> variableTypesStack = new Stack();

    public AstValidator(IQueryEnvironment environment, Map<String, Set<IType>> variableTypes) {
        this.variableTypesStack.push(variableTypes);
        this.services = new ValidationServices(environment);
    }

    private Set<IType> checkWarningsAndErrors(Expression expression, Set<IType> types) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        ArrayList<ValidationMessage> msgs = new ArrayList<ValidationMessage>();
        for (IType type : types) {
            if (type instanceof NothingType) {
                IQueryBuilderEngine.AstResult astResult = this.validationResult.getAstResult();
                int startPostion = expression instanceof Call ? astResult.getEndPosition((Expression)((Call)expression).getArguments().get(0)) : (expression instanceof FeatureAccess ? astResult.getEndPosition(((FeatureAccess)expression).getTarget()) : astResult.getStartPosition(expression));
                int endPosition = astResult.getEndPosition(expression);
                msgs.add(new ValidationMessage(ValidationMessageLevel.WARNING, ((NothingType)type).getMessage(), startPostion, endPosition));
                continue;
            }
            result.add(type);
        }
        if (result.size() == 0) {
            for (ValidationMessage message : msgs) {
                message.setLevel(ValidationMessageLevel.ERROR);
            }
        }
        this.validationResult.getMessages().addAll(msgs);
        this.validationResult.addTypes(expression, result);
        return result;
    }

    @Override
    public Set<IType> caseBooleanLiteral(BooleanLiteral object) {
        Set<IType> possibleTypes = this.services.getIType(Boolean.class);
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseCall(Call object) {
        Set<IType> possibleTypes;
        ArrayList<Set<IType>> argTypes = new ArrayList<Set<IType>>();
        for (Expression arg : object.getArguments()) {
            argTypes.add((Set)this.doSwitch(arg));
        }
        String serviceName = object.getServiceName();
        switch (object.getType()) {
            case CALLSERVICE: {
                possibleTypes = this.services.callType(serviceName, argTypes);
                break;
            }
            case CALLORAPPLY: {
                possibleTypes = this.services.callOrApplyTypes(serviceName, argTypes);
                break;
            }
            case COLLECTIONCALL: {
                possibleTypes = this.services.collectionServiceCallTypes(serviceName, argTypes);
                break;
            }
            default: {
                throw new UnsupportedOperationException(SHOULD_NEVER_HAPPEN);
            }
        }
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseCollectionTypeLiteral(CollectionTypeLiteral object) {
        LinkedHashSet<IType> possibleTypes = new LinkedHashSet<IType>();
        for (IType type : (Set)this.doSwitch(object.getElementType())) {
            if (object.getValue() == List.class) {
                possibleTypes.add(new SequenceType(this.services.getQueryEnvironment(), type));
                continue;
            }
            if (object.getValue() == Set.class) {
                possibleTypes.add(new SetType(this.services.getQueryEnvironment(), type));
                continue;
            }
            throw new UnsupportedOperationException(SHOULD_NEVER_HAPPEN);
        }
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseEnumLiteral(EnumLiteral object) {
        LinkedHashSet<IType> possibleTypes = new LinkedHashSet<IType>();
        possibleTypes.add(new EClassifierType(this.services.getQueryEnvironment(), (EClassifier)object.getLiteral().getEEnum()));
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseFeatureAccess(FeatureAccess object) {
        Set reveiverTypes = (Set)this.doSwitch(object.getTarget());
        String featureName = object.getFeatureName();
        Set<IType> flattened = this.services.featureAccessTypes(reveiverTypes, featureName);
        return this.checkWarningsAndErrors(object, flattened);
    }

    @Override
    public Set<IType> caseIntegerLiteral(IntegerLiteral object) {
        Set<IType> possibleTypes = this.services.getIType(Integer.class);
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseLambda(Lambda object) {
        LinkedHashSet<IType> lambdaExpressionTypes = new LinkedHashSet<IType>();
        HashMap<String, Set<IType>> newVariableTypes = new HashMap<String, Set<IType>>(this.variableTypesStack.peek());
        for (VariableDeclaration variableDeclaration : object.getParameters()) {
            LinkedHashSet<IType> types;
            if (variableDeclaration.getType() == null || variableDeclaration.getType() instanceof Error) {
                Set variableTypes = (Set)this.doSwitch(variableDeclaration.getExpression());
                types = new LinkedHashSet<IType>();
                for (IType type : variableTypes) {
                    if (type instanceof ICollectionType) {
                        types.add(((ICollectionType)type).getCollectionType());
                        continue;
                    }
                    types.add(type);
                }
            } else {
                types = (LinkedHashSet<IType>)this.doSwitch(variableDeclaration.getType());
            }
            if (newVariableTypes.containsKey(variableDeclaration.getName())) {
                lambdaExpressionTypes.add(this.services.nothing(VARIABLE_OVERRIDES_AN_EXISTING_VALUE, variableDeclaration.getName()));
            }
            newVariableTypes.put(variableDeclaration.getName(), types);
        }
        this.variableTypesStack.push(newVariableTypes);
        Set lambdaExpressionPossibleTypes = (Set)this.doSwitch(object.getExpression());
        Set lambdaEvaluatorPossibleTypes = (Set)newVariableTypes.get(((VariableDeclaration)object.getParameters().get(0)).getName());
        for (IType lambdaEvaluatorPossibleType : lambdaEvaluatorPossibleTypes) {
            for (IType lambdaExpressionType : lambdaExpressionPossibleTypes) {
                lambdaExpressionTypes.add(new LambdaType(this.services.getQueryEnvironment(), lambdaEvaluatorPossibleType, lambdaExpressionType));
            }
        }
        this.variableTypesStack.pop();
        return lambdaExpressionTypes;
    }

    @Override
    public Set<IType> caseRealLiteral(RealLiteral object) {
        Set<IType> possibleTypes = this.services.getIType(Double.class);
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseStringLiteral(StringLiteral object) {
        Set<IType> possibleTypes = this.services.getIType(String.class);
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseVarRef(VarRef object) {
        Set<IType> variableTypes = this.services.getVariableTypes(this.variableTypesStack.peek(), object.getVariableName());
        return this.checkWarningsAndErrors(object, variableTypes);
    }

    public IValidationResult validate(IQueryBuilderEngine.AstResult astResult) {
        this.validationResult = new ValidationResult(astResult);
        this.doSwitch(astResult.getAst());
        return this.validationResult;
    }

    @Override
    public Set<IType> caseTypeLiteral(TypeLiteral object) {
        LinkedHashSet<IType> possibleTypes;
        if (object.getValue() instanceof EClassifier) {
            possibleTypes = new LinkedHashSet<EClassifierLiteralType>();
            possibleTypes.add(new EClassifierLiteralType(this.services.getQueryEnvironment(), (EClassifier)object.getValue()));
        } else if (object.getValue() instanceof Class) {
            possibleTypes = this.services.getIType((Class)object.getValue());
        } else {
            throw new UnsupportedOperationException(SHOULD_NEVER_HAPPEN);
        }
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseErrorCollectionCall(ErrorCollectionCall object) {
        this.doSwitch(object.getTarget());
        return this.checkWarningsAndErrors(object, this.services.getErrorTypes(object));
    }

    @Override
    public Set<IType> caseErrorExpression(ErrorExpression object) {
        return this.checkWarningsAndErrors(object, this.services.getErrorTypes(object));
    }

    @Override
    public Set<IType> caseErrorFeatureAccessOrCall(ErrorFeatureAccessOrCall object) {
        this.doSwitch(object.getTarget());
        return this.checkWarningsAndErrors(object, this.services.getErrorTypes(object));
    }

    @Override
    public Set<IType> caseErrorTypeLiteral(ErrorTypeLiteral object) {
        return this.checkWarningsAndErrors(object, this.services.getErrorTypes(object));
    }

    @Override
    public Set<IType> caseNullLiteral(NullLiteral object) {
        LinkedHashSet<IType> possibleTypes = new LinkedHashSet<IType>();
        possibleTypes.add(new ClassType(this.services.getQueryEnvironment(), null));
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseSetInExtensionLiteral(SetInExtensionLiteral object) {
        LinkedHashSet<IType> possibleTypes = new LinkedHashSet<IType>();
        for (Expression expression : object.getValues()) {
            for (IType type : (Set)this.doSwitch(expression)) {
                possibleTypes.add(new SetType(this.services.getQueryEnvironment(), type));
            }
        }
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseSequenceInExtensionLiteral(SequenceInExtensionLiteral object) {
        LinkedHashSet<IType> possibleTypes = new LinkedHashSet<IType>();
        for (Expression expression : object.getValues()) {
            for (IType type : (Set)this.doSwitch(expression)) {
                possibleTypes.add(new SequenceType(this.services.getQueryEnvironment(), type));
            }
        }
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseVariableDeclaration(VariableDeclaration object) {
        this.doSwitch(object.getExpression());
        return null;
    }

    @Override
    public Set<IType> caseConditional(Conditional object) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        Set trueTypes = (Set)this.doSwitch(object.getTrueBranch());
        Set falseTypes = (Set)this.doSwitch(object.getFalseBranch());
        Set selectorTypes = (Set)this.doSwitch(object.getPredicate());
        if (!selectorTypes.isEmpty()) {
            boolean onlyBoolean = true;
            boolean onlyNotBoolean = true;
            ClassType booleanObjectType = new ClassType(this.services.getQueryEnvironment(), Boolean.class);
            ClassType booleanType = new ClassType(this.services.getQueryEnvironment(), Boolean.TYPE);
            for (IType type : selectorTypes) {
                boolean assignableFrom = booleanObjectType.isAssignableFrom(type) || booleanType.isAssignableFrom(type);
                onlyBoolean = onlyBoolean && assignableFrom;
                boolean bl = onlyNotBoolean = onlyNotBoolean && !assignableFrom;
                if (!onlyBoolean && !onlyNotBoolean) break;
            }
            if (onlyBoolean) {
                result.addAll(trueTypes);
                result.addAll(falseTypes);
            } else if (onlyNotBoolean) {
                result.add(this.services.nothing("The predicate never evaluates to a boolean type (%s).", selectorTypes));
            } else {
                result.add(this.services.nothing("The predicate may evaluate to a value that is not a boolean type (%s).", selectorTypes));
                result.addAll(trueTypes);
                result.addAll(falseTypes);
            }
        } else {
            result.add(this.services.nothing("The predicate never evaluates to a boolean type (%s).", selectorTypes));
        }
        return this.checkWarningsAndErrors(object, result);
    }

    @Override
    public Set<IType> caseLet(Let object) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        HashMap<String, Set<IType>> newVariableTypes = new HashMap<String, Set<IType>>(this.variableTypesStack.peek());
        for (Binding binding : object.getBindings()) {
            if (newVariableTypes.containsKey(binding.getName())) {
                result.add(this.services.nothing(VARIABLE_OVERRIDES_AN_EXISTING_VALUE, binding.getName()));
            }
            newVariableTypes.put(binding.getName(), (Set)this.doSwitch(binding.getValue()));
        }
        this.variableTypesStack.push(newVariableTypes);
        try {
            Set bodyTypes = (Set)this.doSwitch(object.getBody());
            result.addAll(bodyTypes);
        }
        finally {
            this.variableTypesStack.pop();
        }
        return this.checkWarningsAndErrors(object, result);
    }
}

