/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.model.mtl.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.eclipse.acceleo.common.internal.utils.AcceleoLogger;
import org.eclipse.acceleo.model.mtl.resource.EMtlBinaryResourceContentDescriber;
import org.eclipse.acceleo.model.mtl.resource.EMtlBinaryResourceFactoryImpl;
import org.eclipse.acceleo.model.mtl.resource.EMtlResourceFactoryImpl;
import org.eclipse.acceleo.model.mtl.resource.LazyInputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;

public class AcceleoResourceFactoryRegistry
extends ResourceFactoryRegistryImpl {
    private Resource.Factory.Registry delegate;

    public AcceleoResourceFactoryRegistry() {
        this.delegate = new ResourceFactoryRegistryImpl();
        this.contentTypeIdentifierToFactoryMap.putAll(Resource.Factory.Registry.INSTANCE.getContentTypeToFactoryMap());
        this.extensionToFactoryMap.putAll(Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap());
        this.protocolToFactoryMap.putAll(Resource.Factory.Registry.INSTANCE.getProtocolToFactoryMap());
    }

    public AcceleoResourceFactoryRegistry(Resource.Factory.Registry delegate) {
        this.delegate = delegate;
    }

    public Resource.Factory getFactory(URI uri) {
        Resource.Factory factory = this.delegatedGetFactory(uri, null);
        if (factory != null) {
            return factory;
        }
        return this.delegate.getFactory(uri);
    }

    public Resource.Factory getFactory(URI uri, String contentType) {
        Resource.Factory factory = this.delegatedGetFactory(uri, contentType);
        if (factory != null) {
            return factory;
        }
        return this.delegate.getFactory(uri, contentType);
    }

    public Map<String, Object> getProtocolToFactoryMap() {
        if (!this.protocolToFactoryMap.isEmpty()) {
            return this.protocolToFactoryMap;
        }
        return this.delegate.getProtocolToFactoryMap();
    }

    public Map<String, Object> getExtensionToFactoryMap() {
        if (!this.extensionToFactoryMap.isEmpty()) {
            return this.extensionToFactoryMap;
        }
        return this.delegate.getExtensionToFactoryMap();
    }

    public Map<String, Object> getContentTypeToFactoryMap() {
        if (!this.contentTypeIdentifierToFactoryMap.isEmpty()) {
            return this.contentTypeIdentifierToFactoryMap;
        }
        return this.delegate.getContentTypeToFactoryMap();
    }

    protected Resource.Factory delegatedGetFactory(URI uri, String contentTypeIdentifier) {
        Resource.Factory factory = this.computeFactory(uri, contentTypeIdentifier);
        if (factory == null) {
            factory = super.delegatedGetFactory(uri, contentTypeIdentifier);
        }
        return factory;
    }

    private Resource.Factory computeFactory(URI uri, String contentTypeIdentifier) {
        Object factory;
        block45: {
            factory = null;
            if (!"emtl".equals(uri.fileExtension())) {
                return factory;
            }
            String path = uri.toFileString();
            if (path == null && (path = uri.toString()).startsWith("file:")) {
                path = path.substring("file:".length());
            }
            if (path != null) {
                path = URI.decode((String)path);
                InputStream stream = null;
                InputStream containingStream = null;
                try {
                    String jarPrefix = "jar:file:/";
                    String os = System.getProperty("os.name").toLowerCase();
                    if (os.indexOf("win") == -1) {
                        jarPrefix = "jar:file:";
                    }
                    String jarSeparator = "!/";
                    if (path.startsWith(jarPrefix) && path.contains(jarSeparator)) {
                        String jarPath = path.substring(jarPrefix.length(), path.indexOf(jarSeparator));
                        try {
                            JarFile jar = new JarFile(jarPath);
                            ZipEntry entry = jar.getEntry(path.substring(path.indexOf(jarSeparator) + jarSeparator.length()));
                            if (entry != null) {
                                stream = jar.getInputStream(entry);
                            }
                        }
                        catch (IOException iOException) {}
                    } else {
                        File file = new File(path);
                        if (file.exists()) {
                            stream = new FileInputStream(file);
                        }
                    }
                    if ((contentTypeIdentifier == null || "".equals(contentTypeIdentifier)) && stream != null) {
                        EMtlBinaryResourceContentDescriber binaryContentDescriber = new EMtlBinaryResourceContentDescriber();
                        containingStream = new LazyInputStream(stream, 1024);
                        int describe = binaryContentDescriber.describe(containingStream, null);
                        factory = describe == 2 ? new EMtlBinaryResourceFactoryImpl() : new EMtlResourceFactoryImpl();
                    }
                }
                catch (FileNotFoundException e) {
                    AcceleoLogger.log((Exception)e, (boolean)false);
                    try {
                        if (containingStream != null) {
                            containingStream.close();
                        }
                    }
                    catch (IOException e2) {
                        AcceleoLogger.log((Exception)e2, (boolean)false);
                    }
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                        break block45;
                    }
                    catch (IOException e3) {
                        AcceleoLogger.log((Exception)e3, (boolean)false);
                    }
                    break block45;
                }
                catch (IOException e) {
                    try {
                        AcceleoLogger.log((Exception)e, (boolean)false);
                        break block45;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        try {
                            if (containingStream != null) {
                                containingStream.close();
                            }
                        }
                        catch (IOException e4) {
                            AcceleoLogger.log((Exception)e4, (boolean)false);
                        }
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                        catch (IOException e5) {
                            AcceleoLogger.log((Exception)e5, (boolean)false);
                        }
                    }
                }
                try {
                    if (containingStream != null) {
                        containingStream.close();
                    }
                }
                catch (IOException e) {
                    AcceleoLogger.log((Exception)e, (boolean)false);
                }
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    AcceleoLogger.log((Exception)e, (boolean)false);
                }
            }
        }
        if (factory == null) {
            if ("org.eclipse.acceleo.model.content.emtl.binary".equals(contentTypeIdentifier)) {
                factory = new EMtlBinaryResourceFactoryImpl();
            } else if ("org.eclipse.acceleo.model.content.emtl.xmi".equals(contentTypeIdentifier)) {
                factory = new EMtlResourceFactoryImpl();
            }
        }
        return factory;
    }
}

