/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.acceleo.AcceleoPackage;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleElement;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.aql.evaluation.AcceleoEvaluator;
import org.eclipse.acceleo.aql.evaluation.writer.DefaultGenerationStrategy;
import org.eclipse.acceleo.query.ast.EClassifierTypeLiteral;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.services.EObjectServices;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public final class AcceleoUtil {
    private static final String SELF = "self";

    private AcceleoUtil() {
    }

    public static String getTemplateImplicitVariableName() {
        return SELF;
    }

    public static Template getMainTemplate(Module module) {
        Template res = null;
        for (ModuleElement moduleElement : module.getModuleElements()) {
            if (!(moduleElement instanceof Template) || !((Template)moduleElement).isMain()) continue;
            res = (Template)moduleElement;
            break;
        }
        return res;
    }

    public static void generate(AcceleoEvaluator evaluator, IQualifiedNameQueryEnvironment queryEnvironment, Module module, Resource model, URI destination) {
        AcceleoUtil.generate(evaluator, queryEnvironment, module, Collections.singletonList(model), destination);
    }

    public static void generate(AcceleoEvaluator evaluator, IQualifiedNameQueryEnvironment queryEnvironment, Module module, ResourceSet resourceSet, URI destination) {
        AcceleoUtil.generate(evaluator, queryEnvironment, module, (List<Resource>)resourceSet.getResources(), destination);
    }

    private static void generate(AcceleoEvaluator evaluator, IQualifiedNameQueryEnvironment queryEnvironment, Module module, List<Resource> resources, URI destination) {
        EObjectServices services = new EObjectServices((IReadOnlyQueryEnvironment)queryEnvironment, null, null);
        Template main = AcceleoUtil.getMainTemplate(module);
        String parameterName = ((Variable)main.getParameters().get(0)).getName();
        EClassifierTypeLiteral eClassifierTypeLiteral = (EClassifierTypeLiteral)((Variable)main.getParameters().get(0)).getType().getAst();
        Collection eClassifiers = queryEnvironment.getEPackageProvider().getTypes(eClassifierTypeLiteral.getEPackageName(), eClassifierTypeLiteral.getEClassifierName());
        if (!eClassifiers.isEmpty()) {
            EClass parameterType = (EClass)eClassifiers.iterator().next();
            ArrayList<EObject> values = new ArrayList<EObject>();
            for (Resource model : resources) {
                for (EObject root : model.getContents()) {
                    if (parameterType.isInstance((Object)root)) {
                        values.add(root);
                    }
                    values.addAll(services.eAllContents(root, parameterType));
                }
            }
            DefaultGenerationStrategy generationStrategy = new DefaultGenerationStrategy();
            HashMap<String, Object> variables = new HashMap<String, Object>();
            for (EObject value : values) {
                variables.put(parameterName, value);
                evaluator.generate(module, variables, generationStrategy, destination);
            }
            generationStrategy.terminate();
        }
    }

    public static List<EClass> getConcreteAcceleoTypesInheriting(EClass superType) {
        if (!superType.getEPackage().equals(AcceleoPackage.eINSTANCE)) {
            throw new IllegalArgumentException("This can only be used for EClasses from the Acceleo EPackage. " + superType + " is from EPackage " + superType.getEPackage() + ".");
        }
        ArrayList<EClass> eClasses = new ArrayList<EClass>();
        if (!superType.isAbstract() && !superType.isInterface()) {
            eClasses.add(superType);
        }
        List allAcceleoConcreteEClasses = AcceleoPackage.eINSTANCE.getEClassifiers().stream().filter(EClass.class::isInstance).map(EClass.class::cast).filter(eClass -> !eClass.isInterface() && !eClass.isAbstract()).collect(Collectors.toList());
        List acceleoConcreteSubTypes = allAcceleoConcreteEClasses.stream().filter(eClass2 -> eClass2.getESuperTypes().contains((Object)superType)).collect(Collectors.toList());
        eClasses.addAll(acceleoConcreteSubTypes);
        return eClasses;
    }

    public static String getContent(InputStream stream, String charsetName) throws IOException {
        int len = 8192;
        StringBuilder res = new StringBuilder(8192);
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStreamReader input = new InputStreamReader((InputStream)new BufferedInputStream(stream), charsetName);){
            char[] buffer = new char[8192];
            int length = input.read(buffer);
            while (length != -1) {
                res.append(buffer, 0, length);
                length = input.read(buffer);
            }
            input.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return res.toString();
    }
}

