/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ls.common;

import java.util.Objects;
import org.eclipse.acceleo.AcceleoASTNode;
import org.eclipse.acceleo.aql.parser.AcceleoAstResult;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public final class AcceleoLanguageServerPositionUtils {
    private AcceleoLanguageServerPositionUtils() {
    }

    public static Position getStartPositionOf(AcceleoASTNode astNode, AcceleoAstResult inAcceleoAstResult) {
        int nodeStartLine = inAcceleoAstResult.getStartLine((ASTNode)astNode);
        int nodeStartColumn = inAcceleoAstResult.getStartColumn((ASTNode)astNode);
        if (nodeStartLine == -1 || nodeStartColumn == -1) {
            return null;
        }
        return new Position(nodeStartLine, nodeStartColumn);
    }

    public static Position getIDentifierStartPositionOf(AcceleoASTNode astNode, AcceleoAstResult inAcceleoAstResult) {
        int nodeStartLine = inAcceleoAstResult.getIdentifierStartLine((ASTNode)astNode);
        int nodeStartColumn = inAcceleoAstResult.getIdentifierStartColumn((ASTNode)astNode);
        if (nodeStartLine == -1 || nodeStartColumn == -1) {
            return null;
        }
        return new Position(nodeStartLine, nodeStartColumn);
    }

    public static Position getEndPositionOf(AcceleoASTNode astNode, AcceleoAstResult inAcceleoAstResult) {
        int nodeEndLine = inAcceleoAstResult.getEndLine((ASTNode)astNode);
        int nodeEndColumn = inAcceleoAstResult.getEndColumn((ASTNode)astNode);
        if (nodeEndLine == -1 || nodeEndColumn == -1) {
            return null;
        }
        return new Position(nodeEndLine, nodeEndColumn);
    }

    public static Position getIdentifierEndPositionOf(AcceleoASTNode astNode, AcceleoAstResult inAcceleoAstResult) {
        int nodeEndLine = inAcceleoAstResult.getIdentifierEndLine((ASTNode)astNode);
        int nodeEndColumn = inAcceleoAstResult.getIdentifierEndColumn((ASTNode)astNode);
        if (nodeEndLine == -1 || nodeEndColumn == -1) {
            return null;
        }
        return new Position(nodeEndLine, nodeEndColumn);
    }

    public static Range getRangeOf(AcceleoASTNode astNode, AcceleoAstResult inAcceleoAstResult) {
        return new Range(AcceleoLanguageServerPositionUtils.getStartPositionOf(astNode, inAcceleoAstResult), AcceleoLanguageServerPositionUtils.getEndPositionOf(astNode, inAcceleoAstResult));
    }

    public static Range getIdentifierRangeOf(AcceleoASTNode astNode, AcceleoAstResult inAcceleoAstResult) {
        return new Range(AcceleoLanguageServerPositionUtils.getIDentifierStartPositionOf(astNode, inAcceleoAstResult), AcceleoLanguageServerPositionUtils.getIdentifierEndPositionOf(astNode, inAcceleoAstResult));
    }

    public static Position getStartPositionOf(Expression aqlExpression, AcceleoAstResult inAcceleoAstResult) {
        int nodeStartLine = inAcceleoAstResult.getStartLine((ASTNode)aqlExpression);
        int nodeStartColumn = inAcceleoAstResult.getStartColumn((ASTNode)aqlExpression);
        return new Position(nodeStartLine, nodeStartColumn);
    }

    public static Position getIdentifierStartPositionOf(Expression aqlExpression, AcceleoAstResult inAcceleoAstResult) {
        int nodeStartLine = inAcceleoAstResult.getIdentifierStartLine((ASTNode)aqlExpression);
        int nodeStartColumn = inAcceleoAstResult.getIdentifierStartColumn((ASTNode)aqlExpression);
        return new Position(nodeStartLine, nodeStartColumn);
    }

    public static Position getEndPositionOf(Expression aqlExpression, AcceleoAstResult inAcceleoAstResult) {
        int nodeEndLine = inAcceleoAstResult.getEndLine((ASTNode)aqlExpression);
        int nodeEndColumn = inAcceleoAstResult.getEndColumn((ASTNode)aqlExpression);
        return new Position(nodeEndLine, nodeEndColumn);
    }

    public static Position getIdentifierEndPositionOf(Expression aqlExpression, AcceleoAstResult inAcceleoAstResult) {
        int nodeEndLine = inAcceleoAstResult.getIdentifierEndLine((ASTNode)aqlExpression);
        int nodeEndColumn = inAcceleoAstResult.getIdentifierEndColumn((ASTNode)aqlExpression);
        return new Position(nodeEndLine, nodeEndColumn);
    }

    public static Range getRangeOf(Expression aqlExpression, AcceleoAstResult inAcceleoAstResult) {
        return new Range(AcceleoLanguageServerPositionUtils.getStartPositionOf(aqlExpression, inAcceleoAstResult), AcceleoLanguageServerPositionUtils.getEndPositionOf(aqlExpression, inAcceleoAstResult));
    }

    public static Range getIdentifierRangeOf(Expression aqlExpression, AcceleoAstResult inAcceleoAstResult) {
        return new Range(AcceleoLanguageServerPositionUtils.getIdentifierStartPositionOf(aqlExpression, inAcceleoAstResult), AcceleoLanguageServerPositionUtils.getIdentifierEndPositionOf(aqlExpression, inAcceleoAstResult));
    }

    public static Position getStartPositionOf(VariableDeclaration aqlVariableDeclaration, AcceleoAstResult inAcceleoAstResult) {
        int nodeStartLine = inAcceleoAstResult.getStartLine((ASTNode)aqlVariableDeclaration);
        int nodeStartColumn = inAcceleoAstResult.getStartColumn((ASTNode)aqlVariableDeclaration);
        return new Position(nodeStartLine, nodeStartColumn);
    }

    public static Position getIdentifierStartPositionOf(VariableDeclaration aqlVariableDeclaration, AcceleoAstResult inAcceleoAstResult) {
        int nodeStartLine = inAcceleoAstResult.getIdentifierStartLine((ASTNode)aqlVariableDeclaration);
        int nodeStartColumn = inAcceleoAstResult.getIdentifierStartColumn((ASTNode)aqlVariableDeclaration);
        return new Position(nodeStartLine, nodeStartColumn);
    }

    public static Position getEndPositionOf(VariableDeclaration aqlVariableDeclaration, AcceleoAstResult inAcceleoAstResult) {
        int nodeEndLine = inAcceleoAstResult.getEndLine((ASTNode)aqlVariableDeclaration);
        int nodeEndColumn = inAcceleoAstResult.getEndColumn((ASTNode)aqlVariableDeclaration);
        return new Position(nodeEndLine, nodeEndColumn);
    }

    public static Position getIdentifierEndPositionOf(VariableDeclaration aqlVariableDeclaration, AcceleoAstResult inAcceleoAstResult) {
        int nodeEndLine = inAcceleoAstResult.getIdentifierEndLine((ASTNode)aqlVariableDeclaration);
        int nodeEndColumn = inAcceleoAstResult.getIdentifierEndColumn((ASTNode)aqlVariableDeclaration);
        return new Position(nodeEndLine, nodeEndColumn);
    }

    public static Range getRangeOf(VariableDeclaration aqlVariableDeclaration, AcceleoAstResult inAcceleoAstResult) {
        return new Range(AcceleoLanguageServerPositionUtils.getStartPositionOf(aqlVariableDeclaration, inAcceleoAstResult), AcceleoLanguageServerPositionUtils.getEndPositionOf(aqlVariableDeclaration, inAcceleoAstResult));
    }

    public static Range getIdentifierRangeOf(VariableDeclaration aqlVariableDeclaration, AcceleoAstResult inAcceleoAstResult) {
        return new Range(AcceleoLanguageServerPositionUtils.getIdentifierStartPositionOf(aqlVariableDeclaration, inAcceleoAstResult), AcceleoLanguageServerPositionUtils.getIdentifierEndPositionOf(aqlVariableDeclaration, inAcceleoAstResult));
    }

    public static String replace(String inText, Position startPosition, Position endPosition, String withText) {
        int startIndex = AcceleoLanguageServerPositionUtils.getCorrespondingCharacterIndex(startPosition, inText);
        int endIndex = AcceleoLanguageServerPositionUtils.getCorrespondingCharacterIndex(endPosition, inText);
        StringBuilder stringBuilder = new StringBuilder(inText);
        stringBuilder.replace(startIndex, endIndex, withText);
        return stringBuilder.toString();
    }

    public static int getCorrespondingCharacterIndex(Position position, String text) {
        int positionLine = position.getLine();
        int positionOffset = position.getCharacter();
        int currentLine = 0;
        int currentIndex = 0;
        while (currentLine != positionLine && currentIndex < text.length()) {
            char currentCharacter = text.charAt(currentIndex);
            if (currentCharacter == '\n') {
                ++currentLine;
            }
            ++currentIndex;
        }
        if (currentLine == positionLine) {
            return currentIndex + positionOffset;
        }
        throw new IllegalArgumentException("Could not find line " + positionLine + " in the given text. This should never happen.");
    }

    public static Range getCorrespondingRange(int beginCharacterIndex, int endCharacterIndex, String text) {
        Position beginPosition = AcceleoLanguageServerPositionUtils.getCorrespondingPosition(beginCharacterIndex, text);
        Position endPosition = AcceleoLanguageServerPositionUtils.getCorrespondingPosition(endCharacterIndex, text);
        return new Range(beginPosition, endPosition);
    }

    public static Position getCorrespondingPosition(int characterIndex, String text) {
        Objects.requireNonNull(text);
        int lineNumber = 0;
        int indexOfLastNewLine = -1;
        int currentIndex = 0;
        while (currentIndex < characterIndex) {
            Character currentCharacter = Character.valueOf(text.charAt(currentIndex));
            if (currentCharacter.charValue() == '\n') {
                ++lineNumber;
                indexOfLastNewLine = currentIndex;
            }
            ++currentIndex;
        }
        int offset = lineNumber == 0 ? characterIndex : characterIndex - indexOfLastNewLine - 1;
        return new Position(lineNumber, offset);
    }
}

