/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.debug.ls;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.function.Supplier;
import org.eclipse.acceleo.debug.DSLSource;
import org.eclipse.acceleo.debug.IDSLDebugger;
import org.eclipse.acceleo.debug.event.debugger.BreakpointReply;
import org.eclipse.acceleo.debug.event.debugger.DeleteVariableReply;
import org.eclipse.acceleo.debug.event.debugger.ResumingReply;
import org.eclipse.acceleo.debug.event.debugger.SetCurrentInstructionReply;
import org.eclipse.acceleo.debug.event.debugger.SetVariableValueReply;
import org.eclipse.acceleo.debug.event.debugger.SpawnRunningThreadReply;
import org.eclipse.acceleo.debug.event.debugger.StepIntoResumingReply;
import org.eclipse.acceleo.debug.event.debugger.StepOverResumingReply;
import org.eclipse.acceleo.debug.event.debugger.StepReturnResumingReply;
import org.eclipse.acceleo.debug.event.debugger.SteppedReply;
import org.eclipse.acceleo.debug.event.debugger.SuspendedReply;
import org.eclipse.acceleo.debug.event.debugger.TerminatedReply;
import org.eclipse.acceleo.debug.event.debugger.VariableReply;
import org.eclipse.acceleo.debug.event.model.AbstractModelEventProcessor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.lsp4j.debug.Breakpoint;
import org.eclipse.lsp4j.debug.Capabilities;
import org.eclipse.lsp4j.debug.CompletionsArguments;
import org.eclipse.lsp4j.debug.CompletionsResponse;
import org.eclipse.lsp4j.debug.ConfigurationDoneArguments;
import org.eclipse.lsp4j.debug.ContinueArguments;
import org.eclipse.lsp4j.debug.ContinueResponse;
import org.eclipse.lsp4j.debug.ContinuedEventArguments;
import org.eclipse.lsp4j.debug.DataBreakpointInfoArguments;
import org.eclipse.lsp4j.debug.DataBreakpointInfoResponse;
import org.eclipse.lsp4j.debug.DisassembleArguments;
import org.eclipse.lsp4j.debug.DisassembleResponse;
import org.eclipse.lsp4j.debug.DisconnectArguments;
import org.eclipse.lsp4j.debug.EvaluateArguments;
import org.eclipse.lsp4j.debug.EvaluateResponse;
import org.eclipse.lsp4j.debug.ExceptionInfoArguments;
import org.eclipse.lsp4j.debug.ExceptionInfoResponse;
import org.eclipse.lsp4j.debug.FunctionBreakpoint;
import org.eclipse.lsp4j.debug.GotoArguments;
import org.eclipse.lsp4j.debug.GotoTargetsArguments;
import org.eclipse.lsp4j.debug.GotoTargetsResponse;
import org.eclipse.lsp4j.debug.InitializeRequestArguments;
import org.eclipse.lsp4j.debug.LoadedSourcesArguments;
import org.eclipse.lsp4j.debug.LoadedSourcesResponse;
import org.eclipse.lsp4j.debug.ModulesArguments;
import org.eclipse.lsp4j.debug.ModulesResponse;
import org.eclipse.lsp4j.debug.NextArguments;
import org.eclipse.lsp4j.debug.OutputEventArguments;
import org.eclipse.lsp4j.debug.PauseArguments;
import org.eclipse.lsp4j.debug.ReadMemoryArguments;
import org.eclipse.lsp4j.debug.ReadMemoryResponse;
import org.eclipse.lsp4j.debug.RestartArguments;
import org.eclipse.lsp4j.debug.RestartFrameArguments;
import org.eclipse.lsp4j.debug.ReverseContinueArguments;
import org.eclipse.lsp4j.debug.RunInTerminalRequestArguments;
import org.eclipse.lsp4j.debug.RunInTerminalResponse;
import org.eclipse.lsp4j.debug.Scope;
import org.eclipse.lsp4j.debug.ScopesArguments;
import org.eclipse.lsp4j.debug.ScopesResponse;
import org.eclipse.lsp4j.debug.SetBreakpointsArguments;
import org.eclipse.lsp4j.debug.SetBreakpointsResponse;
import org.eclipse.lsp4j.debug.SetDataBreakpointsArguments;
import org.eclipse.lsp4j.debug.SetDataBreakpointsResponse;
import org.eclipse.lsp4j.debug.SetExceptionBreakpointsArguments;
import org.eclipse.lsp4j.debug.SetExceptionBreakpointsResponse;
import org.eclipse.lsp4j.debug.SetExpressionArguments;
import org.eclipse.lsp4j.debug.SetExpressionResponse;
import org.eclipse.lsp4j.debug.SetFunctionBreakpointsArguments;
import org.eclipse.lsp4j.debug.SetFunctionBreakpointsResponse;
import org.eclipse.lsp4j.debug.SetVariableArguments;
import org.eclipse.lsp4j.debug.SetVariableResponse;
import org.eclipse.lsp4j.debug.Source;
import org.eclipse.lsp4j.debug.SourceArguments;
import org.eclipse.lsp4j.debug.SourceBreakpoint;
import org.eclipse.lsp4j.debug.SourceResponse;
import org.eclipse.lsp4j.debug.StackFrame;
import org.eclipse.lsp4j.debug.StackTraceArguments;
import org.eclipse.lsp4j.debug.StackTraceResponse;
import org.eclipse.lsp4j.debug.StepBackArguments;
import org.eclipse.lsp4j.debug.StepInArguments;
import org.eclipse.lsp4j.debug.StepInTargetsArguments;
import org.eclipse.lsp4j.debug.StepInTargetsResponse;
import org.eclipse.lsp4j.debug.StepOutArguments;
import org.eclipse.lsp4j.debug.StoppedEventArguments;
import org.eclipse.lsp4j.debug.TerminateArguments;
import org.eclipse.lsp4j.debug.TerminateThreadsArguments;
import org.eclipse.lsp4j.debug.TerminatedEventArguments;
import org.eclipse.lsp4j.debug.Thread;
import org.eclipse.lsp4j.debug.ThreadEventArguments;
import org.eclipse.lsp4j.debug.ThreadsResponse;
import org.eclipse.lsp4j.debug.Variable;
import org.eclipse.lsp4j.debug.VariablesArguments;
import org.eclipse.lsp4j.debug.VariablesResponse;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.eclipse.lsp4j.debug.services.IDebugProtocolServer;

public class DSLDebugServer
extends AbstractModelEventProcessor
implements IDebugProtocolServer {
    private IDebugProtocolClient client;
    private IDSLDebugger debugger;
    private boolean launched;
    private Map<String, Object> arguments;
    private final Map<Integer, Map<String, Object>> frameIDToVariables = new HashMap<Integer, Map<String, Object>>();
    private final ILabelProvider eLabelProvider;
    private final CountDownLatch intialiaztionCountDownLatch = new CountDownLatch(1);

    public DSLDebugServer() {
        ComposedAdapterFactory factory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.eLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)factory);
    }

    public void setDebugger(IDSLDebugger debugger) {
        this.debugger = debugger;
    }

    public CompletableFuture<Capabilities> initialize(InitializeRequestArguments args) {
        return CompletableFuture.supplyAsync(new Supplier<Capabilities>(){

            @Override
            public Capabilities get() {
                Capabilities res = DSLDebugServer.this.getCapabilities();
                DSLDebugServer.this.client.initialized();
                return res;
            }
        });
    }

    private Capabilities getCapabilities() {
        Capabilities res = new Capabilities();
        res.setSupportsCompletionsRequest(Boolean.valueOf(true));
        res.setSupportsConditionalBreakpoints(Boolean.valueOf(true));
        res.setSupportsConfigurationDoneRequest(Boolean.valueOf(true));
        res.setSupportsDataBreakpoints(Boolean.valueOf(false));
        res.setSupportsDelayedStackTraceLoading(Boolean.valueOf(false));
        res.setSupportsDisassembleRequest(Boolean.valueOf(false));
        res.setSupportsEvaluateForHovers(Boolean.valueOf(false));
        res.setSupportsExceptionInfoRequest(Boolean.valueOf(false));
        res.setSupportsExceptionOptions(Boolean.valueOf(false));
        res.setSupportsFunctionBreakpoints(Boolean.valueOf(false));
        res.setSupportsGotoTargetsRequest(Boolean.valueOf(false));
        res.setSupportsHitConditionalBreakpoints(Boolean.valueOf(true));
        res.setSupportsLoadedSourcesRequest(Boolean.valueOf(false));
        res.setSupportsLogPoints(Boolean.valueOf(false));
        res.setSupportsModulesRequest(Boolean.valueOf(false));
        res.setSupportsReadMemoryRequest(Boolean.valueOf(false));
        res.setSupportsRestartFrame(Boolean.valueOf(false));
        res.setSupportsRestartRequest(Boolean.valueOf(false));
        res.setSupportsSetExpression(Boolean.valueOf(false));
        res.setSupportsSetVariable(Boolean.valueOf(false));
        res.setSupportsStepBack(Boolean.valueOf(false));
        res.setSupportsStepInTargetsRequest(Boolean.valueOf(false));
        res.setSupportsTerminateRequest(Boolean.valueOf(true));
        res.setSupportsTerminateThreadsRequest(Boolean.valueOf(true));
        res.setSupportsValueFormattingOptions(Boolean.valueOf(false));
        return res;
    }

    public CompletableFuture<SetBreakpointsResponse> setBreakpoints(final SetBreakpointsArguments args) {
        return CompletableFuture.supplyAsync(new Supplier<SetBreakpointsResponse>(){

            @Override
            public SetBreakpointsResponse get() {
                return DSLDebugServer.this.getSetBreakpointResponse(args);
            }
        });
    }

    private SetBreakpointsResponse getSetBreakpointResponse(SetBreakpointsArguments args) {
        SetBreakpointsResponse res = new SetBreakpointsResponse();
        ArrayList<Breakpoint> responseBreakpoints = new ArrayList<Breakpoint>();
        this.debugger.clearBreakPoints();
        try {
            this.intialiaztionCountDownLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        SourceBreakpoint[] sourceBreakpointArray = args.getBreakpoints();
        int n = sourceBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            SourceBreakpoint requestedBreakpoint = sourceBreakpointArray[n2];
            long column = requestedBreakpoint.getColumn() != null ? (long)requestedBreakpoint.getColumn().intValue() : 0L;
            EObject instruction = this.debugger.getInstruction(args.getSource().getPath(), (long)requestedBreakpoint.getLine(), column);
            if (instruction != null) {
                this.debugger.addBreakPoint(EcoreUtil.getURI((EObject)instruction));
                Breakpoint responseBreakpoint = new Breakpoint();
                DSLSource dslSource = this.debugger.getSource(instruction);
                if (dslSource != null) {
                    Source source = new Source();
                    source.setPath(dslSource.getPath());
                    responseBreakpoint.setVerified(true);
                    responseBreakpoint.setSource(source);
                    responseBreakpoint.setLine(Integer.valueOf((int)dslSource.getStartLine()));
                    responseBreakpoint.setColumn(Integer.valueOf((int)dslSource.getStartColumn()));
                    responseBreakpoint.setEndLine(Integer.valueOf((int)dslSource.getEndLine()));
                    responseBreakpoint.setEndColumn(Integer.valueOf((int)dslSource.getEndColumn()));
                    responseBreakpoints.add(responseBreakpoint);
                }
            }
            ++n2;
        }
        res.setBreakpoints(responseBreakpoints.toArray(new Breakpoint[responseBreakpoints.size()]));
        return res;
    }

    public CompletableFuture<SetFunctionBreakpointsResponse> setFunctionBreakpoints(final SetFunctionBreakpointsArguments args) {
        return CompletableFuture.supplyAsync(new Supplier<SetFunctionBreakpointsResponse>(){

            @Override
            public SetFunctionBreakpointsResponse get() {
                SetFunctionBreakpointsResponse res = new SetFunctionBreakpointsResponse();
                ArrayList responseBreakpoints = new ArrayList();
                FunctionBreakpoint[] functionBreakpointArray = args.getBreakpoints();
                int n = functionBreakpointArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FunctionBreakpoint functionBreakpoint = functionBreakpointArray[n2];
                    ++n2;
                }
                res.setBreakpoints(responseBreakpoints.toArray(new Breakpoint[responseBreakpoints.size()]));
                return res;
            }
        });
    }

    public CompletableFuture<SetExceptionBreakpointsResponse> setExceptionBreakpoints(SetExceptionBreakpointsArguments args) {
        return CompletableFuture.supplyAsync(new Supplier<SetExceptionBreakpointsResponse>(){

            @Override
            public SetExceptionBreakpointsResponse get() {
                return null;
            }
        });
    }

    public CompletableFuture<Void> configurationDone(ConfigurationDoneArguments args) {
        return CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                if (DSLDebugServer.this.launched) {
                    DSLDebugServer.this.debugger.start();
                }
            }
        });
    }

    public CompletableFuture<Void> launch(final Map<String, Object> args) {
        this.launched = true;
        this.arguments = args;
        return CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                Object noDebug = DSLDebugServer.this.arguments.get("noDebug");
                if (noDebug instanceof Boolean && ((Boolean)noDebug).booleanValue()) {
                    DSLDebugServer.this.debugger.initialize(true, args);
                    DSLDebugServer.this.debugger.start();
                } else {
                    DSLDebugServer.this.debugger.initialize(false, args);
                    DSLDebugServer.this.intialiaztionCountDownLatch.countDown();
                }
                OutputEventArguments args2 = new OutputEventArguments();
                args2.setOutput(new String());
                DSLDebugServer.this.client.output(args2);
            }
        });
    }

    public CompletableFuture<Void> attach(Map<String, Object> args) {
        this.arguments = args;
        return CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public CompletableFuture<Void> pause(final PauseArguments args) {
        return CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                DSLDebugServer.this.debugger.suspend(Long.valueOf(args.getThreadId()));
            }
        });
    }

    public CompletableFuture<ContinueResponse> continue_(final ContinueArguments args) {
        return CompletableFuture.supplyAsync(new Supplier<ContinueResponse>(){

            @Override
            public ContinueResponse get() {
                ContinueResponse res = new ContinueResponse();
                DSLDebugServer.this.debugger.resume(Long.valueOf(args.getThreadId()));
                res.setAllThreadsContinued(Boolean.valueOf(false));
                return res;
            }
        });
    }

    public CompletableFuture<Void> next(final NextArguments args) {
        return CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                DSLDebugServer.this.debugger.stepOver(Long.valueOf(args.getThreadId()));
            }
        });
    }

    public CompletableFuture<Void> stepIn(final StepInArguments args) {
        return CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                DSLDebugServer.this.debugger.stepInto(Long.valueOf(args.getThreadId()));
            }
        });
    }

    public CompletableFuture<SetVariableResponse> setVariable(SetVariableArguments args) {
        return CompletableFuture.supplyAsync(new Supplier<SetVariableResponse>(){

            @Override
            public SetVariableResponse get() {
                SetVariableResponse res = new SetVariableResponse();
                return res;
            }
        });
    }

    public CompletableFuture<Void> terminateThreads(final TerminateThreadsArguments args) {
        return CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                int[] nArray = args.getThreadIds();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Integer threadId = nArray[n2];
                    DSLDebugServer.this.debugger.terminate(Long.valueOf(threadId.intValue()));
                    ++n2;
                }
            }
        });
    }

    public CompletableFuture<Void> terminate(TerminateArguments args) {
        return CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                DSLDebugServer.this.debugger.terminate();
            }
        });
    }

    public CompletableFuture<Void> disconnect(final DisconnectArguments args) {
        this.eLabelProvider.dispose();
        return CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                if (DSLDebugServer.this.launched || args.getTerminateDebuggee().booleanValue()) {
                    DSLDebugServer.this.debugger.terminate();
                }
                DSLDebugServer.this.debugger.disconnect();
            }
        });
    }

    public CompletableFuture<CompletionsResponse> completions(CompletionsArguments args) {
        return null;
    }

    public CompletableFuture<DataBreakpointInfoResponse> dataBreakpointInfo(DataBreakpointInfoArguments args) {
        return null;
    }

    public CompletableFuture<DisassembleResponse> disassemble(DisassembleArguments args) {
        return null;
    }

    public CompletableFuture<EvaluateResponse> evaluate(EvaluateArguments args) {
        return null;
    }

    public CompletableFuture<ExceptionInfoResponse> exceptionInfo(ExceptionInfoArguments args) {
        return null;
    }

    public CompletableFuture<Void> goto_(GotoArguments args) {
        return null;
    }

    public CompletableFuture<GotoTargetsResponse> gotoTargets(GotoTargetsArguments args) {
        return null;
    }

    public CompletableFuture<LoadedSourcesResponse> loadedSources(LoadedSourcesArguments args) {
        return null;
    }

    public CompletableFuture<ModulesResponse> modules(ModulesArguments args) {
        return null;
    }

    public CompletableFuture<ReadMemoryResponse> readMemory(ReadMemoryArguments args) {
        return null;
    }

    public CompletableFuture<Void> restart(RestartArguments args) {
        return null;
    }

    public CompletableFuture<Void> restartFrame(RestartFrameArguments args) {
        return null;
    }

    public CompletableFuture<Void> reverseContinue(ReverseContinueArguments args) {
        return null;
    }

    public CompletableFuture<RunInTerminalResponse> runInTerminal(RunInTerminalRequestArguments args) {
        return null;
    }

    public CompletableFuture<ScopesResponse> scopes(final ScopesArguments args) {
        return CompletableFuture.supplyAsync(new Supplier<ScopesResponse>(){

            @Override
            public ScopesResponse get() {
                return DSLDebugServer.this.getScopesResponse(args);
            }
        });
    }

    private ScopesResponse getScopesResponse(ScopesArguments args) {
        ScopesResponse res = new ScopesResponse();
        Scope scope = new Scope();
        scope.setName("Variables");
        scope.setVariablesReference(args.getFrameId() + 1);
        res.setScopes(new Scope[]{scope});
        return res;
    }

    public CompletableFuture<SetDataBreakpointsResponse> setDataBreakpoints(SetDataBreakpointsArguments args) {
        return null;
    }

    public CompletableFuture<SetExpressionResponse> setExpression(SetExpressionArguments args) {
        return null;
    }

    public CompletableFuture<SourceResponse> source(SourceArguments args) {
        return null;
    }

    public CompletableFuture<StackTraceResponse> stackTrace(final StackTraceArguments args) {
        return CompletableFuture.supplyAsync(new Supplier<StackTraceResponse>(){

            @Override
            public StackTraceResponse get() {
                return DSLDebugServer.this.getStackTraceResponse(args);
            }
        });
    }

    private StackTraceResponse getStackTraceResponse(StackTraceArguments args) {
        StackTraceResponse res = new StackTraceResponse();
        ArrayList<StackFrame> resFrames = new ArrayList<StackFrame>();
        Deque stackFrames = this.debugger.getStackFrame(Long.valueOf(args.getThreadId()));
        Iterator it = stackFrames.descendingIterator();
        int id = 0;
        while (it.hasNext()) {
            org.eclipse.acceleo.debug.util.StackFrame currentFrame = (org.eclipse.acceleo.debug.util.StackFrame)it.next();
            StackFrame resFrame = new StackFrame();
            this.frameIDToVariables.put(id, currentFrame.getVariables());
            resFrame.setId(id);
            resFrame.setName(this.eLabelProvider.getText((Object)currentFrame.getContext()));
            DSLSource dslSource = this.debugger.getSource(currentFrame.getInstruction());
            if (dslSource == null) continue;
            resFrame.setLine((int)dslSource.getStartLine());
            resFrame.setColumn((int)dslSource.getStartColumn());
            resFrame.setEndLine(Integer.valueOf((int)dslSource.getEndLine()));
            resFrame.setEndColumn(Integer.valueOf((int)dslSource.getEndColumn()));
            Source source = new Source();
            source.setName(dslSource.getPath());
            source.setPath(dslSource.getPath());
            resFrame.setSource(source);
            resFrames.add(resFrame);
            ++id;
        }
        res.setTotalFrames(Integer.valueOf(resFrames.size()));
        res.setStackFrames(resFrames.toArray(new StackFrame[resFrames.size()]));
        return res;
    }

    public CompletableFuture<ThreadsResponse> threads() {
        return CompletableFuture.supplyAsync(new Supplier<ThreadsResponse>(){

            @Override
            public ThreadsResponse get() {
                ThreadsResponse res = new ThreadsResponse();
                ArrayList<Thread> threads = new ArrayList<Thread>();
                for (Map.Entry entry : DSLDebugServer.this.debugger.getThreads().entrySet()) {
                    Thread thread = new Thread();
                    thread.setId(((Long)entry.getKey()).intValue());
                    thread.setName((String)entry.getValue());
                    threads.add(thread);
                }
                res.setThreads(threads.toArray(new Thread[threads.size()]));
                return res;
            }
        });
    }

    public CompletableFuture<Void> stepBack(StepBackArguments args) {
        return null;
    }

    public CompletableFuture<StepInTargetsResponse> stepInTargets(StepInTargetsArguments args) {
        return null;
    }

    public CompletableFuture<Void> stepOut(final StepOutArguments args) {
        return CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                DSLDebugServer.this.debugger.stepReturn(Long.valueOf(args.getThreadId()));
            }
        });
    }

    public CompletableFuture<VariablesResponse> variables(final VariablesArguments args) {
        return CompletableFuture.supplyAsync(new Supplier<VariablesResponse>(){

            @Override
            public VariablesResponse get() {
                return DSLDebugServer.this.getVariablesResponse(args);
            }
        });
    }

    private VariablesResponse getVariablesResponse(VariablesArguments args) {
        VariablesResponse res = new VariablesResponse();
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Map<String, Object> vars = this.frameIDToVariables.get(args.getVariablesReference() - 1);
        for (Map.Entry<String, Object> entry : vars.entrySet()) {
            Variable variable = new Variable();
            variable.setName(entry.getKey());
            variable.setEvaluateName(entry.getKey());
            variable.setType(entry.getValue().getClass().getSimpleName());
            variable.setValue(entry.getValue().toString());
            variables.add(variable);
        }
        res.setVariables(variables.toArray(new Variable[variables.size()]));
        return res;
    }

    public void connect(IDebugProtocolClient debugProtocolClient) {
        this.client = debugProtocolClient;
    }

    protected void notifyClientSetVariableValueReply(SetVariableValueReply variableValueReply) {
    }

    protected void notifyClientSetCurrentInstructionReply(SetCurrentInstructionReply setCurrentInstructionReply) {
    }

    protected void notifyClientDeleteVariableReply(DeleteVariableReply deleteVariableReply) {
    }

    protected void notifyClientVariableReply(VariableReply variableReply) {
    }

    protected void notifyClientStepIntoResumingReply(StepIntoResumingReply resumingReply) {
        ContinuedEventArguments eventArguments = new ContinuedEventArguments();
        eventArguments.setThreadId(resumingReply.getThreadID().intValue());
        eventArguments.setAllThreadsContinued(Boolean.valueOf(false));
    }

    protected void notifyClientStepOverResumingReply(StepOverResumingReply resumingReply) {
        ContinuedEventArguments eventArguments = new ContinuedEventArguments();
        eventArguments.setThreadId(resumingReply.getThreadID().intValue());
        eventArguments.setAllThreadsContinued(Boolean.valueOf(false));
    }

    protected void notifyClientStepReturnResumingReply(StepReturnResumingReply resumingReply) {
        ContinuedEventArguments eventArguments = new ContinuedEventArguments();
        eventArguments.setThreadId(resumingReply.getThreadID().intValue());
        eventArguments.setAllThreadsContinued(Boolean.valueOf(false));
    }

    protected void notifyClientResumedReply(ResumingReply resumingReply) {
        ContinuedEventArguments eventArguments = new ContinuedEventArguments();
        eventArguments.setThreadId(resumingReply.getThreadID().intValue());
        eventArguments.setAllThreadsContinued(Boolean.valueOf(false));
    }

    protected void notifyClientSpawnRunningThreadReply(SpawnRunningThreadReply spawnThreadReply) {
        ThreadEventArguments eventArguments = new ThreadEventArguments();
        eventArguments.setThreadId(spawnThreadReply.getThreadID().intValue());
        eventArguments.setReason("started");
        this.client.thread(eventArguments);
    }

    protected void notifyClientTerminatedReply(TerminatedReply terminatedReply) {
        if (terminatedReply.getThreadID() != null) {
            ThreadEventArguments eventArguments = new ThreadEventArguments();
            eventArguments.setThreadId(terminatedReply.getThreadID().intValue());
            eventArguments.setReason("exited");
            this.client.thread(eventArguments);
        } else {
            TerminatedEventArguments eventArguments = new TerminatedEventArguments();
            eventArguments.setRestart((Object)false);
            this.client.terminated(eventArguments);
        }
    }

    protected void notifyClientSteppedReply(SteppedReply suspendReply) {
        StoppedEventArguments argument = new StoppedEventArguments();
        argument.setThreadId(Integer.valueOf(suspendReply.getThreadID().intValue()));
        argument.setDescription("Paused after a step.");
        argument.setPreserveFocusHint(Boolean.valueOf(true));
        argument.setReason("step");
        argument.setAllThreadsStopped(Boolean.valueOf(false));
        this.client.stopped(argument);
    }

    protected void notifyClientBreakpointReply(BreakpointReply suspendReply) {
        StoppedEventArguments argument = new StoppedEventArguments();
        argument.setThreadId(Integer.valueOf(suspendReply.getThreadID().intValue()));
        argument.setDescription("Paused after hitting a breakpoint.");
        argument.setPreserveFocusHint(Boolean.valueOf(true));
        argument.setReason("breakpoint");
        argument.setAllThreadsStopped(Boolean.valueOf(false));
        this.client.stopped(argument);
    }

    protected void notifyClientSuspendedReply(SuspendedReply suspendReply) {
        StoppedEventArguments argument = new StoppedEventArguments();
        argument.setThreadId(Integer.valueOf(suspendReply.getThreadID().intValue()));
        argument.setDescription("Paused after a client request.");
        argument.setPreserveFocusHint(Boolean.valueOf(true));
        argument.setReason("pause");
        argument.setAllThreadsStopped(Boolean.valueOf(false));
        this.client.stopped(argument);
    }
}

