/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.debug;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.acceleo.debug.IDSLDebugger;
import org.eclipse.acceleo.debug.event.IDSLDebugEvent;
import org.eclipse.acceleo.debug.event.IDSLDebugEventProcessor;
import org.eclipse.acceleo.debug.event.debugger.BreakpointReply;
import org.eclipse.acceleo.debug.event.debugger.DeleteVariableReply;
import org.eclipse.acceleo.debug.event.debugger.ResumingReply;
import org.eclipse.acceleo.debug.event.debugger.SetVariableValueReply;
import org.eclipse.acceleo.debug.event.debugger.SpawnRunningThreadReply;
import org.eclipse.acceleo.debug.event.debugger.StepIntoResumingReply;
import org.eclipse.acceleo.debug.event.debugger.StepOverResumingReply;
import org.eclipse.acceleo.debug.event.debugger.StepReturnResumingReply;
import org.eclipse.acceleo.debug.event.debugger.SteppedReply;
import org.eclipse.acceleo.debug.event.debugger.SuspendedReply;
import org.eclipse.acceleo.debug.event.debugger.TerminatedReply;
import org.eclipse.acceleo.debug.event.debugger.VariableReply;
import org.eclipse.acceleo.debug.event.model.AbstractBreakpointRequest;
import org.eclipse.acceleo.debug.event.model.AbstractStepRequest;
import org.eclipse.acceleo.debug.event.model.AddBreakpointRequest;
import org.eclipse.acceleo.debug.event.model.ChangeBreakPointRequest;
import org.eclipse.acceleo.debug.event.model.DisconnectRequest;
import org.eclipse.acceleo.debug.event.model.InitializeRequest;
import org.eclipse.acceleo.debug.event.model.RemoveBreakpointRequest;
import org.eclipse.acceleo.debug.event.model.ResumeRequest;
import org.eclipse.acceleo.debug.event.model.SetVariableValueRequest;
import org.eclipse.acceleo.debug.event.model.StartRequest;
import org.eclipse.acceleo.debug.event.model.StepIntoRequest;
import org.eclipse.acceleo.debug.event.model.StepOverRequest;
import org.eclipse.acceleo.debug.event.model.StepReturnRequest;
import org.eclipse.acceleo.debug.event.model.SuspendRequest;
import org.eclipse.acceleo.debug.event.model.TerminateRequest;
import org.eclipse.acceleo.debug.event.model.ValidateVariableValueRequest;
import org.eclipse.acceleo.debug.util.StackFrame;
import org.eclipse.acceleo.debug.util.ThreadController;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public abstract class AbstractDSLDebugger
implements IDSLDebugger {
    private final IDSLDebugEventProcessor target;
    private boolean terminated;
    private final Map<Long, ThreadController> controllers = new ConcurrentHashMap<Long, ThreadController>();
    private final Map<Long, String> threads = new LinkedHashMap<Long, String>();
    private final Map<URI, Map<String, Serializable>> breakpoints = new HashMap<URI, Map<String, Serializable>>();
    private final Map<Long, Deque<StackFrame>> stackFrames = new HashMap<Long, Deque<StackFrame>>();
    private boolean noDebug;

    public AbstractDSLDebugger(IDSLDebugEventProcessor target) {
        this.target = target;
    }

    protected Map<URI, Map<String, Serializable>> getBreakpoints() {
        return this.breakpoints;
    }

    @Override
    public Object handleEvent(IDSLDebugEvent event) {
        Object res = null;
        if (event instanceof DisconnectRequest) {
            this.disconnect();
        } else if (event instanceof AbstractStepRequest) {
            this.handleStepRequest((AbstractStepRequest)event);
        } else if (event instanceof ResumeRequest) {
            this.handleResumeRequest((ResumeRequest)event);
        } else if (event instanceof SuspendRequest) {
            this.handleSuspendRequest((SuspendRequest)event);
        } else if (event instanceof TerminateRequest) {
            this.handleTerminateRequest((TerminateRequest)event);
        } else if (event instanceof AbstractBreakpointRequest) {
            this.handleBreakpointRequest((AbstractBreakpointRequest)event);
        } else if (event instanceof ValidateVariableValueRequest) {
            res = this.handleValidateVariableValueRequest((ValidateVariableValueRequest)event);
        } else if (event instanceof SetVariableValueRequest) {
            this.handleSetVariableValueRequest((SetVariableValueRequest)event);
        } else if (event instanceof InitializeRequest) {
            this.initialize(((InitializeRequest)event).isNoDebug(), ((InitializeRequest)event).getArguments());
        } else if (event instanceof StartRequest) {
            this.start();
        }
        return res;
    }

    private void handleSetVariableValueRequest(SetVariableValueRequest event) {
        Object value = this.getVariableValue(event.getThreadID(), event.getStackName(), event.getVariableName(), event.getValue());
        this.setVariableValue(event.getThreadID(), event.getStackName(), event.getVariableName(), value);
        this.target.handleEvent(new SetVariableValueReply(event.getThreadID(), event.getStackName(), event.getVariableName(), value));
    }

    private Object handleValidateVariableValueRequest(ValidateVariableValueRequest event) {
        return this.validateVariableValue(event.getThreadID(), event.getVariableName(), event.getValue());
    }

    private void handleBreakpointRequest(AbstractBreakpointRequest breakpointRequest) {
        if (breakpointRequest instanceof AddBreakpointRequest) {
            this.addBreakPoint(breakpointRequest.getURI());
        } else if (breakpointRequest instanceof RemoveBreakpointRequest) {
            this.removeBreakPoint(breakpointRequest.getURI());
        } else if (breakpointRequest instanceof ChangeBreakPointRequest) {
            this.changeBreakPoint(breakpointRequest.getURI(), ((ChangeBreakPointRequest)breakpointRequest).getAttribute(), ((ChangeBreakPointRequest)breakpointRequest).getValue());
        }
    }

    private void handleTerminateRequest(TerminateRequest terminateRequest) {
        Long threadID = terminateRequest.getThreadID();
        if (threadID != null) {
            this.terminate(threadID);
        } else {
            this.terminate();
            this.target.handleEvent(new TerminatedReply());
        }
    }

    private void handleSuspendRequest(SuspendRequest suspendRequest) {
        Long threadID = suspendRequest.getThreadID();
        if (threadID != null) {
            this.suspend(threadID);
        } else {
            this.suspend();
        }
    }

    private void handleResumeRequest(ResumeRequest resumeRequest) {
        Long threadID = resumeRequest.getThreadID();
        if (threadID != null) {
            this.resume(threadID);
        } else {
            this.resume();
        }
    }

    private void handleStepRequest(AbstractStepRequest stepRequest) {
        Long threadID = stepRequest.getThreadID();
        if (stepRequest instanceof StepIntoRequest) {
            this.stepInto(threadID);
        } else if (stepRequest instanceof StepOverRequest) {
            this.stepOver(threadID);
        } else if (stepRequest instanceof StepReturnRequest) {
            this.stepReturn(threadID);
        }
    }

    @Override
    public void stepped(Long threadID) {
        this.target.handleEvent(new SteppedReply(threadID));
    }

    @Override
    public void suspended(Long threadID) {
        this.target.handleEvent(new SuspendedReply(threadID));
    }

    @Override
    public void breaked(Long threadID) {
        this.target.handleEvent(new BreakpointReply(threadID));
    }

    @Override
    public void resuming(Long threadID) {
        this.target.handleEvent(new ResumingReply(threadID));
    }

    @Override
    public void steppingInto(Long threadID) {
        this.target.handleEvent(new StepIntoResumingReply(threadID));
    }

    @Override
    public void steppingOver(Long threadID) {
        this.target.handleEvent(new StepOverResumingReply(threadID));
    }

    @Override
    public void steppingReturn(Long threadID) {
        this.target.handleEvent(new StepReturnResumingReply(threadID));
    }

    @Override
    public void terminated() {
        this.setTerminated(true);
        this.target.handleEvent(new TerminatedReply());
    }

    @Override
    public void spawnRunningThread(Long threadID, String threadName, EObject context) {
        this.target.handleEvent(new SpawnRunningThreadReply(threadID, threadName, context));
        this.controllers.put(threadID, this.createThreadController(threadID));
        this.threads.put(threadID, threadName);
        this.stackFrames.put(threadID, new ArrayDeque());
    }

    @Override
    public Map<Long, String> getThreads() {
        return new LinkedHashMap<Long, String>(this.threads);
    }

    protected ThreadController createThreadController(Long threadID) {
        return new ThreadController(this, threadID);
    }

    @Override
    public void setTerminated(boolean terminated) {
        this.terminated = terminated;
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    @Override
    public boolean shouldBreak(EObject instruction) {
        return this.breakpoints.containsKey(EcoreUtil.getURI((EObject)instruction));
    }

    protected Serializable getBreakpointAttributes(EObject instruction, String attribute) {
        Map<String, Serializable> attributes = this.breakpoints.get(EcoreUtil.getURI((EObject)instruction));
        Serializable res = attributes != null ? attributes.get(attribute) : null;
        return res;
    }

    @Override
    public void addBreakPoint(URI instruction) {
        this.breakpoints.put(instruction, new HashMap());
    }

    @Override
    public void removeBreakPoint(URI instruction) {
        this.breakpoints.remove(instruction);
    }

    @Override
    public void clearBreakPoints() {
        this.breakpoints.clear();
    }

    @Override
    public void changeBreakPoint(URI instruction, String attribute, Serializable value) {
        Map<String, Serializable> attributes = this.breakpoints.get(instruction);
        attributes.put(attribute, value);
    }

    @Override
    public boolean control(Long threadID, EObject instruction) {
        boolean res = this.noDebug ? true : (!this.isTerminated() ? this.controllers.get(threadID).control(instruction) : false);
        return res;
    }

    @Override
    public void resume(Long threadID) {
        this.controllers.get(threadID).resume();
    }

    @Override
    public void stepInto(Long threadID) {
        this.controllers.get(threadID).stepInto();
    }

    @Override
    public void stepOver(Long threadID) {
        this.controllers.get(threadID).stepOver();
    }

    @Override
    public void stepReturn(Long threadID) {
        this.controllers.get(threadID).stepReturn();
    }

    @Override
    public void suspend(Long threadID) {
        this.controllers.get(threadID).suspend();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        this.setTerminated(true);
        Iterator<ThreadController> iterator = this.controllers.values().iterator();
        while (iterator.hasNext()) {
            ThreadController controler;
            ThreadController threadController = controler = iterator.next();
            synchronized (threadController) {
                controler.wakeUp();
            }
        }
        this.controllers.clear();
        this.threads.clear();
        this.stackFrames.clear();
    }

    @Override
    public void terminate(Long threadID) {
        if (this.controllers.containsKey(threadID)) {
            this.controllers.get(threadID).terminate();
        }
    }

    @Override
    public void suspend() {
        for (ThreadController controler : this.controllers.values()) {
            controler.suspend();
        }
    }

    @Override
    public void resume() {
        for (ThreadController controler : this.controllers.values()) {
            controler.resume();
        }
    }

    @Override
    public void variable(Long threadID, String stackName, String declarationTypeName, String variableName, Object value, boolean supportModifications) {
        this.target.handleEvent(new VariableReply(threadID, stackName, declarationTypeName, variableName, value, supportModifications));
    }

    @Override
    public void deleteVariable(Long threadID, String name) {
        this.target.handleEvent(new DeleteVariableReply(threadID, name));
    }

    @Override
    public void terminated(Long threadID) {
        this.target.handleEvent(new TerminatedReply(threadID));
        this.controllers.remove(threadID);
        this.threads.remove(threadID);
        this.stackFrames.remove(threadID);
        if (this.controllers.size() == 0) {
            this.setTerminated(true);
            this.terminated();
        }
    }

    @Override
    public boolean isTerminated(Long threadID) {
        return !this.controllers.containsKey(threadID);
    }

    protected void setNoDebug(boolean noDebug) {
        this.noDebug = noDebug;
    }

    public boolean isNoDebug() {
        return this.noDebug;
    }

    protected void pushStackFrame(Long threadID, EObject context) {
        if (this.isTerminated()) {
            return;
        }
        this.stackFrames.get(threadID).addLast(new StackFrame(context));
    }

    protected StackFrame peekStackFrame(Long threadID) {
        if (this.isTerminated()) {
            return null;
        }
        return this.stackFrames.get(threadID).getLast();
    }

    protected StackFrame popStackFrame(Long threadID) {
        if (this.isTerminated()) {
            return null;
        }
        return this.stackFrames.get(threadID).removeLast();
    }

    @Override
    public Deque<StackFrame> getStackFrame(Long threadID) {
        if (this.isTerminated()) {
            return new ArrayDeque<StackFrame>();
        }
        return this.stackFrames.get(threadID);
    }
}

