/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.tests;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.acceleo.query.services.ResourceServices;
import org.eclipse.acceleo.query.services.tests.AbstractEngineInitializationWithCrossReferencer;
import org.eclipse.acceleo.query.tests.Setup;
import org.eclipse.acceleo.query.tests.UnitTestModels;
import org.eclipse.acceleo.query.tests.qmodel.QmodelPackage;
import org.eclipse.acceleo.query.tests.qmodel.Queries;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResourceServicesTest
extends AbstractEngineInitializationWithCrossReferencer {
    public ResourceServices resourceServices;
    public Resource reverseModel;
    public Resource umlWithFragment;
    public Resource umlFragment;

    @Before
    public void setup() throws URISyntaxException, IOException {
        this.resourceServices = new ResourceServices();
        this.reverseModel = new UnitTestModels(Setup.createSetupForCurrentEnvironment()).reverse();
        this.umlWithFragment = new UnitTestModels(Setup.createSetupForCurrentEnvironment()).umlWithFragment();
        EObject umlRoot = (EObject)this.umlWithFragment.getContents().get(0);
        EList umlContent = umlRoot.eContents();
        this.umlFragment = ((EObject)umlContent.get(0)).eResource();
        Assert.assertNotEquals((Object)this.umlWithFragment, (Object)this.umlFragment);
    }

    @Test
    public void testEResource() {
        TreeIterator iterator = EcoreUtil.getAllContents((Resource)this.reverseModel, (boolean)true);
        while (iterator.hasNext()) {
            Assert.assertEquals((Object)this.reverseModel, (Object)this.resourceServices.eResource((EObject)iterator.next()));
        }
    }

    @Test
    public void testEResourceFragment() {
        TreeIterator iterator = EcoreUtil.getAllContents((Resource)this.umlWithFragment, (boolean)true);
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            if (next.toString().contains("sameResource")) {
                Assert.assertEquals((Object)this.umlWithFragment, (Object)this.resourceServices.eResource(next));
                continue;
            }
            Assert.assertEquals((Object)this.umlFragment, (Object)this.resourceServices.eResource(next));
        }
    }

    @Test
    public void testGetURI() {
        URI reverseURI = this.resourceServices.getURI(this.reverseModel);
        Assert.assertEquals((Object)"reverse.qmodel", (Object)reverseURI.lastSegment());
    }

    @Test
    public void testGetURIFragment() {
        URI containerURI = this.resourceServices.getURI(this.umlWithFragment);
        Assert.assertEquals((Object)"container.uml", (Object)containerURI.lastSegment());
        URI fragmentURI = this.resourceServices.getURI(this.umlFragment);
        Assert.assertEquals((Object)"controlled.uml", (Object)fragmentURI.lastSegment());
    }

    @Test
    public void testGetContents() {
        List reverseContents = this.resourceServices.getContents(this.reverseModel);
        Assert.assertEquals((long)1L, (long)reverseContents.size());
        Assert.assertTrue((boolean)(reverseContents.get(0) instanceof Queries));
        reverseContents.clear();
        Assert.assertFalse((boolean)this.reverseModel.getContents().isEmpty());
    }

    @Test
    public void testGetContentsFragment() {
        List containerContents = this.resourceServices.getContents(this.umlWithFragment);
        Assert.assertEquals((long)1L, (long)containerContents.size());
        EObject containerRoot = (EObject)containerContents.get(0);
        Assert.assertTrue((boolean)(containerRoot instanceof Package));
        Assert.assertEquals((long)2L, (long)containerRoot.eContents().size());
        EObject fragmentedPackage = (EObject)containerRoot.eContents().get(0);
        Assert.assertTrue((boolean)(fragmentedPackage instanceof Package));
        containerContents.clear();
        Assert.assertFalse((boolean)this.umlWithFragment.getContents().isEmpty());
        List fragmentContents = this.resourceServices.getContents(this.umlFragment);
        Assert.assertEquals((long)1L, (long)fragmentContents.size());
        Assert.assertEquals((Object)fragmentedPackage, fragmentContents.get(0));
    }

    @Test
    public void testGetContentsFiltered() {
        List reverseContentsNone = this.resourceServices.getContents(this.reverseModel, EcorePackage.eINSTANCE.getEPackage());
        Assert.assertTrue((boolean)reverseContentsNone.isEmpty());
        List reverseContentsQueries = this.resourceServices.getContents(this.reverseModel, QmodelPackage.eINSTANCE.getQueries());
        Assert.assertEquals((long)1L, (long)reverseContentsQueries.size());
        Assert.assertTrue((boolean)(reverseContentsQueries.get(0) instanceof Queries));
        reverseContentsQueries.clear();
        Assert.assertFalse((boolean)this.reverseModel.getContents().isEmpty());
    }

    @Test
    public void testGetContentsFilteredAsEObject() {
        List reverseContentsAll = this.resourceServices.getContents(this.reverseModel, EcorePackage.eINSTANCE.getEObject());
        Assert.assertEquals((Object)this.reverseModel.getContents(), (Object)reverseContentsAll);
    }

    @Test
    public void testGetContentsFilteredFragment() {
        List umlContentsNone = this.resourceServices.getContents(this.umlWithFragment, UMLPackage.eINSTANCE.getClass_());
        Assert.assertTrue((boolean)umlContentsNone.isEmpty());
        List umlContentsPackage = this.resourceServices.getContents(this.umlWithFragment, UMLPackage.eINSTANCE.getPackage());
        Assert.assertEquals((long)1L, (long)umlContentsPackage.size());
        Assert.assertTrue((boolean)(umlContentsPackage.get(0) instanceof Package));
        umlContentsPackage.clear();
        Assert.assertFalse((boolean)this.umlWithFragment.getContents().isEmpty());
    }

    @Test
    public void testLastSegment() {
        URI reverseURI = this.reverseModel.getURI();
        Assert.assertEquals((Object)"reverse.qmodel", (Object)this.resourceServices.lastSegment(reverseURI));
    }

    @Test
    public void testLastSegmentFragment() {
        URI containerURI = this.umlWithFragment.getURI();
        Assert.assertEquals((Object)"container.uml", (Object)this.resourceServices.lastSegment(containerURI));
        URI fragmentURI = this.umlFragment.getURI();
        Assert.assertEquals((Object)"controlled.uml", (Object)this.resourceServices.lastSegment(fragmentURI));
    }

    @Test
    public void testfileExtension() {
        URI reverseURI = this.reverseModel.getURI();
        Assert.assertEquals((Object)"qmodel", (Object)this.resourceServices.fileExtension(reverseURI));
    }

    @Test
    public void testfileExtensionFragment() {
        URI containerURI = this.umlWithFragment.getURI();
        Assert.assertEquals((Object)"uml", (Object)this.resourceServices.fileExtension(containerURI));
        URI fragmentURI = this.umlFragment.getURI();
        Assert.assertEquals((Object)"uml", (Object)this.resourceServices.fileExtension(fragmentURI));
    }

    @Test
    public void testIsPlatformResource() {
        URI typoUri = URI.createURI((String)"platform:/ressource/typo");
        Assert.assertFalse((boolean)this.resourceServices.isPlatformResource(typoUri));
        URI fileUri = URI.createURI((String)"file://absolute/uri");
        Assert.assertFalse((boolean)this.resourceServices.isPlatformResource(fileUri));
        URI goodURI = URI.createURI((String)"platform:/resource/good/one");
        Assert.assertTrue((boolean)this.resourceServices.isPlatformResource(goodURI));
    }

    @Test
    public void testIsPlatformPlugin() {
        URI typoUri = URI.createURI((String)"platform:/plug-in/typo");
        Assert.assertFalse((boolean)this.resourceServices.isPlatformPlugin(typoUri));
        URI fileUri = URI.createURI((String)"file://absolute/uri");
        Assert.assertFalse((boolean)this.resourceServices.isPlatformPlugin(fileUri));
        URI goodURI = URI.createURI((String)"platform:/plugin/good/one");
        Assert.assertTrue((boolean)this.resourceServices.isPlatformPlugin(goodURI));
    }
}

