/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.acceleo.query.ast.Binding;
import org.eclipse.acceleo.query.ast.BooleanLiteral;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.CollectionTypeLiteral;
import org.eclipse.acceleo.query.ast.Conditional;
import org.eclipse.acceleo.query.ast.EnumLiteral;
import org.eclipse.acceleo.query.ast.Error;
import org.eclipse.acceleo.query.ast.ErrorBinding;
import org.eclipse.acceleo.query.ast.ErrorCall;
import org.eclipse.acceleo.query.ast.ErrorEnumLiteral;
import org.eclipse.acceleo.query.ast.ErrorExpression;
import org.eclipse.acceleo.query.ast.ErrorFeatureAccessOrCall;
import org.eclipse.acceleo.query.ast.ErrorTypeLiteral;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.FeatureAccess;
import org.eclipse.acceleo.query.ast.IntegerLiteral;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.ast.Let;
import org.eclipse.acceleo.query.ast.NullLiteral;
import org.eclipse.acceleo.query.ast.RealLiteral;
import org.eclipse.acceleo.query.ast.SequenceInExtensionLiteral;
import org.eclipse.acceleo.query.ast.SetInExtensionLiteral;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.ast.TypeSetLiteral;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.ast.util.AstSwitch;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.ValidationMessageLevel;
import org.eclipse.acceleo.query.runtime.impl.ValidationMessage;
import org.eclipse.acceleo.query.runtime.impl.ValidationResult;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierSetLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.LambdaType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;

public class AstValidator
extends AstSwitch<Set<IType>> {
    private static final String VARIABLE_OVERRIDES_AN_EXISTING_VALUE = "Variable %s overrides an existing value.";
    private static final String SHOULD_NEVER_HAPPEN = "should never happen";
    protected ValidationResult validationResult;
    private final ValidationServices services;
    private final Stack<Map<String, Set<IType>>> variableTypesStack = new Stack();
    private Set<IValidationMessage> messages = new LinkedHashSet<IValidationMessage>();

    public AstValidator(IQueryEnvironment environment, Map<String, Set<IType>> variableTypes) {
        this.variableTypesStack.push(variableTypes);
        this.services = new ValidationServices(environment);
    }

    private Set<IType> checkWarningsAndErrors(Expression expression, Set<IType> types) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        ArrayList<ValidationMessage> msgs = new ArrayList<ValidationMessage>();
        for (IType type : types) {
            if (type instanceof NothingType) {
                IQueryBuilderEngine.AstResult astResult = this.validationResult.getAstResult();
                int startPostion = expression instanceof Call ? astResult.getEndPosition((Expression)((Call)expression).getArguments().get(0)) : (expression instanceof FeatureAccess ? astResult.getEndPosition(((FeatureAccess)expression).getTarget()) : astResult.getStartPosition(expression));
                int endPosition = astResult.getEndPosition(expression);
                msgs.add(new ValidationMessage(ValidationMessageLevel.WARNING, ((NothingType)type).getMessage(), startPostion, endPosition));
                continue;
            }
            result.add(type);
        }
        if (result.size() == 0) {
            for (ValidationMessage message : msgs) {
                message.setLevel(ValidationMessageLevel.ERROR);
            }
        }
        this.messages.addAll(msgs);
        this.validationResult.addTypes(expression, result);
        return result;
    }

    @Override
    public Set<IType> caseBooleanLiteral(BooleanLiteral object) {
        Set<IType> possibleTypes = this.services.getIType(Boolean.class);
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseCall(Call call) {
        Set<IType> possibleTypes;
        List<Set<IType>> argTypes = this.inferArgTypes(call);
        String serviceName = call.getServiceName();
        switch (call.getType()) {
            case CALLSERVICE: {
                possibleTypes = this.services.callType(call, this.validationResult, serviceName, argTypes);
                break;
            }
            case CALLORAPPLY: {
                possibleTypes = this.services.callOrApplyTypes(call, this.validationResult, serviceName, argTypes);
                break;
            }
            case COLLECTIONCALL: {
                possibleTypes = this.services.collectionServiceCallTypes(call, this.validationResult, serviceName, argTypes);
                break;
            }
            default: {
                throw new UnsupportedOperationException(SHOULD_NEVER_HAPPEN);
            }
        }
        return this.checkWarningsAndErrors(call, possibleTypes);
    }

    private List<Set<IType>> inferArgTypes(Call call) {
        ArrayList<Set<IType>> result = new ArrayList<Set<IType>>();
        if (call.getArguments().size() == 1) {
            if ("not".equals(call.getServiceName())) {
                Expression operand = (Expression)call.getArguments().get(0);
                Set operandTypes = (Set)this.doSwitch(operand);
                result.add(operandTypes);
                this.inferNotTypes(call, operand);
            } else {
                result.add((Set)this.doSwitch((EObject)call.getArguments().get(0)));
            }
        } else if (call.getArguments().size() == 2) {
            if ("oclIsKindOf".equals(call.getServiceName())) {
                Expression receiver = (Expression)call.getArguments().get(0);
                Set receiverTypes = (Set)this.doSwitch(receiver);
                Set argTypes = (Set)this.doSwitch((EObject)call.getArguments().get(1));
                result.add(receiverTypes);
                result.add(argTypes);
                if (receiver instanceof VarRef) {
                    this.inferOclIsKindOfTypes(call, (VarRef)receiver, argTypes);
                }
            } else if ("oclIsTypeOf".equals(call.getServiceName())) {
                Expression receiver = (Expression)call.getArguments().get(0);
                Set receiverTypes = (Set)this.doSwitch(receiver);
                Set argTypes = (Set)this.doSwitch((EObject)call.getArguments().get(1));
                result.add(receiverTypes);
                result.add(argTypes);
                if (receiver instanceof VarRef) {
                    this.inferOclIsTypeOfTypes(call, (VarRef)receiver, argTypes);
                }
            } else if ("and".equals(call.getServiceName())) {
                Expression leftOperand = (Expression)call.getArguments().get(0);
                Set leftOperandTypes = (Set)this.doSwitch(leftOperand);
                HashMap<String, Set<IType>> rightOperandInferredTypes = new HashMap<String, Set<IType>>(this.variableTypesStack.peek());
                rightOperandInferredTypes.putAll(this.validationResult.getInferredVariableTypes(leftOperand, Boolean.TRUE));
                this.doSwitch((EObject)call.getArguments().get(1));
                this.inferAndTypes(call);
                this.variableTypesStack.push(rightOperandInferredTypes);
                LinkedHashSet rightOperandTypes = new LinkedHashSet();
                try {
                    rightOperandTypes.addAll((Collection)this.doSwitch((EObject)call.getArguments().get(1)));
                    result.add(leftOperandTypes);
                    result.add(rightOperandTypes);
                }
                finally {
                    this.variableTypesStack.pop();
                }
            } else if ("or".equals(call.getServiceName()) || "xor".equals(call.getServiceName())) {
                Expression leftOperand = (Expression)call.getArguments().get(0);
                Set leftOperandTypes = (Set)this.doSwitch(leftOperand);
                HashMap<String, Set<IType>> rightOperandInferredTypes = new HashMap<String, Set<IType>>(this.variableTypesStack.peek());
                rightOperandInferredTypes.putAll(this.validationResult.getInferredVariableTypes(leftOperand, Boolean.FALSE));
                this.doSwitch((EObject)call.getArguments().get(1));
                this.inferOrTypes(call);
                this.variableTypesStack.push(rightOperandInferredTypes);
                LinkedHashSet rightOperandTypes = new LinkedHashSet();
                try {
                    rightOperandTypes.addAll((Collection)this.doSwitch((EObject)call.getArguments().get(1)));
                    result.add(leftOperandTypes);
                    result.add(rightOperandTypes);
                }
                finally {
                    this.variableTypesStack.pop();
                }
            } else {
                result.add((Set)this.doSwitch((EObject)call.getArguments().get(0)));
                result.add((Set)this.doSwitch((EObject)call.getArguments().get(1)));
            }
        } else {
            for (Expression arg : call.getArguments()) {
                result.add((Set)this.doSwitch(arg));
            }
        }
        return result;
    }

    private void inferNotTypes(Call call, Expression operand) {
        Map<String, Set<IType>> inferredOperandTrueTypes = this.validationResult.getInferredVariableTypes(operand, Boolean.TRUE);
        Map<String, Set<IType>> inferredOperandFalseTypes = this.validationResult.getInferredVariableTypes(operand, Boolean.FALSE);
        this.validationResult.putInferredVariableTypes(call, Boolean.TRUE, inferredOperandFalseTypes);
        this.validationResult.putInferredVariableTypes(call, Boolean.FALSE, inferredOperandTrueTypes);
    }

    private void inferOclIsKindOfTypes(Call call, VarRef varRef, Set<IType> argTypes) {
        Set<IType> originalTypes = this.variableTypesStack.peek().get(varRef.getVariableName());
        if (originalTypes != null) {
            ValidationMessage message;
            IQueryBuilderEngine.AstResult astResult;
            LinkedHashSet<IType> inferredTrueTypes = new LinkedHashSet<IType>();
            LinkedHashSet<IType> inferredFalseTypes = new LinkedHashSet<IType>();
            StringBuilder messageWhenTrue = new StringBuilder("Always false:");
            StringBuilder messageWhenFalse = new StringBuilder("Always true:");
            for (IType originalType : originalTypes) {
                if (originalType instanceof NothingType) {
                    inferredTrueTypes.add(originalType);
                    inferredFalseTypes.add(originalType);
                    continue;
                }
                for (IType argType : argTypes) {
                    this.inferOclIsKindOfForArgType(varRef, inferredTrueTypes, inferredFalseTypes, messageWhenTrue, messageWhenFalse, originalType, argType);
                }
            }
            if (!inferredTrueTypes.isEmpty()) {
                HashMap<String, Set<IType>> inferredTrueTypesMap = new HashMap<String, Set<IType>>();
                inferredTrueTypesMap.put(varRef.getVariableName(), inferredTrueTypes);
                this.validationResult.putInferredVariableTypes(call, Boolean.TRUE, inferredTrueTypesMap);
            } else {
                astResult = this.validationResult.getAstResult();
                int startPostion = astResult.getStartPosition(call);
                int endPosition = astResult.getEndPosition(call);
                message = new ValidationMessage(ValidationMessageLevel.INFO, messageWhenTrue.toString(), startPostion, endPosition);
                this.messages.add(message);
            }
            if (!inferredFalseTypes.isEmpty()) {
                HashMap<String, Set<IType>> inferredFalseTypesMap = new HashMap<String, Set<IType>>();
                inferredFalseTypesMap.put(varRef.getVariableName(), inferredFalseTypes);
                this.validationResult.putInferredVariableTypes(call, Boolean.FALSE, inferredFalseTypesMap);
            } else {
                astResult = this.validationResult.getAstResult();
                int startPostion = astResult.getStartPosition(call);
                int endPosition = astResult.getEndPosition(call);
                message = new ValidationMessage(ValidationMessageLevel.INFO, messageWhenFalse.toString(), startPostion, endPosition);
                this.validationResult.getMessages().add(message);
            }
        }
    }

    private void inferOclIsKindOfForArgType(VarRef varRef, Set<IType> inferredTrueTypes, Set<IType> inferredFalseTypes, StringBuilder messageWhenTrue, StringBuilder messageWhenFalse, IType originalType, IType argType) {
        IType lowerType = this.services.lower(originalType, argType);
        if (lowerType != null) {
            inferredTrueTypes.add(lowerType);
            if (lowerType.isAssignableFrom(argType) && !lowerType.equals(originalType)) {
                inferredFalseTypes.add(originalType);
            } else {
                messageWhenFalse.append(String.format("\nNothing inferred when %s (%s) is not kind of %s", varRef.getVariableName(), originalType, argType));
            }
        } else if (originalType.getType() instanceof EClass && argType.getType() instanceof EClass) {
            LinkedHashSet<EClassifierType> intesectionTypes = new LinkedHashSet<EClassifierType>();
            for (EClass eCls : this.services.getSubTypesTopIntersection((EClass)originalType.getType(), (EClass)argType.getType())) {
                intesectionTypes.add(new EClassifierType(this.services.getQueryEnvironment(), (EClassifier)eCls));
            }
            if (intesectionTypes.isEmpty()) {
                messageWhenTrue.append(String.format("\nNothing inferred when %s (%s) is kind of %s", varRef.getVariableName(), originalType, argType));
            } else {
                inferredTrueTypes.addAll(intesectionTypes);
            }
            inferredFalseTypes.add(originalType);
        } else {
            messageWhenTrue.append(String.format("\nNothing inferred when %s (%s) is kind of %s", varRef.getVariableName(), originalType, argType));
            inferredFalseTypes.add(originalType);
        }
    }

    private void inferOclIsTypeOfTypes(Call call, VarRef varRef, Set<IType> argTypes) {
        Set<IType> originalTypes = this.variableTypesStack.peek().get(varRef.getVariableName());
        if (originalTypes != null) {
            ValidationMessage message;
            IQueryBuilderEngine.AstResult astResult;
            LinkedHashSet<IType> inferredTrueTypes = new LinkedHashSet<IType>();
            LinkedHashSet<IType> inferredFalseTypes = new LinkedHashSet<IType>();
            StringBuilder messageWhenTrue = new StringBuilder("Always false:");
            StringBuilder messageWhenFalse = new StringBuilder("Always true:");
            for (IType originalType : originalTypes) {
                if (originalType instanceof NothingType) {
                    inferredTrueTypes.add(originalType);
                    inferredFalseTypes.add(originalType);
                    continue;
                }
                for (IType argType : argTypes) {
                    IType lowerType = this.services.lower(argType, argType);
                    if (lowerType.equals(originalType)) {
                        inferredTrueTypes.add(lowerType);
                        messageWhenFalse.append(String.format("\nNothing inferred when %s (%s) is not type of %s", varRef.getVariableName(), originalType, argType));
                        continue;
                    }
                    messageWhenTrue.append(String.format("\nNothing inferred when %s (%s) is type of %s", varRef.getVariableName(), originalType, argType));
                    inferredFalseTypes.add(originalType);
                }
            }
            if (!inferredTrueTypes.isEmpty()) {
                HashMap<String, Set<IType>> inferredTrueTypesMap = new HashMap<String, Set<IType>>();
                inferredTrueTypesMap.put(varRef.getVariableName(), inferredTrueTypes);
                this.validationResult.putInferredVariableTypes(call, Boolean.TRUE, inferredTrueTypesMap);
            } else {
                astResult = this.validationResult.getAstResult();
                int startPostion = astResult.getStartPosition(call);
                int endPosition = astResult.getEndPosition(call);
                message = new ValidationMessage(ValidationMessageLevel.INFO, messageWhenTrue.toString(), startPostion, endPosition);
                this.messages.add(message);
            }
            if (!inferredFalseTypes.isEmpty()) {
                HashMap<String, Set<IType>> inferredFalseTypesMap = new HashMap<String, Set<IType>>();
                inferredFalseTypesMap.put(varRef.getVariableName(), inferredFalseTypes);
                this.validationResult.putInferredVariableTypes(call, Boolean.FALSE, inferredFalseTypesMap);
            } else {
                astResult = this.validationResult.getAstResult();
                int startPostion = astResult.getStartPosition(call);
                int endPosition = astResult.getEndPosition(call);
                message = new ValidationMessage(ValidationMessageLevel.INFO, messageWhenFalse.toString(), startPostion, endPosition);
                this.validationResult.getMessages().add(message);
            }
        }
    }

    private void inferOrTypes(Call call) {
        Expression leftOperand = (Expression)call.getArguments().get(0);
        Expression rightOperand = (Expression)call.getArguments().get(1);
        Map<String, Set<IType>> inferredLeftVariableTypesWhenTrue = this.validationResult.getInferredVariableTypes(leftOperand, Boolean.TRUE);
        Map<String, Set<IType>> inferredRightVariableTypesWhenTrue = this.validationResult.getInferredVariableTypes(rightOperand, Boolean.TRUE);
        Map<String, Set<IType>> inferredLeftVariableTypesWhenFalse = this.validationResult.getInferredVariableTypes(leftOperand, Boolean.FALSE);
        Map<String, Set<IType>> inferredRightVariableTypesWhenFalse = this.validationResult.getInferredVariableTypes(rightOperand, Boolean.FALSE);
        Map<String, Set<IType>> orInferredTypesWhenTrue = this.unionInferredTypes(inferredLeftVariableTypesWhenTrue, inferredRightVariableTypesWhenTrue);
        Map<String, Set<IType>> orInferredTypesWhenFalse = this.intersectionInferredTypes(inferredLeftVariableTypesWhenFalse, inferredRightVariableTypesWhenFalse);
        this.validationResult.putInferredVariableTypes(call, Boolean.TRUE, orInferredTypesWhenTrue);
        this.validationResult.putInferredVariableTypes(call, Boolean.FALSE, orInferredTypesWhenFalse);
    }

    private Map<String, Set<IType>> unionInferredTypes(Map<String, Set<IType>> inferredLeftVariableTypes, Map<String, Set<IType>> inferredRightVariableTypes) {
        HashMap<String, Set<IType>> result = new HashMap<String, Set<IType>>();
        HashMap<String, Set<IType>> rightLocal = new HashMap<String, Set<IType>>(inferredRightVariableTypes);
        for (Map.Entry<String, Set<IType>> entry : inferredLeftVariableTypes.entrySet()) {
            LinkedHashSet inferredTypes = new LinkedHashSet(entry.getValue());
            Set inferredRightTypes = (Set)rightLocal.remove(entry.getKey());
            if (inferredRightTypes != null) {
                inferredTypes.addAll(inferredRightTypes);
            }
            result.put(entry.getKey(), inferredTypes);
        }
        result.putAll(rightLocal);
        return result;
    }

    private void inferAndTypes(Call call) {
        Expression leftOperand = (Expression)call.getArguments().get(0);
        Expression rightOperand = (Expression)call.getArguments().get(1);
        Map<String, Set<IType>> inferredLeftVariableTypesWhenTrue = this.validationResult.getInferredVariableTypes(leftOperand, Boolean.TRUE);
        Map<String, Set<IType>> inferredRightVariableTypesWhenTrue = this.validationResult.getInferredVariableTypes(rightOperand, Boolean.TRUE);
        Map<String, Set<IType>> inferredLeftVariableTypesWhenFalse = this.validationResult.getInferredVariableTypes(leftOperand, Boolean.FALSE);
        Map<String, Set<IType>> inferredRightVariableTypesWhenFalse = this.validationResult.getInferredVariableTypes(rightOperand, Boolean.FALSE);
        Map<String, Set<IType>> andInferredTypesWhenTrue = this.intersectionInferredTypes(inferredLeftVariableTypesWhenTrue, inferredRightVariableTypesWhenTrue);
        Map<String, Set<IType>> andInferredTypesWhenFalse = this.unionInferredTypes(inferredLeftVariableTypesWhenFalse, inferredRightVariableTypesWhenFalse);
        this.validationResult.putInferredVariableTypes(call, Boolean.TRUE, andInferredTypesWhenTrue);
        this.validationResult.putInferredVariableTypes(call, Boolean.FALSE, andInferredTypesWhenFalse);
    }

    private Map<String, Set<IType>> intersectionInferredTypes(Map<String, Set<IType>> inferredLeftVariableTypes, Map<String, Set<IType>> inferredRightVariableTypes) {
        HashMap<String, Set<IType>> result = new HashMap<String, Set<IType>>();
        HashMap<String, Set<IType>> rightLocal = new HashMap<String, Set<IType>>(inferredRightVariableTypes);
        for (Map.Entry<String, Set<IType>> entry : inferredLeftVariableTypes.entrySet()) {
            LinkedHashSet<IType> inferredTypes = new LinkedHashSet<IType>();
            Set inferredRightTypes = (Set)rightLocal.remove(entry.getKey());
            if (inferredRightTypes != null) {
                for (IType leftType : entry.getValue()) {
                    for (IType rightType : inferredRightTypes) {
                        inferredTypes.addAll(this.services.intersection(leftType, rightType));
                    }
                }
            } else {
                inferredTypes.addAll((Collection)entry.getValue());
            }
            result.put(entry.getKey(), inferredTypes);
        }
        result.putAll(rightLocal);
        return result;
    }

    @Override
    public Set<IType> caseCollectionTypeLiteral(CollectionTypeLiteral object) {
        LinkedHashSet<IType> possibleTypes = new LinkedHashSet<IType>();
        for (IType type : (Set)this.doSwitch(object.getElementType())) {
            if (object.getValue() == List.class) {
                possibleTypes.add(new SequenceType(this.services.getQueryEnvironment(), type));
                continue;
            }
            if (object.getValue() == Set.class) {
                possibleTypes.add(new SetType(this.services.getQueryEnvironment(), type));
                continue;
            }
            throw new UnsupportedOperationException(SHOULD_NEVER_HAPPEN);
        }
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseEnumLiteral(EnumLiteral object) {
        LinkedHashSet<IType> possibleTypes = new LinkedHashSet<IType>();
        possibleTypes.add(new EClassifierType(this.services.getQueryEnvironment(), (EClassifier)object.getLiteral().getEEnum()));
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseFeatureAccess(FeatureAccess object) {
        Set reveiverTypes = (Set)this.doSwitch(object.getTarget());
        String featureName = object.getFeatureName();
        Set<IType> flattened = this.services.featureAccessTypes(reveiverTypes, featureName);
        return this.checkWarningsAndErrors(object, flattened);
    }

    @Override
    public Set<IType> caseIntegerLiteral(IntegerLiteral object) {
        Set<IType> possibleTypes = this.services.getIType(Integer.class);
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseLambda(Lambda object) {
        LinkedHashSet<IType> lambdaExpressionTypes = new LinkedHashSet<IType>();
        HashMap<String, Set<IType>> newVariableTypes = new HashMap<String, Set<IType>>(this.variableTypesStack.peek());
        for (VariableDeclaration variableDeclaration : object.getParameters()) {
            Set<IType> types;
            if (variableDeclaration.getType() == null || variableDeclaration.getType() instanceof Error) {
                Set variableTypes = (Set)this.doSwitch(variableDeclaration);
                types = new LinkedHashSet();
                for (IType type : variableTypes) {
                    if (type instanceof ICollectionType) {
                        types.add(((ICollectionType)type).getCollectionType());
                        continue;
                    }
                    types.add(type);
                }
            } else {
                types = (Set)this.doSwitch(variableDeclaration.getType());
            }
            if (newVariableTypes.containsKey(variableDeclaration.getName())) {
                lambdaExpressionTypes.add(this.services.nothing(VARIABLE_OVERRIDES_AN_EXISTING_VALUE, variableDeclaration.getName()));
            }
            newVariableTypes.put(variableDeclaration.getName(), types);
        }
        this.variableTypesStack.push(newVariableTypes);
        Set lambdaExpressionPossibleTypes = (Set)this.doSwitch(object.getExpression());
        String evaluatorName = ((VariableDeclaration)object.getParameters().get(0)).getName();
        Set lambdaEvaluatorPossibleTypes = (Set)newVariableTypes.get(evaluatorName);
        for (IType lambdaEvaluatorPossibleType : lambdaEvaluatorPossibleTypes) {
            for (IType lambdaExpressionType : lambdaExpressionPossibleTypes) {
                lambdaExpressionTypes.add(new LambdaType(this.services.getQueryEnvironment(), evaluatorName, lambdaEvaluatorPossibleType, lambdaExpressionType));
            }
        }
        this.variableTypesStack.pop();
        return lambdaExpressionTypes;
    }

    @Override
    public Set<IType> caseRealLiteral(RealLiteral object) {
        Set<IType> possibleTypes = this.services.getIType(Double.class);
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseStringLiteral(StringLiteral object) {
        Set<IType> possibleTypes = this.services.getIType(String.class);
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseVarRef(VarRef object) {
        Set<IType> variableTypes = this.services.getVariableTypes(this.variableTypesStack.peek(), object.getVariableName());
        return this.checkWarningsAndErrors(object, variableTypes);
    }

    public IValidationResult validate(IQueryBuilderEngine.AstResult astResult) {
        this.validationResult = new ValidationResult(astResult);
        this.doSwitch(astResult.getAst());
        this.validationResult.getMessages().addAll(this.messages);
        this.messages = new LinkedHashSet<IValidationMessage>();
        return this.validationResult;
    }

    @Override
    public Set<IType> caseTypeLiteral(TypeLiteral object) {
        LinkedHashSet<IType> possibleTypes;
        if (object.getValue() instanceof EClassifier) {
            possibleTypes = new LinkedHashSet<EClassifierLiteralType>();
            possibleTypes.add(new EClassifierLiteralType(this.services.getQueryEnvironment(), (EClassifier)object.getValue()));
        } else if (object.getValue() instanceof Class) {
            possibleTypes = this.services.getIType((Class)object.getValue());
        } else {
            throw new UnsupportedOperationException(SHOULD_NEVER_HAPPEN);
        }
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseTypeSetLiteral(TypeSetLiteral object) {
        LinkedHashSet<IType> possibleTypes = new LinkedHashSet<IType>();
        LinkedHashSet<EClassifier> types = new LinkedHashSet<EClassifier>();
        EClassifierSetLiteralType possibleType = new EClassifierSetLiteralType(this.services.getQueryEnvironment(), types);
        possibleTypes.add(possibleType);
        for (TypeLiteral type : object.getTypes()) {
            if (types.add((EClassifier)type.getValue())) continue;
            possibleTypes.add(this.services.nothing("EClassifierLiteral=%s is duplicated in the type set literal.", ((EClassifier)type.getValue()).getName()));
        }
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseErrorCall(ErrorCall object) {
        for (Expression arg : object.getArguments()) {
            this.doSwitch(arg);
        }
        return this.checkWarningsAndErrors(object, this.services.getErrorTypes(object));
    }

    @Override
    public Set<IType> caseErrorExpression(ErrorExpression object) {
        return this.checkWarningsAndErrors(object, this.services.getErrorTypes(object));
    }

    @Override
    public Set<IType> caseErrorFeatureAccessOrCall(ErrorFeatureAccessOrCall object) {
        this.doSwitch(object.getTarget());
        return this.checkWarningsAndErrors(object, this.services.getErrorTypes(object));
    }

    @Override
    public Set<IType> caseErrorTypeLiteral(ErrorTypeLiteral object) {
        return this.checkWarningsAndErrors(object, this.services.getErrorTypes(object));
    }

    @Override
    public Set<IType> caseErrorEnumLiteral(ErrorEnumLiteral object) {
        return this.checkWarningsAndErrors(object, this.services.getErrorTypes(object));
    }

    @Override
    public Set<IType> caseNullLiteral(NullLiteral object) {
        LinkedHashSet<IType> possibleTypes = new LinkedHashSet<IType>();
        possibleTypes.add(new ClassType(this.services.getQueryEnvironment(), null));
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseSetInExtensionLiteral(SetInExtensionLiteral object) {
        LinkedHashSet<IType> possibleTypes = new LinkedHashSet<IType>();
        for (Expression expression : object.getValues()) {
            for (IType type : (Set)this.doSwitch(expression)) {
                possibleTypes.add(new SetType(this.services.getQueryEnvironment(), type));
            }
        }
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseSequenceInExtensionLiteral(SequenceInExtensionLiteral object) {
        LinkedHashSet<IType> possibleTypes = new LinkedHashSet<IType>();
        for (Expression expression : object.getValues()) {
            for (IType type : (Set)this.doSwitch(expression)) {
                possibleTypes.add(new SequenceType(this.services.getQueryEnvironment(), type));
            }
        }
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseVariableDeclaration(VariableDeclaration object) {
        return (Set)this.doSwitch(object.getExpression());
    }

    @Override
    public Set<IType> caseConditional(Conditional object) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        Set selectorTypes = (Set)this.doSwitch(object.getPredicate());
        HashMap<String, Set<IType>> trueBranchInferredTypes = new HashMap<String, Set<IType>>(this.variableTypesStack.peek());
        trueBranchInferredTypes.putAll(this.validationResult.getInferredVariableTypes(object.getPredicate(), Boolean.TRUE));
        this.variableTypesStack.push(trueBranchInferredTypes);
        LinkedHashSet trueTypes = new LinkedHashSet();
        try {
            trueTypes.addAll((Collection)this.doSwitch(object.getTrueBranch()));
        }
        finally {
            this.variableTypesStack.pop();
        }
        HashMap<String, Set<IType>> falseBranchInferredTypes = new HashMap<String, Set<IType>>(this.variableTypesStack.peek());
        falseBranchInferredTypes.putAll(this.validationResult.getInferredVariableTypes(object.getPredicate(), Boolean.FALSE));
        this.variableTypesStack.push(falseBranchInferredTypes);
        LinkedHashSet falseTypes = new LinkedHashSet();
        try {
            falseTypes.addAll((Collection)this.doSwitch(object.getFalseBranch()));
        }
        finally {
            this.variableTypesStack.pop();
        }
        if (!selectorTypes.isEmpty()) {
            boolean onlyBoolean = true;
            boolean onlyNotBoolean = true;
            ClassType booleanObjectType = new ClassType(this.services.getQueryEnvironment(), Boolean.class);
            ClassType booleanType = new ClassType(this.services.getQueryEnvironment(), Boolean.TYPE);
            for (IType type : selectorTypes) {
                boolean assignableFrom = booleanObjectType.isAssignableFrom(type) || booleanType.isAssignableFrom(type);
                onlyBoolean = onlyBoolean && assignableFrom;
                boolean bl = onlyNotBoolean = onlyNotBoolean && !assignableFrom;
                if (!onlyBoolean && !onlyNotBoolean) break;
            }
            if (onlyBoolean) {
                result.addAll(trueTypes);
                result.addAll(falseTypes);
            } else if (onlyNotBoolean) {
                result.add(this.services.nothing("The predicate never evaluates to a boolean type (%s).", selectorTypes));
            } else {
                result.add(this.services.nothing("The predicate may evaluate to a value that is not a boolean type (%s).", selectorTypes));
                result.addAll(trueTypes);
                result.addAll(falseTypes);
            }
        } else {
            result.add(this.services.nothing("The predicate never evaluates to a boolean type (%s).", selectorTypes));
        }
        return this.checkWarningsAndErrors(object, result);
    }

    @Override
    public Set<IType> caseLet(Let object) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        HashMap<String, Set<IType>> newVariableTypes = new HashMap<String, Set<IType>>(this.variableTypesStack.peek());
        for (Binding binding : object.getBindings()) {
            Set bindingTypes = (Set)this.doSwitch(binding);
            if (binding.getName() == null) continue;
            if (newVariableTypes.containsKey(binding.getName())) {
                result.add(this.services.nothing(VARIABLE_OVERRIDES_AN_EXISTING_VALUE, binding.getName()));
            }
            newVariableTypes.put(binding.getName(), bindingTypes);
        }
        this.variableTypesStack.push(newVariableTypes);
        try {
            Set bodyTypes = (Set)this.doSwitch(object.getBody());
            result.addAll(bodyTypes);
        }
        finally {
            this.variableTypesStack.pop();
        }
        return this.checkWarningsAndErrors(object, result);
    }

    @Override
    public Set<IType> caseBinding(Binding object) {
        return (Set)this.doSwitch(object.getValue());
    }

    @Override
    public Set<IType> caseErrorBinding(ErrorBinding object) {
        Set result = object.getValue() != null ? (Set)this.doSwitch(object.getValue()) : Collections.emptySet();
        return result;
    }
}

