/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.parser.AstCompletor;
import org.eclipse.acceleo.query.runtime.ICompletionResult;
import org.eclipse.acceleo.query.runtime.IQueryCompletionEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.CompletionResult;
import org.eclipse.acceleo.query.runtime.impl.CompletionServices;
import org.eclipse.acceleo.query.runtime.impl.QueryValidationEngine;
import org.eclipse.acceleo.query.validation.type.IType;

public class QueryCompletionEngine
implements IQueryCompletionEngine {
    private static final Set<String> KEYWORD_SET = Sets.newHashSet((Object[])new String[]{"if", "then", "else", "endif"});
    private IQueryEnvironment queryEnvironment;

    public QueryCompletionEngine(IQueryEnvironment queryEnvironment) {
        this.queryEnvironment = queryEnvironment;
    }

    @Override
    public ICompletionResult getCompletion(String expression, int offset, Map<String, Set<IType>> variableTypes) {
        AstCompletor completor = new AstCompletor(new CompletionServices(this.queryEnvironment));
        if (offset < 0 || expression != null && offset > expression.length()) {
            throw new IllegalArgumentException("offset must be in the range of the given expression.");
        }
        String prefix = this.getPrefix(expression, offset);
        String remaining = this.getRemaining(expression, offset);
        String toParse = this.getToParse(expression, offset, prefix);
        QueryValidationEngine builder = new QueryValidationEngine(this.queryEnvironment);
        IValidationResult validationResult = builder.validate(toParse, variableTypes);
        CompletionResult result = new CompletionResult(completor.getProposals(variableTypes.keySet(), validationResult));
        result.setPrefix(prefix);
        result.setRemaining(remaining);
        return result;
    }

    private String getPrefix(String expression, int offset) {
        String result;
        if (expression == null) {
            result = null;
        } else {
            int start = offset;
            while (start - 1 >= 0) {
                char charAt = expression.charAt(start - 1);
                if (!Character.isLetter(charAt) && !Character.isDigit(charAt) && charAt != '_') break;
                --start;
            }
            result = expression.substring(start, offset);
        }
        if (KEYWORD_SET.contains(result)) {
            return "";
        }
        return result;
    }

    private String getRemaining(String expression, int offset) {
        String result;
        if (expression == null) {
            result = null;
        } else {
            int length = expression.length();
            int end = offset;
            while (end < length) {
                char charAt = expression.charAt(end);
                if (!Character.isLetter(charAt) && !Character.isDigit(charAt) && charAt != '_') break;
                ++end;
            }
            result = expression.substring(offset, end);
        }
        return result;
    }

    private String getToParse(String expression, int offset, String prefix) {
        String result = expression == null ? null : expression.substring(0, offset - prefix.length());
        return result;
    }
}

