/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ide;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleElement;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.aql.parser.AcceleoParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;

public class AcceleoPlugin
extends EMFPlugin {
    public static final String PLUGIN_ID = "org.eclipse.acceleo.aql.ide";
    public static final AcceleoPlugin INSTANCE = new AcceleoPlugin();
    private static Implementation plugin;

    public AcceleoPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static AcceleoPlugin getDefault() {
        return INSTANCE;
    }

    public static void log(Exception exception, boolean blocker) {
        int severity = 2;
        if (blocker) {
            severity = 4;
        }
        INSTANCE.log(new Status(severity, PLUGIN_ID, exception.getMessage(), (Throwable)exception));
    }

    public static void log(String message, boolean blocker) {
        String errorMessage;
        int severity = 2;
        if (blocker) {
            severity = 4;
        }
        if ((errorMessage = message) == null || "".equals(errorMessage)) {
            errorMessage = "Logging null message should never happens.";
        }
        INSTANCE.log(new Status(severity, PLUGIN_ID, errorMessage));
    }

    public static boolean isAcceleoMain(IResource resource) {
        boolean res = false;
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            if (file.isAccessible()) {
                AcceleoParser parser = new AcceleoParser();
                try {
                    Throwable throwable = null;
                    Object var5_8 = null;
                    try (InputStream contents = file.getContents();){
                        Module module = parser.parse(contents, file.getCharset(), "none").getModule();
                        for (ModuleElement element : module.getModuleElements()) {
                            if (!(element instanceof Template) || !((Template)element).isMain()) continue;
                            res = true;
                            break;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    AcceleoPlugin.getPlugin().log(new Status(4, PLUGIN_ID, "couldn't parse module " + String.valueOf(resource.getFullPath()), (Throwable)e));
                }
                catch (CoreException e) {
                    AcceleoPlugin.getPlugin().log(new Status(4, PLUGIN_ID, "couldn't parse module " + String.valueOf(resource.getFullPath()), (Throwable)e));
                }
            } else {
                res = false;
            }
        } else {
            res = false;
        }
        return res;
    }

    public static boolean isAcceleoMain(URIConverter uriConverter, URI uri) {
        boolean res = false;
        if (uriConverter.exists(uri, Collections.emptyMap())) {
            AcceleoParser parser = new AcceleoParser();
            try {
                String encoding;
                InputStream is;
                Throwable throwable = null;
                Object var6_8 = null;
                try {
                    is = uriConverter.createInputStream(uri);
                    try {
                        encoding = parser.parseEncoding(is);
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                throwable = null;
                var6_8 = null;
                try {
                    is = uriConverter.createInputStream(uri);
                    try {
                        Module module = parser.parse(is, encoding, "none").getModule();
                        for (ModuleElement element : module.getModuleElements()) {
                            if (!(element instanceof Template) || !((Template)element).isMain()) continue;
                            res = true;
                            break;
                        }
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                AcceleoPlugin.getPlugin().log(new Status(4, PLUGIN_ID, "couldn't parse module " + String.valueOf(uri), (Throwable)e));
            }
        } else {
            res = false;
        }
        return res;
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }
    }
}

