/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.runtime.AcceleoQueryEvaluationException;
import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.ecore.EClass;

public abstract class AbstractService<O>
implements IService<O> {
    private final O origin;
    private IReadOnlyQueryEnvironment knwonEnvironment;
    private Set<IType> returnTypes;
    private List<Set<IType>> parameterTypes;

    protected AbstractService(O serviceOrigin) {
        this.origin = serviceOrigin;
    }

    @Override
    public O getOrigin() {
        return this.origin;
    }

    @Override
    public List<Set<IType>> getParameterTypes(IReadOnlyQueryEnvironment queryEnvironment) {
        if (this.knwonEnvironment != queryEnvironment || this.returnTypes == null) {
            this.knwonEnvironment = queryEnvironment;
            this.parameterTypes = this.computeParameterTypes(queryEnvironment);
        }
        return this.parameterTypes;
    }

    protected abstract List<Set<IType>> computeParameterTypes(IReadOnlyQueryEnvironment var1);

    @Override
    public Set<IType> getType(IReadOnlyQueryEnvironment queryEnvironment) {
        if (this.knwonEnvironment != queryEnvironment || this.returnTypes == null) {
            this.knwonEnvironment = queryEnvironment;
            this.returnTypes = this.computeType(queryEnvironment);
        }
        return new LinkedHashSet<IType>(this.returnTypes);
    }

    protected abstract Set<IType> computeType(IReadOnlyQueryEnvironment var1);

    @Override
    public boolean isEqualParameterTypes(IReadOnlyQueryEnvironment queryEnvironment, IService<?> service) {
        boolean result;
        List<Set<IType>> paramTypes1 = this.getParameterTypes(queryEnvironment);
        List<Set<IType>> paramTypes2 = service.getParameterTypes(queryEnvironment);
        if (paramTypes1.size() == paramTypes2.size()) {
            Iterator<Set<IType>> it1 = paramTypes1.iterator();
            Iterator<Set<IType>> it2 = paramTypes2.iterator();
            result = true;
            block0: while (it1.hasNext()) {
                Set<IType> types1 = it1.next();
                Set<IType> types2 = it2.next();
                for (IType type1 : types1) {
                    boolean isEquals = false;
                    for (IType type2 : types2) {
                        if (!type2.equals(type1)) continue;
                        isEquals = true;
                        break;
                    }
                    if (isEquals) continue;
                    result = false;
                    continue block0;
                }
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public boolean isLowerOrEqualParameterTypes(IReadOnlyQueryEnvironment queryEnvironment, IService<?> service) {
        boolean result;
        List<Set<IType>> paramTypes1 = this.getParameterTypes(queryEnvironment);
        List<Set<IType>> paramTypes2 = service.getParameterTypes(queryEnvironment);
        if (paramTypes1.size() == paramTypes2.size()) {
            Iterator<Set<IType>> it1 = paramTypes1.iterator();
            Iterator<Set<IType>> it2 = paramTypes2.iterator();
            result = true;
            block0: while (it1.hasNext()) {
                Set<IType> types1 = it1.next();
                Set<IType> types2 = it2.next();
                for (IType paramType1 : types1) {
                    boolean isAssignable = false;
                    for (IType paramType2 : types2) {
                        if (!paramType2.isAssignableFrom(paramType1)) continue;
                        isAssignable = true;
                        break;
                    }
                    if (isAssignable) continue;
                    result = false;
                    continue block0;
                }
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public boolean matches(IReadOnlyQueryEnvironment queryEnvironment, IType[] argumentTypes) {
        assert (this.getNumberOfParameters() == argumentTypes.length);
        boolean result = true;
        List<Set<IType>> parameterTypes = this.getParameterTypes(queryEnvironment);
        int i = 0;
        while (i < parameterTypes.size() && result) {
            if (argumentTypes[i].getType() != null) {
                boolean oneAssignable = false;
                for (IType parameterType : parameterTypes.get(i)) {
                    if (!parameterType.isAssignableFrom(argumentTypes[i])) continue;
                    oneAssignable = true;
                    break;
                }
                if (!oneAssignable) {
                    result = false;
                    break;
                }
            }
            ++i;
        }
        return result;
    }

    @Override
    public Set<IType> validateAllType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, Map<List<IType>, Set<IType>> allTypes) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        for (Map.Entry<List<IType>, Set<IType>> entry : allTypes.entrySet()) {
            result.addAll((Collection<IType>)entry.getValue());
        }
        return result;
    }

    @Override
    public Object invoke(Object ... arguments) throws AcceleoQueryEvaluationException {
        Object result;
        try {
            result = this.internalInvoke(arguments);
        }
        catch (Exception e) {
            String message;
            Throwable cause;
            if (e.getCause() != null) {
                if (e instanceof InvocationTargetException) {
                    cause = e.getCause();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    cause.printStackTrace(pw);
                    message = sw.toString().replaceAll("\n", "\n\t");
                } else if (e instanceof AcceleoQueryEvaluationException) {
                    if (e.getCause().getCause() != null) {
                        cause = e.getCause().getCause();
                        message = cause.getMessage();
                    } else {
                        cause = e.getCause();
                        message = cause.getMessage();
                    }
                } else {
                    cause = e.getCause();
                    message = cause.getMessage();
                }
            } else {
                cause = e;
                message = cause.getMessage();
            }
            throw new AcceleoQueryEvaluationException(this.getShortSignature() + " with arguments " + Arrays.deepToString(arguments) + " failed:\n\t" + message, cause);
        }
        return result;
    }

    protected abstract Object internalInvoke(Object[] var1) throws Exception;

    protected String serviceShortSignature(Object[] argumentTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName()).append('(');
        boolean first = true;
        Object[] objectArray = argumentTypes;
        int n = argumentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Object argType = objectArray[n2];
            if (!first) {
                builder.append(',');
            } else {
                first = false;
            }
            builder.append(this.getTypeString(argType));
            ++n2;
        }
        return builder.append(')').toString();
    }

    private String getTypeString(Object argType) {
        Object res;
        if (argType instanceof Set) {
            Set types = (Set)argType;
            if (types.size() > 1) {
                StringJoiner joiner = new StringJoiner(" | ");
                for (Object type : types) {
                    joiner.add(this.getTypeString(type));
                }
                res = joiner.toString();
            } else {
                res = types.size() == 1 ? this.getTypeString(types.iterator().next()) : "???";
            }
        } else {
            res = argType instanceof Class ? ((Class)argType).getCanonicalName() : (argType instanceof EClass ? "EClass=" + ((EClass)argType).getName() : (argType == null ? "Object=null" : "Object=" + argType.toString()));
        }
        return res;
    }

    public String toString() {
        return this.getLongSignature();
    }

    @Override
    public List<ICompletionProposal> getProposals(IReadOnlyQueryEnvironment queryEnvironment, Set<IType> receiverTypes) {
        return Collections.emptyList();
    }

    @Override
    public IService.Visibility getVisibility() {
        return IService.Visibility.PUBLIC;
    }

    @Override
    public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
        return this.getType(queryEnvironment);
    }

    public boolean equals(Object obj) {
        return obj instanceof IService && (this.getOrigin() == null && ((IService)obj).getOrigin() == null || this.getOrigin().equals(((IService)obj).getOrigin()));
    }

    public int hashCode() {
        int res = this.getOrigin() != null ? this.getOrigin().hashCode() : super.hashCode();
        return res;
    }
}

