/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.EClassifierTypeLiteral;
import org.eclipse.acceleo.query.ast.EnumLiteral;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.runtime.AcceleoQueryEvaluationException;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.impl.AbstractLanguageServices;
import org.eclipse.acceleo.query.runtime.impl.Nothing;
import org.eclipse.acceleo.query.runtime.impl.NullValue;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameLookupEngine;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;

public class EvaluationServices
extends AbstractLanguageServices {
    private static final String INTERNAL_ERROR_MSG = "An internal error occurred during evaluation of a query";

    public EvaluationServices(IReadOnlyQueryEnvironment queryEnv) {
        super(queryEnv);
    }

    public Object getVariableValue(Map<String, Object> variableDefinitions, String variableName, Diagnostic diagnostic) {
        try {
            Object result = variableDefinitions.get(variableName);
            if (result == null && !variableDefinitions.containsKey(variableName)) {
                Nothing placeHolder = this.nothing("Couldn't find the '%s' variable", variableName);
                this.addDiagnosticFor(diagnostic, 4, placeHolder);
                result = placeHolder;
            }
            return result;
        }
        catch (NullPointerException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
    }

    private Nothing nothing(String message, Object ... msgArgs) {
        String formatedMessage = String.format(message, msgArgs);
        return new Nothing(formatedMessage);
    }

    private Object internalCallService(Call call, IService<?> service, Object[] arguments, IType[] argumentTypes, Diagnostic diagnostic) {
        try {
            Object result;
            Object value = service.invoke(arguments);
            if (value instanceof Nothing) {
                this.addDiagnosticFor(diagnostic, 2, (Nothing)value);
                result = value;
            } else if (value == null && !this.isLambda(call)) {
                List<IType> types = Arrays.asList(argumentTypes);
                Set<IType> serviceTypes = service.getType(call, new ValidationServices(this.queryEnvironment), null, this.queryEnvironment, types);
                result = new NullValue(serviceTypes);
            } else {
                result = value;
            }
            return result;
        }
        catch (AcceleoQueryEvaluationException e) {
            Nothing placeHolder = new Nothing(e.getMessage(), e);
            if (e.getCause() instanceof AcceleoQueryEvaluationException) {
                this.addDiagnosticFor(diagnostic, 2, placeHolder);
            } else {
                this.addDiagnosticFor(diagnostic, 4, placeHolder);
            }
            return placeHolder;
        }
    }

    private boolean isLambda(Call call) {
        return call.getArguments().size() == 2 && call.getArguments().get(1) instanceof Lambda;
    }

    public Object call(Call call, Object[] arguments, Diagnostic diagnostic) {
        Object result;
        switch (call.getType()) {
            case CALLSERVICE: {
                result = this.internalCall(call, arguments, diagnostic);
                break;
            }
            case CALLORAPPLY: {
                result = this.internalCallOrApply(call, arguments, diagnostic);
                break;
            }
            case COLLECTIONCALL: {
                result = this.internalCollectionServiceCall(call, arguments, diagnostic);
                break;
            }
            default: {
                throw new UnsupportedOperationException("should never happen");
            }
        }
        return result;
    }

    private Object internalCall(Call call, Object[] arguments, Diagnostic diagnostic) {
        Object result;
        String serviceName = call.getServiceName();
        if (arguments.length == 0) {
            throw new AcceleoQueryEvaluationException("An internal error occurred during evaluation of a query : at least one argument must be specified for service " + serviceName + ".");
        }
        try {
            IType[] argumentTypes = new IType[arguments.length];
            Object[] localArguments = new Object[arguments.length];
            int i = 0;
            while (i < arguments.length) {
                if (arguments[i] == null) {
                    argumentTypes[i] = new ClassType(this.queryEnvironment, null);
                    localArguments[i] = null;
                } else if (arguments[i].getClass() == NullValue.class) {
                    argumentTypes[i] = ((NullValue)arguments[i]).getType();
                    localArguments[i] = null;
                } else if (arguments[i] instanceof EObject) {
                    argumentTypes[i] = new EClassifierType(this.queryEnvironment, (EClassifier)((EObject)arguments[i]).eClass());
                    localArguments[i] = arguments[i];
                } else {
                    argumentTypes[i] = new ClassType(this.queryEnvironment, arguments[i].getClass());
                    localArguments[i] = arguments[i];
                }
                ++i;
            }
            IService<?> service = call.isSuperCall() ? ((IQualifiedNameLookupEngine)this.queryEnvironment.getLookupEngine()).superServiceLookup(serviceName, argumentTypes) : this.queryEnvironment.getLookupEngine().lookup(serviceName, argumentTypes);
            if (service == null) {
                Nothing placeHolder = this.nothing("Couldn't find the '%s' service", this.serviceSignature(serviceName, argumentTypes));
                this.addDiagnosticFor(diagnostic, 2, placeHolder);
                result = placeHolder;
            } else {
                result = this.internalCallService(call, service, localArguments, argumentTypes, diagnostic);
            }
        }
        catch (Exception e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        return result;
    }

    private Object internalCallOrApply(Call call, Object[] arguments, Diagnostic diagnostic) {
        try {
            Object result;
            if (arguments[0] instanceof List) {
                List list = (List)arguments[0];
                result = this.applyCallOnSequence(call, list, arguments, diagnostic);
            } else if (arguments[0] instanceof Set) {
                Set set = (Set)arguments[0];
                result = this.applyCallOnSet(call, set, arguments, diagnostic);
            } else {
                result = this.internalCall(call, arguments, diagnostic);
            }
            return result;
        }
        catch (Exception e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
    }

    private Object internalCollectionServiceCall(Call call, Object[] arguments, Diagnostic diagnostic) {
        try {
            Object[] newArguments;
            LinkedHashSet receiver = arguments[0];
            if (!(receiver instanceof Collection) && !(receiver instanceof Nothing)) {
                LinkedHashSet newReceiver = new LinkedHashSet();
                if (receiver != null) {
                    newReceiver.add(receiver);
                }
                receiver = newReceiver;
                newArguments = (Object[])arguments.clone();
                newArguments[0] = newReceiver;
            } else {
                newArguments = arguments;
            }
            return this.internalCall(call, newArguments, diagnostic);
        }
        catch (Exception e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
    }

    private Object applyCallOnSequence(Call call, List<Object> origin, Object[] arguments, Diagnostic diagnostic) {
        try {
            ArrayList<Object> result = new ArrayList<Object>(origin.size());
            Object[] innerArguments = (Object[])arguments.clone();
            Iterator<Object> iterator = origin.iterator();
            while (iterator.hasNext()) {
                Object obj;
                innerArguments[0] = obj = iterator.next();
                Object newResult = this.internalCallOrApply(call, innerArguments, diagnostic);
                this.flattenList(result, newResult);
            }
            return result;
        }
        catch (Exception e) {
            throw new AcceleoQueryEvaluationException("empty argument array passed to callOrApply " + call.getServiceName(), e);
        }
    }

    protected void flattenList(List<Object> list, Object object) {
        if (!(object instanceof Nothing)) {
            if (object instanceof Collection) {
                list.addAll((Collection)object);
            } else if (object != null && object.getClass() != NullValue.class) {
                list.add(object);
            }
        }
    }

    private Object applyCallOnSet(Call call, Set<Object> origin, Object[] arguments, Diagnostic diagnostic) {
        try {
            LinkedHashSet<Object> result = new LinkedHashSet<Object>(origin.size());
            Object[] innerArguments = (Object[])arguments.clone();
            Iterator<Object> iterator = origin.iterator();
            while (iterator.hasNext()) {
                Object obj;
                innerArguments[0] = obj = iterator.next();
                Object newResult = this.internalCallOrApply(call, innerArguments, diagnostic);
                this.flattenSet(result, newResult);
            }
            return result;
        }
        catch (Exception e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
    }

    protected void flattenSet(Set<Object> set, Object object) {
        if (!(object instanceof Nothing)) {
            if (object instanceof Collection) {
                set.addAll((Collection)object);
            } else if (object != null && object.getClass() != NullValue.class) {
                set.add(object);
            }
        }
    }

    protected String serviceSignature(String serviceName, IType[] argumentTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append(serviceName).append('(');
        boolean first = true;
        IType[] iTypeArray = argumentTypes;
        int n = argumentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType argType = iTypeArray[n2];
            if (!first) {
                builder.append(',');
            } else {
                first = false;
            }
            if (argType == null) {
                builder.append("Object=null");
            } else {
                builder.append(argType.toString());
            }
            ++n2;
        }
        return builder.append(')').toString();
    }

    private void addDiagnosticFor(Diagnostic chain, int severity, Nothing nothing) {
        if (chain instanceof DiagnosticChain) {
            BasicDiagnostic child = new BasicDiagnostic(severity, "org.eclipse.acceleo.query", 0, nothing.getMessage(), new Object[]{nothing.getCause()});
            ((DiagnosticChain)chain).add((Diagnostic)child);
        }
    }

    public EClassifier getEClassifier(EClassifierTypeLiteral eClassifierTypeLiteral) {
        Set<EClassifier> eClassifiers = this.queryEnvironment.getEPackageProvider().getTypes(eClassifierTypeLiteral.getEPackageName(), eClassifierTypeLiteral.getEClassifierName());
        EClassifier result = eClassifiers.isEmpty() ? null : (EClassifier)eClassifiers.iterator().next();
        return result;
    }

    public EEnumLiteral getEEnumLiteral(EnumLiteral enumLiteral) {
        Collection<EEnumLiteral> literals = this.queryEnvironment.getEPackageProvider().getEnumLiterals(enumLiteral.getEPackageName(), enumLiteral.getEEnumName(), enumLiteral.getEEnumLiteralName());
        EEnumLiteral result = literals.isEmpty() ? null : literals.iterator().next();
        return result;
    }
}

