/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.view.nonvis;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.TooManyListenersException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.ascape.model.Agent;
import org.ascape.model.CellOccupant;
import org.ascape.model.HostCell;
import org.ascape.model.LocatedAgent;
import org.ascape.model.event.ScapeEvent;
import org.ascape.model.space.Coordinate;
import org.ascape.model.space.Coordinate1DContinuous;
import org.ascape.model.space.Coordinate1DDiscrete;
import org.ascape.model.space.Coordinate2DContinuous;
import org.ascape.model.space.Coordinate2DDiscrete;
import org.ascape.util.PropertyAccessor;
import org.ascape.util.VectorSelection;
import org.ascape.view.nonvis.NonGraphicView;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ScapeFromXMLView
extends NonGraphicView {
    private static final long serialVersionUID = 1L;
    private Element rootElement;
    public static final int UNDEFINED_MODE = 0;
    public static final int SIZE_BY_FILE = 1;
    public static final int SIZE_BY_SCAPE = 2;
    public static final int UNDEFINED_ORDER = 0;
    public static final int RANDOM_ORDER = 1;
    public static final int SEQUENTIAL_ORDER = 2;
    private PropertyDescriptor[] candidateDescriptors;
    private int mode = 0;
    private int assignmentOrder = 0;
    private int readOrder = 0;
    private ArrayList elementList;

    public void parseFile(String inputFileName) {
        try {
            FileInputStream fis = new FileInputStream(new File(inputFileName));
            this.parseStream(fis);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void parseStream(InputStream is) {
        this.rootElement = ScapeFromXMLView.streamToElelement(is);
        this.mode = this.determineMode(this.rootElement.getAttribute("sizeMode"));
        this.assignmentOrder = this.determineAssignmentOrder(this.rootElement.getAttribute("assignmentOrder"));
        this.readOrder = this.determineReadOrder(this.rootElement.getAttribute("readOrder"));
    }

    public void scapeAdded(ScapeEvent scapeEvent) throws TooManyListenersException {
        super.scapeAdded(scapeEvent);
        if (this.rootElement == null) {
            throw new RuntimeException("Root element is null. Be sure a file name was set, via 'inputFileName'.");
        }
        if (this.mode == 0) {
            this.getScape().getEnvironment().getConsole().println("No mode has been set -- setting mode to size by scape.");
            this.mode = 2;
        }
        if (this.assignmentOrder == 0) {
            this.getScape().getEnvironment().getConsole().println("No assignment order has been set -- setting assignment order to random order.");
            this.assignmentOrder = 1;
        }
        if (this.readOrder == 0) {
            this.getScape().getEnvironment().getConsole().println("No read order has been set -- setting read order to random order.");
            this.readOrder = 1;
        }
        if (this.mode == 1) {
            if (this.getScape() != null && !this.getScape().isMutable()) {
                throw new RuntimeException("Population size can not be defined by file for immutable (fixed size) scapes. Set PopulationSizeDefinedByFile to size by scape or use a mutable scape.");
            }
            this.scape.setPopulateOnCreate(false);
        }
    }

    public void scapeInitialized(ScapeEvent scapeEvent) {
        Agent currentAgent;
        super.scapeInitialized(scapeEvent);
        if (this.mode == 1) {
            this.getScape().clear();
        }
        NodeList agentsList = this.rootElement.getElementsByTagName("agent");
        this.elementList = new ArrayList(agentsList.getLength());
        int i = 0;
        while (i < agentsList.getLength()) {
            Element agentEl = (Element)agentsList.item(i);
            this.elementList.add(agentEl);
            ++i;
        }
        if (this.readOrder == 1) {
            Collections.shuffle(this.elementList, this.getScape().getRandom());
        }
        try {
            this.candidateDescriptors = Introspector.getBeanInfo(this.getScape().getPrototypeAgent().getClass(), Agent.class).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("While reading prototype agent descriptors: " + e);
        }
        Iterator scapeIterator = null;
        if (this.mode == 2) {
            if (this.assignmentOrder == 2) {
                scapeIterator = this.getScape().iterator();
            } else if (this.assignmentOrder == 1) {
                scapeIterator = this.getScape().getSpace().safeRandomIterator();
            } else {
                throw new RuntimeException("Undefined or unknown assignment order value.");
            }
        }
        if (scapeIterator != null) {
            while (scapeIterator.hasNext()) {
                currentAgent = (Agent)scapeIterator.next();
                if (this.elementList.isEmpty()) {
                    this.getScape().getEnvironment().getConsole().println("Warning: ScapeFile contains less data than there are agents in the target scape: " + this.getScape());
                    continue;
                }
                Element agentElement = (Element)this.elementList.remove(0);
                this.setParametersfor(currentAgent, agentElement);
            }
            if (!this.elementList.isEmpty()) {
                this.getScape().getEnvironment().getConsole().println("Warning: ScapeFile contains more data than there are agents in the target scape: " + this.getScape());
            }
        } else {
            for (Element agentElement : this.elementList) {
                VectorSelection initRulesHolder;
                if (this.assignmentOrder == 1) {
                    initRulesHolder = this.getScape().getInitialRules();
                    this.getScape().setInitialRules(new VectorSelection(new Vector()));
                    currentAgent = this.getScape().newAgent(true);
                    this.getScape().setInitialRules(initRulesHolder);
                } else {
                    initRulesHolder = this.getScape().getInitialRules();
                    this.getScape().setInitialRules(new VectorSelection(new Vector()));
                    currentAgent = this.getScape().newAgent(false);
                    this.getScape().setInitialRules(initRulesHolder);
                }
                this.setParametersfor(currentAgent, agentElement);
            }
        }
    }

    private void setParametersfor(Agent currentAgent, Element agentElement) {
        String xCoord = agentElement.getAttribute("x");
        String yCoord = agentElement.getAttribute("y");
        Number xObj = null;
        Number yObj = null;
        String decimalRegex = "/[[0-9].[0-9]]/";
        if (xCoord.length() > 0) {
            xObj = xCoord.matches(decimalRegex) ? (Number)new Double(xCoord) : (Number)new Integer(xCoord);
        }
        if (yCoord.length() > 0) {
            if (xObj == null) {
                throw new RuntimeException("No matching x coordinate in: " + currentAgent + ",  " + agentElement);
            }
            yObj = yCoord.matches(decimalRegex) ? (Number)(xObj instanceof Double ? (Number)new Double(yCoord) : (Number)new Integer(yCoord)) : (Number)(xObj instanceof Double ? (Number)new Double(yCoord) : (Number)new Integer(yCoord));
        }
        if (xObj != null) {
            if (!(currentAgent instanceof LocatedAgent)) {
                this.getScape().getEnvironment().getConsole().println(currentAgent + " is not an instance of LocatedAgent, so it can't have a coordinate.");
            } else {
                CellOccupant cell;
                Coordinate coor = null;
                if (yObj == null) {
                    if (xObj instanceof Double) {
                        coor = new Coordinate1DContinuous((Double)xObj);
                        ((LocatedAgent)currentAgent).moveTo(coor);
                    } else {
                        coor = new Coordinate1DDiscrete((Integer)xObj);
                        cell = (CellOccupant)currentAgent;
                        cell.moveTo((HostCell)cell.getHostScape().get(coor));
                    }
                } else if (xObj instanceof Double) {
                    coor = new Coordinate2DContinuous((Double)xObj, (Double)yObj);
                    ((LocatedAgent)currentAgent).moveTo(coor);
                } else if (currentAgent instanceof CellOccupant) {
                    coor = new Coordinate2DDiscrete((Integer)xObj, (Integer)yObj);
                    cell = (CellOccupant)currentAgent;
                    cell.moveTo((HostCell)cell.getHostScape().get(coor));
                } else {
                    ((LocatedAgent)currentAgent).moveTo(coor);
                }
            }
        }
        NodeList parametersList = agentElement.getElementsByTagName("parameter");
        int i = 0;
        while (i < parametersList.getLength()) {
            Element parameter = (Element)parametersList.item(i);
            String name = parameter.getAttribute("name");
            String value = parameter.getAttribute("value");
            boolean paramFound = false;
            int j = 0;
            while (j < this.candidateDescriptors.length) {
                PropertyDescriptor desc = this.candidateDescriptors[j];
                if (desc.getName().equalsIgnoreCase(name)) {
                    paramFound = true;
                    Object[] args = new Object[1];
                    try {
                        args[0] = PropertyAccessor.stringAsClass(desc.getPropertyType(), value);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Error - " + value + " cannot be converted to (" + desc.getPropertyType() + ") " + desc.getDisplayName());
                    }
                    try {
                        desc.getWriteMethod().invoke((Object)currentAgent, args);
                    }
                    catch (IllegalAccessException e) {
                        this.getScape().getEnvironment().getConsole().println("Error in dynamic method write: " + e);
                    }
                    catch (IllegalArgumentException e) {
                        this.getScape().getEnvironment().getConsole().println("Error in dynamic method write: " + e);
                    }
                    catch (InvocationTargetException e) {
                        this.getScape().getEnvironment().getConsole().println("Error in dynamic method write: " + e);
                    }
                    catch (NullPointerException e) {
                        throw new RuntimeException("Bad Property Descriptor: " + desc.getName());
                    }
                }
                ++j;
            }
            if (!paramFound) {
                throw new RuntimeException("Property " + name + " not found in prototype agent class: " + this.getScape().getPrototypeAgent().getClass().getName());
            }
            ++i;
        }
    }

    private static Element streamToElelement(InputStream is) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(is);
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return document.getDocumentElement();
    }

    private int determineMode(String modeAttribute) {
        if (modeAttribute.equalsIgnoreCase("size by file")) {
            return 1;
        }
        if (modeAttribute.equalsIgnoreCase("size by scape")) {
            return 2;
        }
        this.getScape().getEnvironment().getConsole().println("Mode attribute not recognized: " + modeAttribute + ". Setting mode to size by file.");
        return 1;
    }

    private int determineAssignmentOrder(String orderAttribute) {
        if (orderAttribute.equalsIgnoreCase("random order")) {
            return 1;
        }
        if (orderAttribute.equalsIgnoreCase("sequential order")) {
            return 2;
        }
        this.getScape().getEnvironment().getConsole().println("Assignment order attribute not recognized: " + orderAttribute + ". Setting assignment order to sequential order.");
        return 2;
    }

    private int determineReadOrder(String orderAttribute) {
        if (orderAttribute.equalsIgnoreCase("random order")) {
            return 1;
        }
        if (orderAttribute.equalsIgnoreCase("sequential order")) {
            return 2;
        }
        this.getScape().getEnvironment().getConsole().println("Read order attribute not recognized: " + orderAttribute + ". Setting read order to sequential order.");
        return 2;
    }

    public int getAssignmentOrder() {
        return this.assignmentOrder;
    }

    public void setAssignmentOrder(int assignmentOrder) {
        this.assignmentOrder = assignmentOrder;
    }

    public int getReadOrder() {
        return this.readOrder;
    }

    public void setReadOrder(int readOrder) {
        this.readOrder = readOrder;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }
}

