/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf.chart;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.amp.agf.chart.BasicChartStrategy;
import org.eclipse.amp.agf.chart.IDataProvider;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithoutAxesImpl;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.type.impl.PieSeriesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PieStrategy
extends BasicChartStrategy {
    private PieSeries numberSeries;
    private Series labelSeries;
    private SeriesDefinition labelDefinition;
    private SeriesDefinition numberDefinition;
    protected Collection<String> labels = new HashSet<String>();
    protected List<Double> numbers = new ArrayList<Double>();

    @Override
    public Chart createChart(IDataProvider dataProvider, Object dataSource) {
        this.dataProvider = dataProvider;
        this.dataSource = dataSource;
        ChartWithoutAxes chart = ChartWithoutAxesImpl.create();
        this.setChart((Chart)chart);
        chart.setDimension(ChartDimension.TWO_DIMENSIONAL_LITERAL);
        chart.setType("Pie Chart");
        chart.setSubType("Standard Pie Chart");
        chart.setSeriesThickness(10.0);
        TextDataSet labelSet = TextDataSetImpl.create(this.getLabels());
        NumberDataSet numberSet = NumberDataSetImpl.create(this.getNumbers());
        this.labelSeries = SeriesImpl.create();
        this.labelSeries.setDataSet((DataSet)labelSet);
        this.labelDefinition = SeriesDefinitionImpl.create();
        chart.getSeriesDefinitions().add((Object)this.labelDefinition);
        this.labelDefinition.getSeriesPalette().shift(0);
        this.labelDefinition.getSeries().add((Object)this.labelSeries);
        this.numberSeries = (PieSeries)PieSeriesImpl.create();
        this.numberSeries.setDataSet((DataSet)numberSet);
        this.numberSeries.setExplosion(0);
        this.numberDefinition = SeriesDefinitionImpl.create();
        this.numberDefinition.getSeries().add((Object)this.numberSeries);
        this.labelDefinition.getSeriesDefinitions().add((Object)this.numberDefinition);
        return chart;
    }

    @Override
    public SeriesDefinition getValueSetsDefinition() {
        return this.labelDefinition;
    }

    @Override
    public void updateSelection() {
        this.numbers.clear();
        this.labels.clear();
        for (Object valueSet : this.dataProvider.getValueSets(this.dataSource)) {
            List values = (List)this.dataProvider.getValues(valueSet);
            this.numbers.add(0.0);
            String text = this.dataProvider.getText(valueSet);
            this.labels.add(text);
        }
    }

    @Override
    public void update() {
        int index = 0;
        for (Object valueSet : this.dataProvider.getValueSets(this.dataSource)) {
            List values = (List)this.dataProvider.getValues(valueSet);
            this.numbers.set(index++, (Double)values.get(values.size() - 1));
        }
    }

    @Override
    public boolean isInitialized() {
        return this.labelDefinition.getSeries().size() > 0;
    }

    public void setLabels(Collection<String> labels) {
        this.labels = labels;
    }

    public Collection<String> getLabels() {
        return this.labels;
    }

    public void setNumbers(List<Double> numbers) {
        this.numbers = numbers;
    }

    public List<Double> getNumbers() {
        return this.numbers;
    }
}

