/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.acore.edit.commands.test;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.amp.amf.acore.edit.commands.test.AddStyle2D;
import org.eclipse.amp.amf.acore.edit.commands.test.CommandTest;
import org.eclipse.amp.amf.acore.edit.commands.test.CommandTransformer;
import org.eclipse.amp.amf.acore.edit.commands.test.ModelConstructionCommandTest;
import org.eclipse.amp.amf.acore.edit.commands.test.PrePostCondition;
import org.eclipse.amp.amf.acore.edit.commands.test.RenameAgentCommand;
import org.eclipse.amp.amf.acore.edit.commands.test.RenameSubContextCommand;
import org.eclipse.amp.amf.acore.edit.commands.test.SetID;
import org.eclipse.amp.amf.acore.edit.commands.test.SetLabel;
import org.eclipse.amp.amf.acore.edit.commands.test.SetStyleAgent;
import org.eclipse.amp.amf.acore.edit.commands.test.SetTransformer;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.metaabm.IID;
import org.metaabm.MetaABMFactory;
import org.metaabm.MetaABMPackage;
import org.metaabm.SAgent;
import org.metaabm.SAttribute;
import org.metaabm.SStyle;

public class ModelIDsCommandTest
extends CommandTest {
    public ModelIDsCommandTest(String name) {
        super(name);
    }

    public void testSetLabelAttribute() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return AddCommand.create((EditingDomain)this.getDomain(), (Object)this.model, (Object)MetaABMPackage.Literals.SATTRIBUTED__ATTRIBUTES, (Object)MetaABMFactory.eINSTANCE.createSAttribute());
            }
        });
        cmds.add(new SetLabel("Attribute", "Test Attribute"){

            public IID getIID() {
                return (IID)this.model.getAttributes().get(0);
            }
        });
        this.executeTests(cmds);
    }

    public void testRenameRootContext() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildBasic(cmds);
        cmds.add(new SetLabel("Root Context", "Test Model"){

            public void preCondition() {
                super.preCondition();
            }

            public void postCondition() {
                super.postCondition();
                ModelIDsCommandTest.assertEquals((String)this.model.getLabel(), (String)"Test Model");
                ModelIDsCommandTest.assertEquals((String)((SAgent)this.model.getAgents().get(0)).getLabel(), (String)"Root Context Agent");
            }
        });
        this.executeTests(cmds);
    }

    public void testRenameAgents() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildBasic(cmds);
        cmds.add(new RenameAgentCommand());
        cmds.add(new RenameSubContextCommand());
        this.executeTests(cmds);
    }

    public void testNoOverwriteIDs() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildBasic(cmds);
        cmds.add(new SetID("rootContext", "thx1295"){

            public Command getCommand() {
                return super.getCommand();
            }
        });
        cmds.add(new SetLabel("Root Context", "Another Context"){

            @Override
            public void addPrePost(List<PrePostCondition> list) {
            }

            @Override
            public void preCondition() {
                super.preCondition();
                ModelIDsCommandTest.assertEquals((String)this.model.getID(), (String)"thx1295");
            }

            @Override
            public void postCondition() {
                ModelIDsCommandTest.assertEquals((String)this.model.getID(), (String)"thx1295");
            }
        });
        cmds.add(new SetID("thx1295", "anotherContext"){

            public void postCondition() {
                ModelIDsCommandTest.assertEquals((String)this.model.getID(), (String)"anotherContext");
            }
        });
        cmds.add(new SetLabel("Another Context", "Some Other Context"){

            @Override
            public void addPrePost(List<PrePostCondition> list) {
            }

            @Override
            public void postCondition() {
                ModelIDsCommandTest.assertEquals((String)this.model.getID(), (String)"someOtherContext");
            }
        });
        this.executeTests(cmds);
    }

    public void testNoOverwritePlurals() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildBasic(cmds);
        cmds.add(new SetLabel("Root Context Agent", "Wolf"){

            public void postCondition() {
                super.postCondition();
                ModelIDsCommandTest.assertEquals((String)this.getSNamed().getPluralLabel(), (String)"Wolfs");
            }

            public IID getIID() {
                return (IID)this.model.getAgents().get(0);
            }
        });
        cmds.add(new SetTransformer((EStructuralFeature)MetaABMPackage.Literals.SNAMED__PLURAL_LABEL, "Wolves"){

            public void postCondition() {
                super.postCondition();
                ModelIDsCommandTest.assertEquals((String)this.getSNamed().getPluralLabel(), (String)"Wolves");
            }

            public IID getIID() {
                return (IID)this.model.getAgents().get(0);
            }
        });
        cmds.add(new SetLabel("Wolf", "Wombat"){

            @Override
            public void addPrePost(List<PrePostCondition> list) {
            }

            @Override
            public void postCondition() {
                super.postCondition();
                ModelIDsCommandTest.assertEquals((String)this.getSNamed().getPluralLabel(), (String)"Wolves");
            }

            @Override
            public IID getIID() {
                return (IID)this.model.getAgents().get(0);
            }
        });
        this.executeTests(cmds);
    }

    public void testNoOverwritePluralNames() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildBasic(cmds);
        cmds.add(new SetLabel("Root Context Agent", "Sheep"){

            public void postCondition() {
                super.postCondition();
                ModelIDsCommandTest.assertEquals((String)this.getSNamed().getPluralLabel(), (String)"Sheeps");
                ModelIDsCommandTest.assertEquals((String)((SAttribute)this.model.getAttributes().get(0)).getLabel(), (String)"Sheep Count");
                ModelIDsCommandTest.assertEquals((String)((SAttribute)this.model.getAttributes().get(0)).getDescription(), (String)"The number of sheeps to create.");
            }

            public IID getIID() {
                return (IID)this.model.getAgents().get(0);
            }
        });
        cmds.add(new SetTransformer((EStructuralFeature)MetaABMPackage.Literals.SNAMED__PLURAL_LABEL, "Sheep"){

            public void postCondition() {
                super.postCondition();
                ModelIDsCommandTest.assertEquals((String)this.getSNamed().getPluralLabel(), (String)"Sheep");
                ModelIDsCommandTest.assertEquals((String)((SAttribute)this.model.getAttributes().get(0)).getLabel(), (String)"Sheep Count");
                ModelIDsCommandTest.assertEquals((String)((SAttribute)this.model.getAttributes().get(0)).getDescription(), (String)"The number of sheeps to create.");
            }

            public IID getIID() {
                return (IID)this.model.getAttributes().get(0);
            }
        });
        cmds.add(new SetTransformer((EStructuralFeature)MetaABMPackage.Literals.SNAMED__DESCRIPTION, "Sheep!!!"){

            public void postCondition() {
                super.postCondition();
                ModelIDsCommandTest.assertEquals((String)((SAttribute)this.model.getAttributes().get(0)).getDescription(), (String)"Sheep!!!");
            }

            public IID getIID() {
                return (IID)this.model.getAttributes().get(0);
            }
        });
        cmds.add(new SetLabel("Sheep", "Wolf"){

            public void postCondition() {
                super.postCondition();
                ModelIDsCommandTest.assertEquals((String)this.getSNamed().getPluralLabel(), (String)"Wolfs");
                ModelIDsCommandTest.assertEquals((String)((SAttribute)this.model.getAttributes().get(0)).getLabel(), (String)"Wolf Count");
                ModelIDsCommandTest.assertEquals((String)((SAttribute)this.model.getAttributes().get(0)).getDescription(), (String)"Sheep!!!");
            }

            public IID getIID() {
                return (IID)this.model.getAgents().get(0);
            }
        });
        this.executeTests(cmds);
    }

    public void testUniqueLabels() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildBasic(cmds);
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return AddCommand.create((EditingDomain)this.getDomain(), (Object)this.model, (Object)MetaABMPackage.Literals.SATTRIBUTED__ATTRIBUTES, (Object)MetaABMFactory.eINSTANCE.createSAttribute());
            }

            public void preCondition() {
                CommandTest.assertEquals((int)this.model.getAttributes().size(), (int)2);
            }

            public void postCondition() {
                CommandTest.assertEquals((int)this.model.getAttributes().size(), (int)3);
                CommandTest.assertEquals((String)((SAttribute)this.model.getAttributes().get(2)).getLabel(), (String)"Attribute");
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return AddCommand.create((EditingDomain)this.getDomain(), (Object)this.model, (Object)MetaABMPackage.Literals.SATTRIBUTED__ATTRIBUTES, (Object)MetaABMFactory.eINSTANCE.createSAttribute());
            }

            public void preCondition() {
                CommandTest.assertEquals((int)this.model.getAttributes().size(), (int)3);
            }

            public void postCondition() {
                CommandTest.assertEquals((int)this.model.getAttributes().size(), (int)4);
                CommandTest.assertEquals((String)((SAttribute)this.model.getAttributes().get(3)).getLabel(), (String)"Attribute Copy");
            }
        });
        cmds.add(new SetLabel("Attribute", "An Attribute"){

            public void postCondition() {
                super.postCondition();
                ModelIDsCommandTest.assertEquals((String)((SAttribute)this.model.getAttributes().get(2)).getLabel(), (String)"An Attribute");
                ModelIDsCommandTest.assertEquals((String)((SAttribute)this.model.getAttributes().get(3)).getLabel(), (String)"Attribute Copy");
            }

            public IID getIID() {
                return (IID)this.model.getAttributes().get(2);
            }
        });
        cmds.add(new SetLabel("Attribute Copy", "Another Attribute"){

            @Override
            public void addPrePost(List<PrePostCondition> list) {
            }

            @Override
            public void postCondition() {
                super.postCondition();
                ModelIDsCommandTest.assertEquals((String)((SAttribute)this.model.getAttributes().get(2)).getLabel(), (String)"An Attribute");
                ModelIDsCommandTest.assertEquals((String)((SAttribute)this.model.getAttributes().get(3)).getLabel(), (String)"Another Attribute");
            }

            @Override
            public IID getIID() {
                return (IID)this.model.getAttributes().get(3);
            }
        });
        cmds.add(new SetLabel("An Attribute", "Another Attribute"){

            @Override
            public void addPrePost(List<PrePostCondition> list) {
            }

            @Override
            public void postCondition() {
                ModelIDsCommandTest.assertEquals((String)((SAttribute)this.model.getAttributes().get(2)).getLabel(), (String)"Another Attribute Copy");
                ModelIDsCommandTest.assertEquals((String)((SAttribute)this.model.getAttributes().get(3)).getLabel(), (String)"Another Attribute");
            }

            @Override
            public IID getIID() {
                return (IID)this.model.getAttributes().get(2);
            }
        });
        cmds.add(new SetLabel("Another Attribute", "Another Attribute Copy"){

            @Override
            public void addPrePost(List<PrePostCondition> list) {
            }

            @Override
            public void postCondition() {
                ModelIDsCommandTest.assertEquals((String)((SAttribute)this.model.getAttributes().get(2)).getLabel(), (String)"Another Attribute Copy");
                ModelIDsCommandTest.assertEquals((String)((SAttribute)this.model.getAttributes().get(3)).getLabel(), (String)"Another Attribute Copy Copy");
            }

            @Override
            public IID getIID() {
                return (IID)this.model.getAttributes().get(3);
            }
        });
        this.executeTests(cmds);
    }

    public void testStyleAndNames() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildBasic(cmds);
        cmds.add(new AddStyle2D());
        cmds.add(new SetStyleAgent());
        cmds.add(new SetLabel("Root Context Agent", "Test Agent"){

            public IID getIID() {
                return (IID)this.model.getAgents().get(0);
            }

            public void postCondition() {
                ModelIDsCommandTest.assertEquals((String)((SStyle)((SAgent)this.model.getAgents().get(0)).getStyles().get(0)).getLabel(), (String)"Test Agent Style 2D");
            }
        });
        cmds.add(new SetLabel("Test Agent Style 2D", "My Style"){

            public IID getIID() {
                return (IID)((SAgent)this.model.getAgents().get(0)).getStyles().get(0);
            }
        });
        cmds.add(new SetLabel("Test Agent", "Test Agent 2"){

            public IID getIID() {
                return (IID)this.model.getAgents().get(0);
            }

            public void postCondition() {
                ModelIDsCommandTest.assertEquals((String)((SStyle)((SAgent)this.model.getAgents().get(0)).getStyles().get(0)).getLabel(), (String)"My Style");
            }
        });
        cmds.add(new SetLabel("My Style", "Test Agent 2 Style 2D Copy"){

            public IID getIID() {
                return (IID)((SAgent)this.model.getAgents().get(0)).getStyles().get(0);
            }
        });
        cmds.add(new SetLabel("Test Agent 2", "Test Agent 3"){

            public IID getIID() {
                return (IID)this.model.getAgents().get(0);
            }

            public void postCondition() {
                ModelIDsCommandTest.assertEquals((String)((SStyle)((SAgent)this.model.getAgents().get(0)).getStyles().get(0)).getLabel(), (String)"Test Agent 3 Style 2D");
            }
        });
        this.executeTests(cmds);
    }
}

