/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl.graphics;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.eclipse.draw3d.graphics.optimizer.PrimitiveSet;
import org.eclipse.draw3d.graphics.optimizer.classification.PrimitiveClass;
import org.eclipse.draw3d.graphics.optimizer.primitive.GradientRenderRule;
import org.eclipse.draw3d.graphics.optimizer.primitive.Primitive;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.draw3d.graphics3d.ILodHelper;
import org.eclipse.draw3d.graphics3d.lwjgl.graphics.LwjglVBO;
import org.eclipse.draw3d.graphics3d.lwjgl.graphics.LwjglVertexPrimitiveVBO;
import org.eclipse.draw3d.util.ColorConverter;
import org.eclipse.swt.graphics.Color;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class LwjglGradientQuadVBO
extends LwjglVertexPrimitiveVBO {
    public LwjglGradientQuadVBO(PrimitiveSet i_primitives) {
        super(i_primitives);
        PrimitiveClass primitiveClass = i_primitives.getPrimitiveClass();
        if (!primitiveClass.isGradient() || !primitiveClass.isQuad()) {
            throw new IllegalArgumentException(i_primitives + " does not contain gradient quads");
        }
    }

    protected void cleanup(Graphics3D i_g3d, ILodHelper i_lodContext) {
        super.cleanup(i_g3d, i_lodContext);
        GL11.glPopAttrib();
    }

    protected void doRender(Graphics3D i_g3d, ILodHelper i_lodContext) {
        GL11.glDrawArrays((int)7, (int)0, (int)this.getVertexCount());
    }

    protected Buffer getBuffer(LwjglVBO.BufferType i_type) {
        if (i_type == LwjglVBO.BufferType.COLOR) {
            ByteBuffer colorBuffer = BufferUtils.createByteBuffer((int)(this.getVertexCount() * 4));
            byte[] c = new byte[4];
            for (Primitive primitive : this.getPrimitives().getPrimitives()) {
                GradientRenderRule renderRule = primitive.getRenderRule().asGradient();
                Color fromColor = renderRule.getFromColor();
                Color toColor = renderRule.getToColor();
                int alpha = renderRule.getAlpha();
                ColorConverter.toByteArray((Color)fromColor, (int)alpha, (byte[])c);
                colorBuffer.put(c);
                colorBuffer.put(c);
                ColorConverter.toByteArray((Color)toColor, (int)alpha, (byte[])c);
                colorBuffer.put(c);
                colorBuffer.put(c);
            }
            return colorBuffer;
        }
        return super.getBuffer(i_type);
    }

    protected LwjglVBO.BufferInfo getBufferInfo(LwjglVBO.BufferType i_type) {
        if (i_type == LwjglVBO.BufferType.COLOR) {
            return new LwjglVBO.BufferInfo(5121, 35041, 4, 0, 0);
        }
        return super.getBufferInfo(i_type);
    }

    protected boolean hasBuffer(LwjglVBO.BufferType i_type) {
        if (i_type == LwjglVBO.BufferType.COLOR) {
            return true;
        }
        return super.hasBuffer(i_type);
    }

    protected void prepare(Graphics3D i_g3d, ILodHelper i_lodContext) {
        GL11.glPushAttrib((int)64);
        GL11.glShadeModel((int)7425);
        super.prepare(i_g3d, i_lodContext);
    }
}

