/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf3d;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.amp.agf3d.RenderShape;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.RenderContext;
import org.eclipse.draw3d.shapes.CuboidShape;
import org.eclipse.draw3d.shapes.CylinderShape;
import org.eclipse.draw3d.shapes.PositionableShape;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.graphics.Color;

public class CompositeRenderShape
extends RenderShape {
    private List<PositionableShape> shapes = new ArrayList<PositionableShape>();
    IColorProvider colorProvider;

    public CompositeRenderShape(IFigure3D figure, Object object, IColorProvider colorProvider) {
        super(figure, null, object);
        this.colorProvider = colorProvider;
    }

    public void addShape(PositionableShape shape) {
        this.shapes.add(shape);
    }

    @Override
    protected void doRender(RenderContext context) {
        Color colorForAll = null;
        colorForAll = this.colorProvider != null ? this.colorProvider.getBackground(this.getModel()) : this.figure.getBackgroundColor();
        for (PositionableShape shape : this.shapes) {
            if (shape instanceof CylinderShape) {
                ((CylinderShape)shape).setFillColor(colorForAll);
            } else if (shape instanceof CuboidShape) {
                ((CuboidShape)shape).setFillColor(colorForAll);
            }
            shape.render(context);
        }
    }

    public List<PositionableShape> getShapes() {
        return this.shapes;
    }
}

