/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometry;

import org.eclipse.draw3d.geometry.IMatrix2f;
import org.eclipse.draw3d.geometry.IMatrix4f;
import org.eclipse.draw3d.geometry.Math3DMatrix3f;
import org.eclipse.draw3d.geometry.Matrix2f;
import org.eclipse.draw3d.geometry.Matrix2fImpl;
import org.eclipse.draw3d.geometry.Matrix4f;
import org.eclipse.draw3d.geometry.Matrix4fImpl;

public class Math3DMatrix4f
extends Math3DMatrix3f {
    public static Matrix4f add(IMatrix4f i_left, IMatrix4f i_right, Matrix4f o_result) {
        Matrix4fImpl result;
        Matrix4fImpl left = Matrix4fImpl.cast(i_left);
        Matrix4fImpl right = Matrix4fImpl.cast(i_right);
        if (o_result == null) {
            result = new Matrix4fImpl();
            o_result = result;
        } else {
            result = Matrix4fImpl.cast(o_result);
        }
        result.a11 = left.a11 + right.a11;
        result.a12 = left.a12 + right.a12;
        result.a13 = left.a13 + right.a13;
        result.a14 = left.a14 + right.a14;
        result.a21 = left.a21 + right.a21;
        result.a22 = left.a22 + right.a22;
        result.a23 = left.a23 + right.a23;
        result.a24 = left.a24 + right.a24;
        result.a31 = left.a31 + right.a31;
        result.a32 = left.a32 + right.a32;
        result.a33 = left.a33 + right.a33;
        result.a34 = left.a34 + right.a34;
        result.a41 = left.a41 + right.a41;
        result.a42 = left.a42 + right.a42;
        result.a43 = left.a43 + right.a43;
        result.a44 = left.a44 + right.a44;
        if (o_result != result) {
            o_result.set(result);
        }
        return o_result;
    }

    public static Matrix4f sub(IMatrix4f i_left, IMatrix4f i_right, Matrix4f o_result) {
        Matrix4fImpl result;
        Matrix4fImpl left = Matrix4fImpl.cast(i_left);
        Matrix4fImpl right = Matrix4fImpl.cast(i_right);
        if (o_result == null) {
            result = new Matrix4fImpl();
            o_result = result;
        } else {
            result = Matrix4fImpl.cast(o_result);
        }
        result.a11 = left.a11 - right.a11;
        result.a12 = left.a12 - right.a12;
        result.a13 = left.a13 - right.a13;
        result.a14 = left.a14 - right.a14;
        result.a21 = left.a21 - right.a21;
        result.a22 = left.a22 - right.a22;
        result.a23 = left.a23 - right.a23;
        result.a24 = left.a24 - right.a24;
        result.a31 = left.a31 - right.a31;
        result.a32 = left.a32 - right.a32;
        result.a33 = left.a33 - right.a33;
        result.a34 = left.a34 - right.a34;
        result.a41 = left.a41 - right.a41;
        result.a42 = left.a42 - right.a42;
        result.a43 = left.a43 - right.a43;
        result.a44 = left.a44 - right.a44;
        if (o_result != result) {
            o_result.set(result);
        }
        return o_result;
    }

    public static Matrix4f mul(IMatrix4f i_left, IMatrix4f i_right, Matrix4f o_result) {
        Matrix4fImpl result;
        Matrix4fImpl left = Matrix4fImpl.cast(i_left);
        Matrix4fImpl right = Matrix4fImpl.cast(i_right);
        if (o_result == null || o_result == left || o_result == right) {
            result = new Matrix4fImpl();
            if (o_result == null) {
                o_result = result;
            }
        } else {
            result = Matrix4fImpl.cast(o_result);
        }
        result.a11 = left.a11 * right.a11 + left.a21 * right.a12 + left.a31 * right.a13 + left.a41 * right.a14;
        result.a12 = left.a12 * right.a11 + left.a22 * right.a12 + left.a32 * right.a13 + left.a42 * right.a14;
        result.a13 = left.a13 * right.a11 + left.a23 * right.a12 + left.a33 * right.a13 + left.a43 * right.a14;
        result.a14 = left.a14 * right.a11 + left.a24 * right.a12 + left.a34 * right.a13 + left.a44 * right.a14;
        result.a21 = left.a11 * right.a21 + left.a21 * right.a22 + left.a31 * right.a23 + left.a41 * right.a24;
        result.a22 = left.a12 * right.a21 + left.a22 * right.a22 + left.a32 * right.a23 + left.a42 * right.a24;
        result.a23 = left.a13 * right.a21 + left.a23 * right.a22 + left.a33 * right.a23 + left.a43 * right.a24;
        result.a24 = left.a14 * right.a21 + left.a24 * right.a22 + left.a34 * right.a23 + left.a44 * right.a24;
        result.a31 = left.a11 * right.a31 + left.a21 * right.a32 + left.a31 * right.a33 + left.a41 * right.a34;
        result.a32 = left.a12 * right.a31 + left.a22 * right.a32 + left.a32 * right.a33 + left.a42 * right.a34;
        result.a33 = left.a13 * right.a31 + left.a23 * right.a32 + left.a33 * right.a33 + left.a43 * right.a34;
        result.a34 = left.a14 * right.a31 + left.a24 * right.a32 + left.a34 * right.a33 + left.a44 * right.a34;
        result.a41 = left.a11 * right.a41 + left.a21 * right.a42 + left.a31 * right.a43 + left.a41 * right.a44;
        result.a42 = left.a12 * right.a41 + left.a22 * right.a42 + left.a32 * right.a43 + left.a42 * right.a44;
        result.a43 = left.a13 * right.a41 + left.a23 * right.a42 + left.a33 * right.a43 + left.a43 * right.a44;
        result.a44 = left.a14 * right.a41 + left.a24 * right.a42 + left.a34 * right.a43 + left.a44 * right.a44;
        if (o_result != result) {
            o_result.set(result);
        }
        return o_result;
    }

    public static Matrix4f mul(float f, IMatrix4f i_source, Matrix4f o_result) {
        Matrix4fImpl result;
        Matrix4fImpl m = Matrix4fImpl.cast(i_source);
        if (o_result == null) {
            result = new Matrix4fImpl(m);
            o_result = result;
        } else {
            result = Matrix4fImpl.cast(o_result);
            result.set(m);
        }
        result.a11 *= f;
        result.a12 *= f;
        result.a13 *= f;
        result.a14 *= f;
        result.a21 *= f;
        result.a22 *= f;
        result.a23 *= f;
        result.a24 *= f;
        result.a31 *= f;
        result.a32 *= f;
        result.a33 *= f;
        result.a34 *= f;
        result.a41 *= f;
        result.a42 *= f;
        result.a43 *= f;
        result.a44 *= f;
        if (o_result != result) {
            o_result.set(result);
        }
        return o_result;
    }

    public static float determinant(IMatrix4f i_a) {
        Matrix4fImpl m = Matrix4fImpl.cast(i_a);
        float d12 = m.a31 * m.a42 - m.a32 * m.a41;
        float d13 = m.a31 * m.a43 - m.a33 * m.a41;
        float d14 = m.a31 * m.a44 - m.a34 * m.a41;
        float d23 = m.a32 * m.a43 - m.a33 * m.a42;
        float d24 = m.a32 * m.a44 - m.a34 * m.a42;
        float d34 = m.a33 * m.a44 - m.a34 * m.a43;
        return m.a11 * (m.a22 * d34 - m.a23 * d24 + m.a24 * d23) - m.a12 * (m.a21 * d34 - m.a23 * d14 + m.a24 * d13) + m.a13 * (m.a21 * d24 - m.a22 * d14 + m.a24 * d12) - m.a14 * (m.a21 * d23 - m.a22 * d13 + m.a23 * d12);
    }

    public static Matrix4f invert(IMatrix4f i_source, Matrix4f o_result) {
        Matrix4fImpl result;
        float detSource = Math3DMatrix4f.determinant(i_source);
        if (detSource == 0.0f) {
            return null;
        }
        Matrix4fImpl m = Matrix4fImpl.cast(i_source);
        if (o_result == null) {
            result = new Matrix4fImpl();
            o_result = result;
        } else {
            result = Matrix4fImpl.cast(o_result);
        }
        Matrix2fImpl A = new Matrix2fImpl(m.a11, m.a12, m.a21, m.a22, false);
        Matrix2fImpl B = new Matrix2fImpl(m.a13, m.a14, m.a23, m.a24, false);
        Matrix2fImpl C = new Matrix2fImpl(m.a31, m.a32, m.a41, m.a42, false);
        Matrix2fImpl D = new Matrix2fImpl(m.a33, m.a34, m.a43, m.a44, false);
        Matrix2fImpl Ainv = new Matrix2fImpl();
        Math3DMatrix4f.invert(A, Ainv);
        Matrix2fImpl C_Ainv = new Matrix2fImpl();
        Math3DMatrix4f.mul(C, (IMatrix2f)Ainv, (Matrix2f)C_Ainv);
        Matrix2fImpl SchurInv = new Matrix2fImpl();
        Math3DMatrix4f.mul(C_Ainv, (IMatrix2f)B, (Matrix2f)SchurInv);
        Math3DMatrix4f.sub(D, SchurInv, SchurInv);
        Math3DMatrix4f.invert(SchurInv, SchurInv);
        Matrix2fImpl Ainv_B = new Matrix2fImpl();
        Math3DMatrix4f.mul(Ainv, (IMatrix2f)B, (Matrix2f)Ainv_B);
        Math3DMatrix4f.mul(Ainv_B, (IMatrix2f)SchurInv, (Matrix2f)A);
        Math3DMatrix4f.negate(A, B);
        Math3DMatrix4f.mul(A, (IMatrix2f)C_Ainv, (Matrix2f)A);
        Math3DMatrix4f.add(Ainv, A, A);
        Math3DMatrix4f.mul(SchurInv, (IMatrix2f)C_Ainv, (Matrix2f)C);
        Math3DMatrix4f.negate(C, C);
        D = SchurInv;
        result.a11 = A.a11;
        result.a12 = A.a12;
        result.a21 = A.a21;
        result.a22 = A.a22;
        result.a13 = B.a11;
        result.a14 = B.a12;
        result.a23 = B.a21;
        result.a24 = B.a22;
        result.a31 = C.a11;
        result.a32 = C.a12;
        result.a41 = C.a21;
        result.a42 = C.a22;
        result.a33 = D.a11;
        result.a34 = D.a12;
        result.a43 = D.a21;
        result.a44 = D.a22;
        if (o_result != result) {
            o_result.set(result);
        }
        return o_result;
    }

    public static Matrix4f negate(IMatrix4f i_source, Matrix4f o_result) {
        Matrix4fImpl m = Matrix4fImpl.cast(i_source);
        Matrix4fImpl result = o_result == null ? new Matrix4fImpl() : Matrix4fImpl.cast(o_result);
        result.a11 = -m.a11;
        result.a12 = -m.a12;
        result.a13 = -m.a13;
        result.a14 = -m.a14;
        result.a21 = -m.a21;
        result.a22 = -m.a22;
        result.a23 = -m.a23;
        result.a24 = -m.a24;
        result.a31 = -m.a31;
        result.a32 = -m.a32;
        result.a33 = -m.a33;
        result.a34 = -m.a34;
        result.a41 = -m.a41;
        result.a42 = -m.a42;
        result.a43 = -m.a43;
        result.a44 = -m.a44;
        if (o_result != result && o_result != null) {
            o_result.set(result);
        }
        return result;
    }

    public static Matrix4f transpose(IMatrix4f i_source, Matrix4f o_result) {
        Matrix4fImpl result;
        Matrix4fImpl m = Matrix4fImpl.cast(i_source);
        if (o_result == null) {
            result = new Matrix4fImpl();
            o_result = result;
        } else {
            result = Matrix4fImpl.cast(o_result);
        }
        if (result == m) {
            float t = result.a12;
            result.a12 = m.a21;
            result.a21 = t;
            t = result.a13;
            result.a13 = m.a31;
            result.a31 = t;
            t = result.a14;
            result.a14 = m.a41;
            result.a41 = t;
            t = result.a23;
            result.a23 = m.a32;
            result.a32 = t;
            t = result.a24;
            result.a24 = m.a42;
            result.a42 = t;
            t = result.a34;
            result.a34 = m.a43;
            result.a43 = t;
        } else {
            result.a11 = m.a11;
            result.a22 = m.a22;
            result.a33 = m.a33;
            result.a44 = m.a44;
            result.a12 = m.a21;
            result.a21 = m.a12;
            result.a13 = m.a31;
            result.a31 = m.a13;
            result.a14 = m.a41;
            result.a41 = m.a14;
            result.a23 = m.a32;
            result.a32 = m.a23;
            result.a24 = m.a42;
            result.a42 = m.a24;
            result.a34 = m.a43;
            result.a43 = m.a34;
        }
        if (o_result != result) {
            o_result.set(result);
        }
        return o_result;
    }
}

