/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3d.ui.parts;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Logger;
import org.eclipse.draw3d.ISceneListener;
import org.eclipse.draw3d.RenderContext;
import org.eclipse.draw3d.camera.ICamera;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class FpsStatusLineItem
extends ContributionItem
implements ISceneListener {
    private static final int CHAR_WIDTH = 8;
    private static final int INDENT = 3;
    private static final Logger log = Logger.getLogger(FpsStatusLineItem.class.getName());
    private static final int NUM_FRAMES = 20;
    private static final long TIMEOUT = 50L;
    private int m_fixedHeight = -1;
    private int m_fixedWidth = -1;
    private LinkedList<Long> m_frames = new LinkedList();
    private CLabel m_label;
    private long m_lastFrame = -1L;

    public void cameraChanged(ICamera i_oldCamera, ICamera i_newCamera) {
    }

    public void fill(Composite i_parent) {
        Label sep = new Label(i_parent, 2);
        this.m_label = new CLabel(i_parent, 32);
        StatusLineLayoutData data = new StatusLineLayoutData();
        data.widthHint = this.getWidthHint(i_parent);
        this.m_label.setLayoutData((Object)data);
        data = new StatusLineLayoutData();
        data.heightHint = this.getHeightHint(i_parent);
        sep.setLayoutData((Object)data);
        this.updateCounter();
    }

    private int getHeightHint(Composite control) {
        if (this.m_fixedHeight < 0) {
            GC gc = new GC((Drawable)control);
            gc.setFont(control.getFont());
            this.m_fixedHeight = gc.getFontMetrics().getHeight();
            gc.dispose();
        }
        return this.m_fixedHeight;
    }

    private int getWidthHint(Composite control) {
        if (this.m_fixedWidth < 0) {
            GC gc = new GC((Drawable)control);
            gc.setFont(control.getFont());
            this.m_fixedWidth = gc.getFontMetrics().getAverageCharWidth() * 8;
            this.m_fixedWidth += 6;
            gc.dispose();
        }
        return this.m_fixedWidth;
    }

    public void renderPassFinished(RenderContext renderContext) {
        long time = System.currentTimeMillis();
        if (this.m_lastFrame == -1L) {
            this.m_lastFrame = time;
            return;
        }
        long frameTime = time - this.m_lastFrame;
        this.m_lastFrame = time;
        if (frameTime <= 50L) {
            if (this.m_frames.size() == 20) {
                this.m_frames.removeLast();
            }
            this.m_frames.addFirst(frameTime);
        }
        this.updateCounter();
    }

    public void renderPassStarted(RenderContext renderContext) {
    }

    private void updateCounter() {
        long fps = 0L;
        if (this.m_frames.size() > 0) {
            double avg = 0.0;
            Iterator iterator = this.m_frames.iterator();
            while (iterator.hasNext()) {
                long frameTime = (Long)iterator.next();
                avg += (double)frameTime;
            }
            fps = (long)(1000.0 / (avg /= (double)this.m_frames.size()));
        }
        if (this.m_label != null && !this.m_label.isDisposed()) {
            this.m_label.setText(String.valueOf(fps) + " FPS");
        }
    }
}

