/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.util;

import com.ibm.icu.math.MathContext;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.model.data.BigNumberDataElement;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.util.BigNumber;

public class NumberUtil {
    public static final com.ibm.icu.math.BigDecimal DEFAULT_DIVISOR = new com.ibm.icu.math.BigDecimal("1E304");
    public static final com.ibm.icu.math.BigDecimal DEFAULT_MULTIPLIER;
    public static final com.ibm.icu.math.BigDecimal DOUBLE_MIN;
    public static final com.ibm.icu.math.BigDecimal DOUBLE_MAX;
    public static final MathContext DEFAULT_MATHCONTEXT;
    public static final String BIG_DECIMAL_FORMAT_SUFFIX = "E0";

    static {
        DOUBLE_MIN = DEFAULT_MULTIPLIER = new com.ibm.icu.math.BigDecimal("1E-300");
        DOUBLE_MAX = DEFAULT_DIVISOR;
        DEFAULT_MATHCONTEXT = MathContext.DEFAULT;
    }

    public static DecimalFormat getDefaultBigDecimalFormat(ULocale locale) {
        return new DecimalFormat("0.##E0", new DecimalFormatSymbols(locale));
    }

    public static boolean isBigNumber(Object value) {
        return value instanceof BigNumber;
    }

    public static boolean isBigDecimal(Object value) {
        return value instanceof com.ibm.icu.math.BigDecimal || value instanceof BigDecimal;
    }

    public static boolean isIBMBigDecimal(Object value) {
        return value instanceof com.ibm.icu.math.BigDecimal;
    }

    public static boolean isJavaMathBigDecimal(Object value) {
        return value instanceof BigDecimal;
    }

    public static int compareNumber(Number na, Number nb) {
        if (na == null && nb == null) {
            return 0;
        }
        if (na == null) {
            return -1;
        }
        if (nb == null) {
            return 1;
        }
        if (na instanceof Comparable && nb instanceof Comparable) {
            return ((Comparable)((Object)na)).compareTo(nb);
        }
        return Double.valueOf(na.doubleValue()).compareTo(nb.doubleValue());
    }

    public static Number transformNumber(Object n) {
        if (n == null) {
            return null;
        }
        if (n instanceof Double) {
            return (Double)n;
        }
        if (n instanceof com.ibm.icu.math.BigDecimal) {
            return (com.ibm.icu.math.BigDecimal)n;
        }
        if (n instanceof BigDecimal) {
            return new com.ibm.icu.math.BigDecimal(((BigDecimal)n).toString());
        }
        if (n instanceof BigInteger) {
            return new com.ibm.icu.math.BigDecimal((BigInteger)n);
        }
        return Methods.asDouble(n);
    }

    public static Number convertNumber(Object n) {
        if (n == null) {
            return null;
        }
        if (n instanceof Double) {
            return (Double)n;
        }
        if (n instanceof com.ibm.icu.math.BigDecimal) {
            return (com.ibm.icu.math.BigDecimal)n;
        }
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        if (n instanceof BigInteger) {
            return new com.ibm.icu.math.BigDecimal((BigInteger)n);
        }
        if (n instanceof NumberDataElement) {
            return ((NumberDataElement)n).getValue();
        }
        if (n instanceof BigNumberDataElement) {
            return ((BigNumberDataElement)n).getValue();
        }
        return Methods.asDouble(n);
    }

    public static com.ibm.icu.math.BigDecimal asBigDecimal(Number n) {
        if (n == null) {
            return null;
        }
        if (n instanceof BigNumber) {
            return ((BigNumber)n).getValue();
        }
        if (n instanceof com.ibm.icu.math.BigDecimal) {
            return (com.ibm.icu.math.BigDecimal)n;
        }
        if (n instanceof BigDecimal) {
            return new com.ibm.icu.math.BigDecimal(((BigDecimal)n).toString());
        }
        if (n instanceof BigInteger) {
            return new com.ibm.icu.math.BigDecimal(n.toString());
        }
        return com.ibm.icu.math.BigDecimal.valueOf((double)n.doubleValue());
    }

    public static BigDecimal asJavaMathBigDecimal(Number n) {
        if (n == null) {
            return null;
        }
        if (n instanceof BigNumber) {
            return new BigDecimal(((BigNumber)n).getValue().toString());
        }
        if (n instanceof com.ibm.icu.math.BigDecimal) {
            return new BigDecimal(n.toString());
        }
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        if (n instanceof BigInteger) {
            return new BigDecimal(n.toString());
        }
        return BigDecimal.valueOf(n.doubleValue());
    }

    public static Double asDouble(Number n) {
        if (n == null) {
            return null;
        }
        if (n instanceof Double) {
            return (Double)n;
        }
        if (n instanceof BigNumber) {
            return new Double(((BigNumber)n).getValue().doubleValue());
        }
        return new Double(n.doubleValue());
    }

    public static BigNumber asBigNumber(Number n, com.ibm.icu.math.BigDecimal divisor) {
        if (n == null) {
            return null;
        }
        if (n instanceof Double) {
            if (((Double)n).isNaN()) {
                return new BigNumber(com.ibm.icu.math.BigDecimal.ZERO, divisor);
            }
            return new BigNumber(com.ibm.icu.math.BigDecimal.valueOf((double)((Double)n)), divisor);
        }
        if (n instanceof com.ibm.icu.math.BigDecimal) {
            return new BigNumber((com.ibm.icu.math.BigDecimal)n, divisor);
        }
        if (n instanceof BigDecimal) {
            return new BigNumber(NumberUtil.asBigDecimal(n), divisor);
        }
        if (n instanceof BigNumber) {
            ((BigNumber)n).setDivisor(divisor);
            return (BigNumber)n;
        }
        return new BigNumber(com.ibm.icu.math.BigDecimal.valueOf((double)n.doubleValue()), divisor);
    }

    public static String adjustBigNumberFormatPattern(String pattern) {
        if (pattern == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        char[] cArray = pattern.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char a = cArray[n2];
            switch (a) {
                case '#': 
                case '.': 
                case '0': 
                case 'E': {
                    sb.append(a);
                }
            }
            ++n2;
        }
        return sb.toString();
    }
}

