/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.Vector;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.ExternalizedTextEditorComposite;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.FontDefinitionComposite;
import org.eclipse.birt.chart.ui.swt.composites.InsetsComposite;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class LabelAttributesComposite
extends Composite
implements SelectionListener,
Listener {
    private transient Composite cmpGeneral = null;
    private transient Composite grpAttributes = null;
    private transient Group grpOutline = null;
    private transient Button cbVisible = null;
    private transient org.eclipse.swt.widgets.Label lblLabel = null;
    private transient org.eclipse.swt.widgets.Label lblPosition = null;
    private transient org.eclipse.swt.widgets.Label lblFill = null;
    private transient org.eclipse.swt.widgets.Label lblShadow = null;
    private transient org.eclipse.swt.widgets.Label lblFont = null;
    private transient Combo cmbPosition = null;
    private transient FontDefinitionComposite fdcFont = null;
    private transient FillChooserComposite fccBackground = null;
    private transient FillChooserComposite fccShadow = null;
    private transient InsetsComposite icInsets = null;
    private transient String sGroupName = Messages.getString("LabelAttributesComposite.Lbl.Label");
    private transient Position lpCurrent = null;
    private transient Fill fBackground = null;
    private transient ColorDefinition cdShadow = null;
    private transient FontDefinition fdCurrent = null;
    private transient ColorDefinition cdFont = null;
    private transient LineAttributes laCurrent = null;
    private transient Label lblCurrent = null;
    private transient Insets insets = null;
    private transient String sUnits = null;
    private transient LineAttributesComposite liacOutline = null;
    private transient ExternalizedTextEditorComposite txtLabel = null;
    private transient Vector vListeners = null;
    public static final int VISIBILITY_CHANGED_EVENT = 1;
    public static final int POSITION_CHANGED_EVENT = 2;
    public static final int FONT_CHANGED_EVENT = 3;
    public static final int BACKGROUND_CHANGED_EVENT = 4;
    public static final int SHADOW_CHANGED_EVENT = 5;
    public static final int OUTLINE_STYLE_CHANGED_EVENT = 6;
    public static final int OUTLINE_WIDTH_CHANGED_EVENT = 7;
    public static final int OUTLINE_COLOR_CHANGED_EVENT = 8;
    public static final int OUTLINE_VISIBILITY_CHANGED_EVENT = 9;
    public static final int INSETS_CHANGED_EVENT = 10;
    public static final int LABEL_CHANGED_EVENT = 11;
    public static final int ALLOW_ALL_POSITION = 63;
    public static final int ALLOW_VERTICAL_POSITION = 3;
    public static final int ALLOW_HORIZONTAL_POSITION = 12;
    public static final int ALLOW_INOUT_POSITION = 48;
    private transient boolean bEnabled = true;
    private int positionScope = 0;
    private transient ChartWizardContext wizardContext;
    private transient LabelAttributesContext attributesContext;

    public LabelAttributesComposite(Composite parent, int style, ChartWizardContext wizardContext, LabelAttributesContext attributesContext, String sGroupName, Position lpCurrent, Label lblCurrent, String sUnits) {
        this(parent, style, wizardContext, attributesContext, sGroupName, lpCurrent, lblCurrent, sUnits, 63);
    }

    public LabelAttributesComposite(Composite parent, int style, ChartWizardContext wizardContext, LabelAttributesContext attributesContext, String sGroupName, Position lpCurrent, Label lblCurrent, String sUnits, int positionScope) {
        super(parent, style);
        this.wizardContext = wizardContext;
        this.attributesContext = attributesContext;
        this.sGroupName = sGroupName;
        this.lpCurrent = lpCurrent;
        this.lblCurrent = lblCurrent;
        this.sUnits = sUnits;
        this.fdCurrent = lblCurrent.getCaption().getFont();
        this.cdFont = lblCurrent.getCaption().getColor();
        this.fBackground = lblCurrent.getBackground();
        this.cdShadow = lblCurrent.getShadowColor();
        this.laCurrent = lblCurrent.getOutline();
        this.insets = lblCurrent.getInsets();
        this.positionScope = positionScope;
        this.init();
        this.placeComponents();
    }

    public LabelAttributesComposite(Composite parent, int style, String sGroupName, Position lpCurrent, Label lblCurrent, String sUnits, boolean bPositionEnabled, boolean bVisibilityEnabled, ChartWizardContext wizardContext, boolean isAlignmentEnabled) {
        this(parent, style, sGroupName, lpCurrent, lblCurrent, sUnits, bPositionEnabled, bVisibilityEnabled, wizardContext, 63, isAlignmentEnabled);
    }

    public LabelAttributesComposite(Composite parent, int style, String sGroupName, Position lpCurrent, Label lblCurrent, String sUnits, boolean bPositionEnabled, boolean bVisibilityEnabled, ChartWizardContext wizardContext, int positionScope, boolean isAlignmentEnabled) {
        super(parent, style);
        this.sGroupName = sGroupName;
        this.lpCurrent = lpCurrent;
        this.lblCurrent = lblCurrent;
        this.sUnits = sUnits;
        this.fdCurrent = lblCurrent.getCaption().getFont();
        this.cdFont = lblCurrent.getCaption().getColor();
        this.fBackground = lblCurrent.getBackground();
        this.cdShadow = lblCurrent.getShadowColor();
        this.laCurrent = lblCurrent.getOutline();
        this.insets = lblCurrent.getInsets();
        this.wizardContext = wizardContext;
        this.positionScope = positionScope;
        this.attributesContext = new LabelAttributesContext();
        this.attributesContext.isPositionEnabled = bPositionEnabled;
        this.attributesContext.isVisibilityEnabled = bVisibilityEnabled;
        this.attributesContext.isFontAlignmentEnabled = isAlignmentEnabled;
        this.init();
        this.placeComponents();
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
        this.vListeners = new Vector();
    }

    private void placeComponents() {
        boolean bEnableUI;
        FillLayout flMain = new FillLayout();
        flMain.marginHeight = 0;
        flMain.marginWidth = 0;
        GridLayout glAttributes = new GridLayout();
        glAttributes.horizontalSpacing = 5;
        glAttributes.verticalSpacing = 5;
        glAttributes.marginHeight = 7;
        glAttributes.marginWidth = 7;
        GridLayout glGeneral = new GridLayout();
        glGeneral.numColumns = 2;
        glGeneral.horizontalSpacing = 5;
        glGeneral.verticalSpacing = 5;
        FillLayout flOutline = new FillLayout();
        this.setLayout((Layout)flMain);
        if (this.sGroupName == null || this.sGroupName.length() == 0) {
            this.grpAttributes = new Composite((Composite)this, 0);
        } else {
            this.grpAttributes = new Group((Composite)this, 0);
            ((Group)this.grpAttributes).setText(this.sGroupName);
        }
        this.grpAttributes.setLayout((Layout)glAttributes);
        this.cmpGeneral = new Composite(this.grpAttributes, 0);
        GridData gdCMPGeneral = new GridData(768);
        this.cmpGeneral.setLayoutData((Object)gdCMPGeneral);
        this.cmpGeneral.setLayout((Layout)glGeneral);
        boolean bl = bEnableUI = this.bEnabled && this.lblCurrent.isVisible();
        if (this.attributesContext.isVisibilityEnabled) {
            this.cbVisible = new Button(this.cmpGeneral, 32);
            GridData gdCBVisible = new GridData(768);
            gdCBVisible.horizontalSpan = 2;
            this.cbVisible.setLayoutData((Object)gdCBVisible);
            this.cbVisible.setSelection(this.lblCurrent.isVisible());
            this.cbVisible.setText(Messages.getString("LabelAttributesComposite.Lbl.IsVisible"));
            this.cbVisible.addSelectionListener((SelectionListener)this);
            if (this.bEnabled) {
                bEnableUI = this.cbVisible.getSelection();
            }
        }
        if (this.attributesContext.isLabelEnabled) {
            this.lblLabel = new org.eclipse.swt.widgets.Label(this.cmpGeneral, 0);
            GridData gd = new GridData();
            this.lblLabel.setLayoutData((Object)gd);
            this.lblLabel.setText(Messages.getString("AxisMarkersSheet.Label.Label"));
            this.txtLabel = new ExternalizedTextEditorComposite(this.cmpGeneral, 2052, -1, -1, this.wizardContext.getUIServiceProvider().getRegisteredKeys(), this.wizardContext.getUIServiceProvider(), "");
            gd = new GridData(1808);
            this.txtLabel.setLayoutData(gd);
            this.txtLabel.addListener(this);
        }
        if (this.attributesContext.isPositionEnabled) {
            this.lblPosition = new org.eclipse.swt.widgets.Label(this.cmpGeneral, 0);
            GridData gdLBLPosition = new GridData();
            this.lblPosition.setLayoutData((Object)gdLBLPosition);
            this.lblPosition.setText(Messages.getString("LabelAttributesComposite.Lbl.Position"));
            this.lblPosition.setEnabled(bEnableUI);
            this.cmbPosition = new Combo(this.cmpGeneral, 12);
            GridData gdCMBPosition = new GridData(1808);
            this.cmbPosition.setLayoutData((Object)gdCMBPosition);
            this.cmbPosition.addSelectionListener((SelectionListener)this);
            this.cmbPosition.setEnabled(bEnableUI);
        }
        if (this.attributesContext.isFontEnabled) {
            this.lblFont = new org.eclipse.swt.widgets.Label(this.cmpGeneral, 0);
            GridData gdLFont = new GridData();
            this.lblFont.setLayoutData((Object)gdLFont);
            this.lblFont.setText(Messages.getString("LabelAttributesComposite.Lbl.Font"));
            this.lblFont.setEnabled(bEnableUI);
            this.fdcFont = new FontDefinitionComposite(this.cmpGeneral, 0, this.wizardContext, this.fdCurrent, this.cdFont, this.attributesContext.isFontAlignmentEnabled);
            GridData gdFDCFont = new GridData(1808);
            gdFDCFont.widthHint = this.fdcFont.getPreferredSize().x;
            gdFDCFont.grabExcessVerticalSpace = false;
            this.fdcFont.setLayoutData(gdFDCFont);
            this.fdcFont.addListener(this);
            this.fdcFont.setEnabled(bEnableUI);
        }
        this.lblFill = new org.eclipse.swt.widgets.Label(this.cmpGeneral, 0);
        GridData gdLFill = new GridData();
        this.lblFill.setLayoutData((Object)gdLFill);
        this.lblFill.setText(Messages.getString("LabelAttributesComposite.Lbl.Background"));
        this.lblFill.setEnabled(bEnableUI);
        this.fccBackground = new FillChooserComposite(this.cmpGeneral, 0, this.wizardContext, this.fBackground, false, false, false);
        GridData gdFCCBackground = new GridData(1808);
        this.fccBackground.setLayoutData(gdFCCBackground);
        this.fccBackground.addListener(this);
        this.fccBackground.setEnabled(bEnableUI);
        if (this.attributesContext.isShadowEnabled) {
            this.lblShadow = new org.eclipse.swt.widgets.Label(this.cmpGeneral, 0);
            GridData gdLBLShadow = new GridData();
            this.lblShadow.setLayoutData((Object)gdLBLShadow);
            this.lblShadow.setText(Messages.getString("LabelAttributesComposite.Lbl.Shadow"));
            this.lblShadow.setEnabled(bEnableUI);
            int iFillOption = 152;
            this.fccShadow = new FillChooserComposite(this.cmpGeneral, 12, iFillOption, this.wizardContext, (Fill)this.cdShadow);
            GridData gdFCCShadow = new GridData(1808);
            this.fccShadow.setLayoutData(gdFCCShadow);
            this.fccShadow.addListener(this);
            this.fccShadow.setEnabled(bEnableUI);
        }
        this.grpOutline = new Group(this.grpAttributes, 0);
        GridData gdGOutline = new GridData(768);
        this.grpOutline.setLayoutData((Object)gdGOutline);
        this.grpOutline.setText(Messages.getString("LabelAttributesComposite.Lbl.Outline"));
        this.grpOutline.setLayout((Layout)flOutline);
        this.grpOutline.setEnabled(bEnableUI);
        this.liacOutline = new LineAttributesComposite((Composite)this.grpOutline, 0, this.wizardContext, this.laCurrent, true, true, true);
        this.liacOutline.addListener(this);
        this.liacOutline.setAttributesEnabled(bEnableUI);
        if (this.attributesContext.isInsetsEnabled) {
            this.icInsets = new InsetsComposite(this.grpAttributes, 0, this.insets, this.sUnits, this.wizardContext.getUIServiceProvider());
            GridData gdICInsets = new GridData(768);
            gdICInsets.grabExcessVerticalSpace = false;
            this.icInsets.addListener(this);
            this.icInsets.setLayoutData(gdICInsets);
            this.icInsets.setEnabled(bEnableUI);
        }
        this.populateLists();
    }

    public void setEnabled(boolean bState) {
        boolean bEnableUI = true;
        if (this.attributesContext.isVisibilityEnabled) {
            bEnableUI = this.cbVisible.getSelection();
            this.cbVisible.setEnabled(bState);
        }
        this.setVisibleState(bState & bEnableUI);
        this.grpAttributes.setEnabled(bState);
        this.bEnabled = bState;
    }

    public boolean isEnabled() {
        return this.bEnabled;
    }

    private void populateLists() {
        if (this.attributesContext.isPositionEnabled) {
            this.cmbPosition.setItems(ChartUIUtil.getPositionDisplayNames((int)this.positionScope, ((this.isAxisAttribute() || this.isSeriesAttribute()) && this.isFlippedAxes() ? 1 : 0) != 0));
            if (this.lpCurrent != null) {
                String positionName = ChartUIUtil.getFlippedPosition((Position)this.lpCurrent, ((this.isAxisAttribute() || this.isSeriesAttribute()) && this.isFlippedAxes() ? 1 : 0) != 0).getName();
                int i = 0;
                while (i < this.cmbPosition.getItemCount()) {
                    if (positionName.equals(LiteralHelper.fullPositionSet.getNameByDisplayName(this.cmbPosition.getItem(i)))) {
                        this.cmbPosition.select(i);
                    }
                    ++i;
                }
            }
        }
    }

    public void setLabel(Label lbl, String sUnits) {
        this.lblCurrent = lbl;
        this.sUnits = sUnits;
        this.fBackground = this.lblCurrent.getBackground();
        this.laCurrent = this.lblCurrent.getOutline();
        if (this.attributesContext.isVisibilityEnabled) {
            this.cbVisible.setSelection(this.lblCurrent.isVisible());
            this.setVisibleState(this.cbVisible.getSelection() && this.cbVisible.isEnabled());
        }
        if (this.attributesContext.isLabelEnabled) {
            this.txtLabel.setText(lbl.getCaption().getValue());
        }
        if (this.attributesContext.isInsetsEnabled) {
            this.insets = this.lblCurrent.getInsets();
            this.icInsets.setInsets(this.insets, this.sUnits);
        }
        if (this.attributesContext.isShadowEnabled) {
            this.cdShadow = this.lblCurrent.getShadowColor();
            this.fccShadow.setFill((Fill)this.cdShadow);
        }
        if (this.attributesContext.isFontEnabled) {
            this.fdCurrent = this.lblCurrent.getCaption().getFont();
            this.cdFont = this.lblCurrent.getCaption().getColor();
            this.fdcFont.setFontDefinition(this.fdCurrent);
            this.fdcFont.setFontColor(this.cdFont);
        }
        this.fccBackground.setFill(this.fBackground);
        this.liacOutline.setLineAttributes(this.laCurrent);
        this.redraw();
    }

    public void setLabelPosition(Position pos) {
        this.lpCurrent = pos;
        if (this.attributesContext.isPositionEnabled) {
            if (this.isAxisAttribute() || this.isSeriesAttribute()) {
                this.cmbPosition.setText(LiteralHelper.fullPositionSet.getDisplayNameByName(ChartUIUtil.getFlippedPosition((Position)this.lpCurrent, (boolean)this.isFlippedAxes()).getName()));
            } else {
                this.cmbPosition.setText(LiteralHelper.fullPositionSet.getDisplayNameByName(this.lpCurrent.getName()));
            }
        }
    }

    public void addListener(Listener listener) {
        this.vListeners.add(listener);
    }

    private void fireEvent(Event e) {
        int iL = 0;
        while (iL < this.vListeners.size()) {
            ((Listener)this.vListeners.get(iL)).handleEvent(e);
            ++iL;
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Event eLabel = new Event();
        eLabel.widget = this;
        if (e.getSource().equals(this.cmbPosition)) {
            eLabel.data = this.isAxisAttribute() || this.isSeriesAttribute() ? ChartUIUtil.getFlippedPosition((Position)Position.getByName((String)LiteralHelper.fullPositionSet.getNameByDisplayName(this.cmbPosition.getText())), (boolean)this.isFlippedAxes()) : Position.getByName((String)LiteralHelper.fullPositionSet.getNameByDisplayName(this.cmbPosition.getText()));
            eLabel.type = 2;
        } else if (e.getSource().equals(this.cbVisible)) {
            eLabel.data = this.cbVisible.getSelection();
            eLabel.type = 1;
            this.setVisibleState(this.cbVisible.getSelection());
        }
        this.fireEvent(eLabel);
    }

    private void setVisibleState(boolean isVisible) {
        if (this.attributesContext.isLabelEnabled) {
            this.lblLabel.setEnabled(isVisible);
            this.txtLabel.setEnabled(isVisible);
        }
        if (this.attributesContext.isPositionEnabled) {
            this.lblPosition.setEnabled(isVisible);
            this.cmbPosition.setEnabled(isVisible);
        }
        this.lblFill.setEnabled(isVisible);
        if (this.attributesContext.isFontEnabled) {
            this.lblFont.setEnabled(isVisible);
            this.fdcFont.setEnabled(isVisible);
        }
        this.fccBackground.setEnabled(isVisible);
        if (this.attributesContext.isShadowEnabled) {
            this.lblShadow.setEnabled(isVisible);
            this.fccShadow.setEnabled(isVisible);
        }
        if (this.attributesContext.isInsetsEnabled) {
            this.icInsets.setEnabled(isVisible);
        }
        this.grpOutline.setEnabled(isVisible);
        this.liacOutline.setAttributesEnabled(isVisible);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public Point getPreferredSize() {
        Point ptSize = new Point(300, 130);
        if (this.attributesContext.isVisibilityEnabled) {
            ptSize.y += 30;
        }
        if (this.attributesContext.isPositionEnabled) {
            ptSize.y += 30;
        }
        return ptSize;
    }

    public void handleEvent(Event event) {
        Event eLabel = new Event();
        eLabel.widget = this;
        if (event.widget.equals((Object)this.fdcFont)) {
            eLabel.type = 3;
        } else if (event.widget.equals((Object)this.liacOutline)) {
            switch (event.type) {
                case 1: {
                    eLabel.type = 6;
                    break;
                }
                case 2: {
                    eLabel.type = 7;
                    break;
                }
                case 3: {
                    eLabel.type = 8;
                    break;
                }
                case 4: {
                    eLabel.type = 9;
                }
            }
        } else if (event.widget.equals((Object)this.fccBackground)) {
            eLabel.type = 4;
        } else if (event.widget.equals((Object)this.fccShadow)) {
            eLabel.type = 5;
        } else if (event.widget.equals((Object)this.icInsets)) {
            eLabel.type = 10;
        } else if (event.widget.equals((Object)this.txtLabel)) {
            eLabel.type = 11;
        }
        eLabel.data = event.data;
        this.fireEvent(eLabel);
    }

    private boolean isFlippedAxes() {
        return this.wizardContext.getModel() instanceof ChartWithAxes && ((ChartWithAxes)this.wizardContext.getModel()).getOrientation().equals((Object)Orientation.HORIZONTAL_LITERAL);
    }

    private boolean isAxisAttribute() {
        return this.lblCurrent.eContainer() instanceof Axis;
    }

    private boolean isSeriesAttribute() {
        return this.wizardContext.getModel() instanceof ChartWithAxes && this.lblCurrent.eContainer() instanceof Series;
    }

    public static class LabelAttributesContext {
        public boolean isLabelEnabled = false;
        public boolean isPositionEnabled = true;
        public boolean isVisibilityEnabled = true;
        public boolean isFontAlignmentEnabled = true;
        public boolean isFontEnabled = true;
        public boolean isInsetsEnabled = true;
        public boolean isShadowEnabled = true;
    }
}

