/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Angle3D;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.RiserType;
import org.eclipse.birt.chart.model.attribute.Text;
import org.eclipse.birt.chart.model.attribute.impl.Angle3DImpl;
import org.eclipse.birt.chart.model.attribute.impl.Rotation3DImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.AxisImpl;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartPreviewPainterBase;
import org.eclipse.birt.chart.ui.swt.DefaultChartSubTypeImpl;
import org.eclipse.birt.chart.ui.swt.DefaultChartTypeImpl;
import org.eclipse.birt.chart.ui.swt.HelpContentImpl;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartSubType;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartType;
import org.eclipse.birt.chart.ui.swt.interfaces.IHelpContent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataComponent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataCustomizeUI;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.data.DefaultBaseSeriesComponent;
import org.eclipse.birt.chart.ui.util.ChartCacheManager;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBarChart
extends DefaultChartTypeImpl {
    public final String fsTypeLiteral;
    protected static final String STACKED_SUBTYPE_LITERAL = "Stacked";
    protected static final String PERCENTSTACKED_SUBTYPE_LITERAL = "Percent Stacked";
    protected static final String SIDE_SUBTYPE_LITERAL = "Side-by-side";
    private final String fsChartTypePrefix;
    private final RiserType foRiserType;

    public AbstractBarChart(String chartTypePrefix, String typeLiteral, RiserType riserType) {
        this.fsChartTypePrefix = chartTypePrefix;
        this.fsTypeLiteral = typeLiteral;
        this.foRiserType = riserType;
        this.chartTitle = Messages.getString(String.valueOf(this.fsChartTypePrefix) + "Chart.Txt.Default" + this.fsChartTypePrefix + "ChartTitle");
    }

    public String getName() {
        return this.fsTypeLiteral;
    }

    public Image getImage() {
        return UIHelper.getImage((String)("icons/obj16/" + this.fsChartTypePrefix.toLowerCase() + "charticon.gif"));
    }

    protected Image getImageForSubtype(String sDimension, Orientation orientation, String subtype) {
        String imagePath = null;
        String lowerChartPrefix = this.fsChartTypePrefix.toLowerCase();
        if (sDimension.equals(TWO_DIMENSION_TYPE) || sDimension.equals(ChartDimension.TWO_DIMENSIONAL_LITERAL.getName())) {
            if (subtype.equals(SIDE_SUBTYPE_LITERAL)) {
                imagePath = orientation == Orientation.VERTICAL_LITERAL ? "icons/wizban/sidebyside" + lowerChartPrefix + "chartimage.gif" : "icons/wizban/horizontalsidebyside" + lowerChartPrefix + "chartimage.gif";
            } else if (subtype.equals(STACKED_SUBTYPE_LITERAL)) {
                imagePath = orientation == Orientation.VERTICAL_LITERAL ? "icons/wizban/stacked" + lowerChartPrefix + "chartimage.gif" : "icons/wizban/horizontalstacked" + lowerChartPrefix + "chartimage.gif";
            } else if (subtype.equals(PERCENTSTACKED_SUBTYPE_LITERAL)) {
                imagePath = orientation == Orientation.VERTICAL_LITERAL ? "icons/wizban/percentstacked" + lowerChartPrefix + "chartimage.gif" : "icons/wizban/horizontalpercentstacked" + lowerChartPrefix + "chartimage.gif";
            }
        } else if (sDimension.equals(TWO_DIMENSION_WITH_DEPTH_TYPE) || sDimension.equals(ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL.getName())) {
            if (subtype.equals(SIDE_SUBTYPE_LITERAL)) {
                imagePath = orientation == Orientation.VERTICAL_LITERAL ? "icons/wizban/sidebyside" + lowerChartPrefix + "chartwithdepthimage.gif" : "icons/wizban/horizontalsidebyside" + lowerChartPrefix + "chartwithdepthimage.gif";
            } else if (subtype.equals(STACKED_SUBTYPE_LITERAL)) {
                imagePath = orientation == Orientation.VERTICAL_LITERAL ? "icons/wizban/stacked" + lowerChartPrefix + "chartwithdepthimage.gif" : "icons/wizban/horizontalstacked" + lowerChartPrefix + "chartwithdepthimage.gif";
            } else if (subtype.equals(PERCENTSTACKED_SUBTYPE_LITERAL)) {
                imagePath = orientation == Orientation.VERTICAL_LITERAL ? "icons/wizban/percentstacked" + lowerChartPrefix + "chartwithdepthimage.gif" : "icons/wizban/horizontalpercentstacked" + lowerChartPrefix + "chartwithdepthimage.gif";
            }
        } else if (sDimension.equals(THREE_DIMENSION_TYPE) || sDimension.equals(ChartDimension.THREE_DIMENSIONAL_LITERAL.getName())) {
            imagePath = "icons/wizban/sidebyside" + lowerChartPrefix + "chart3dimage.gif";
        }
        if (imagePath != null) {
            return UIHelper.getImage(imagePath);
        }
        return null;
    }

    public IHelpContent getHelp() {
        return new HelpContentImpl(this.fsTypeLiteral, Messages.getString(String.valueOf(this.fsChartTypePrefix) + "Chart.Txt.HelpText"));
    }

    public Collection<IChartSubType> getChartSubtypes(String sDimension, Orientation orientation) {
        Vector<IChartSubType> vSubTypes = new Vector<IChartSubType>();
        if (sDimension.equals(TWO_DIMENSION_TYPE) || sDimension.equals(ChartDimension.TWO_DIMENSIONAL_LITERAL.getName())) {
            vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(SIDE_SUBTYPE_LITERAL, this.getImageForSubtype(sDimension, orientation, SIDE_SUBTYPE_LITERAL), this.getDescriptionForSubtype(SIDE_SUBTYPE_LITERAL), Messages.getString(String.valueOf(this.fsChartTypePrefix) + "Chart.SubType.Side")));
            if (this.isStackedSupported()) {
                vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(STACKED_SUBTYPE_LITERAL, this.getImageForSubtype(sDimension, orientation, STACKED_SUBTYPE_LITERAL), this.getDescriptionForSubtype(STACKED_SUBTYPE_LITERAL), Messages.getString(String.valueOf(this.fsChartTypePrefix) + "Chart.SubType.Stacked")));
            }
            if (this.isPercentStackedSupported()) {
                vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(PERCENTSTACKED_SUBTYPE_LITERAL, this.getImageForSubtype(sDimension, orientation, PERCENTSTACKED_SUBTYPE_LITERAL), this.getDescriptionForSubtype(PERCENTSTACKED_SUBTYPE_LITERAL), Messages.getString(String.valueOf(this.fsChartTypePrefix) + "Chart.SubType.PercentStacked")));
            }
        } else if (sDimension.equals(TWO_DIMENSION_WITH_DEPTH_TYPE) || sDimension.equals(ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL.getName())) {
            vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(SIDE_SUBTYPE_LITERAL, this.getImageForSubtype(sDimension, orientation, SIDE_SUBTYPE_LITERAL), this.getDescriptionForSubtype(SIDE_SUBTYPE_LITERAL), Messages.getString(String.valueOf(this.fsChartTypePrefix) + "Chart.SubType.Side")));
            if (this.isStackedSupported()) {
                vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(STACKED_SUBTYPE_LITERAL, this.getImageForSubtype(sDimension, orientation, STACKED_SUBTYPE_LITERAL), this.getDescriptionForSubtype(STACKED_SUBTYPE_LITERAL), Messages.getString(String.valueOf(this.fsChartTypePrefix) + "Chart.SubType.Stacked")));
            }
            if (this.isPercentStackedSupported()) {
                vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(PERCENTSTACKED_SUBTYPE_LITERAL, this.getImageForSubtype(sDimension, orientation, PERCENTSTACKED_SUBTYPE_LITERAL), this.getDescriptionForSubtype(PERCENTSTACKED_SUBTYPE_LITERAL), Messages.getString(String.valueOf(this.fsChartTypePrefix) + "Chart.SubType.PercentStacked")));
            }
        } else if (sDimension.equals(THREE_DIMENSION_TYPE) || sDimension.equals(ChartDimension.THREE_DIMENSIONAL_LITERAL.getName())) {
            vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(SIDE_SUBTYPE_LITERAL, this.getImageForSubtype(sDimension, orientation, SIDE_SUBTYPE_LITERAL), this.getDescriptionForSubtype(SIDE_SUBTYPE_LITERAL), Messages.getString(String.valueOf(this.fsChartTypePrefix) + "Chart.SubType.Side")));
        }
        return vSubTypes;
    }

    protected boolean isStackedSupported() {
        return true;
    }

    protected boolean isPercentStackedSupported() {
        return true;
    }

    public Chart getModel(String sSubType, Orientation orientation, String sDimension, Chart currentChart) {
        ChartWithAxes newChart = null;
        if (currentChart != null && (newChart = (ChartWithAxes)this.getConvertedChart(currentChart, sSubType, orientation, sDimension)) != null) {
            return newChart;
        }
        newChart = ChartWithAxesImpl.create();
        newChart.setType(this.fsTypeLiteral);
        newChart.setSubType(sSubType);
        newChart.setOrientation(orientation);
        newChart.setDimension(ChartUIUtil.getDimensionType((String)sDimension));
        newChart.setUnits("Points");
        ((Axis)newChart.getAxes().get(0)).setOrientation(Orientation.HORIZONTAL_LITERAL);
        ((Axis)newChart.getAxes().get(0)).setType(AxisType.TEXT_LITERAL);
        ((Axis)newChart.getAxes().get(0)).setCategoryAxis(true);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        Series categorySeries = SeriesImpl.create();
        sdX.getSeries().add((Object)categorySeries);
        sdX.getSeriesPalette().shift(0);
        ((Axis)newChart.getAxes().get(0)).getSeriesDefinitions().add((Object)sdX);
        newChart.getTitle().getLabel().getCaption().setValue(this.getDefaultTitle());
        newChart.setUnitSpacing(50.0);
        ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setOrientation(Orientation.VERTICAL_LITERAL);
        ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setType(AxisType.LINEAR_LITERAL);
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        sdY.getSeriesPalette().shift(0);
        Series valueSeries = this.getSeries();
        if (sSubType.equalsIgnoreCase(STACKED_SUBTYPE_LITERAL)) {
            valueSeries.setStacked(true);
        } else if (sSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL)) {
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setPercent(true);
            valueSeries.setStacked(true);
            ((BarSeries)valueSeries).setStacked(true);
        } else if (sSubType.equalsIgnoreCase(SIDE_SUBTYPE_LITERAL)) {
            ((BarSeries)valueSeries).setStacked(false);
        }
        sdY.getSeries().add((Object)valueSeries);
        ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().add((Object)sdY);
        ChartUIUtil.setSeriesName((Chart)newChart);
        if (sDimension.equals(THREE_DIMENSION_TYPE)) {
            newChart.setRotation(Rotation3DImpl.create((Angle3D[])new Angle3D[]{Angle3DImpl.create((double)-20.0, (double)45.0, (double)0.0)}));
            newChart.getPrimaryBaseAxes()[0].getAncillaryAxes().clear();
            Axis zAxisAncillary = AxisImpl.create((int)3);
            zAxisAncillary.setTitlePosition(Position.BELOW_LITERAL);
            zAxisAncillary.getTitle().getCaption().setValue(Messages.getString("ChartWithAxesImpl.Z_Axis.title"));
            zAxisAncillary.getTitle().setVisible(true);
            zAxisAncillary.setPrimaryAxis(true);
            zAxisAncillary.setLabelPosition(Position.BELOW_LITERAL);
            zAxisAncillary.setOrientation(Orientation.HORIZONTAL_LITERAL);
            zAxisAncillary.getOrigin().setType(IntersectionType.MIN_LITERAL);
            zAxisAncillary.getOrigin().setValue((DataElement)NumberDataElementImpl.create((double)0.0));
            zAxisAncillary.getTitle().setVisible(false);
            zAxisAncillary.setType(AxisType.TEXT_LITERAL);
            newChart.getPrimaryBaseAxes()[0].getAncillaryAxes().add((Object)zAxisAncillary);
            newChart.getPrimaryOrthogonalAxis(newChart.getPrimaryBaseAxes()[0]).getTitle().getCaption().getFont().setRotation(0.0);
            SeriesDefinition sdZ = SeriesDefinitionImpl.create();
            sdZ.getSeriesPalette().shift(0);
            sdZ.getSeries().add((Object)SeriesImpl.create());
            zAxisAncillary.getSeriesDefinitions().add((Object)sdZ);
        }
        this.addSampleData((Chart)newChart);
        return newChart;
    }

    private void addSampleData(Chart newChart) {
        SampleData sd = DataFactory.eINSTANCE.createSampleData();
        sd.getBaseSampleData().clear();
        sd.getOrthogonalSampleData().clear();
        BaseSampleData sdBase = DataFactory.eINSTANCE.createBaseSampleData();
        sdBase.setDataSetRepresentation("A, B, C");
        sd.getBaseSampleData().add((Object)sdBase);
        OrthogonalSampleData oSample = DataFactory.eINSTANCE.createOrthogonalSampleData();
        oSample.setDataSetRepresentation("5,4,12");
        oSample.setSeriesDefinitionIndex(0);
        sd.getOrthogonalSampleData().add((Object)oSample);
        if (newChart.getDimension() == ChartDimension.THREE_DIMENSIONAL_LITERAL) {
            BaseSampleData sdAncillary = DataFactory.eINSTANCE.createBaseSampleData();
            sdAncillary.setDataSetRepresentation("Series 1");
            sd.getAncillarySampleData().add((Object)sdAncillary);
        }
        newChart.setSampleData(sd);
    }

    private Chart getConvertedChart(Chart currentChart, String sNewSubType, Orientation newOrientation, String sNewDimension) {
        Text title;
        Chart helperModel = currentChart.copyInstance();
        helperModel.eAdapters().addAll((Collection)currentChart.eAdapters());
        ChartDimension oldDimension = currentChart.getDimension();
        ChartCacheManager.getInstance().cacheSeries(ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)helperModel));
        IChartType oldType = ChartUIUtil.getChartType((String)currentChart.getType());
        if (currentChart instanceof ChartWithAxes) {
            if (!currentChart.getType().equals(this.fsTypeLiteral)) {
                currentChart.setType(this.fsTypeLiteral);
                currentChart.setSubType(sNewSubType);
                title = currentChart.getTitle().getLabel().getCaption();
                if (title.getValue() == null || title.getValue().trim().length() == 0 || title.getValue().trim().equals(oldType.getDefaultTitle().trim())) {
                    title.setValue(this.getDefaultTitle());
                }
                ArrayList<AxisType> axisTypes = new ArrayList<AxisType>();
                EList axes = ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes();
                int i = 0;
                int seriesIndex = 0;
                while (i < axes.size()) {
                    if (!ChartPreviewPainterBase.isLivePreviewActive() && !this.isNumbericAxis((Axis)axes.get(i))) {
                        ((Axis)axes.get(i)).setType(AxisType.LINEAR_LITERAL);
                    }
                    ((Axis)axes.get(i)).setPercent(sNewSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL));
                    EList seriesdefinitions = ((Axis)axes.get(i)).getSeriesDefinitions();
                    int j = 0;
                    while (j < seriesdefinitions.size()) {
                        Series series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                        series = this.getConvertedSeries(series, seriesIndex++);
                        if (!ChartPreviewPainterBase.isLivePreviewActive() && !this.isNumbericAxis((Axis)axes.get(i))) {
                            ((Axis)axes.get(i)).setType(AxisType.LINEAR_LITERAL);
                        }
                        boolean isStacked = sNewSubType.equalsIgnoreCase(STACKED_SUBTYPE_LITERAL) || sNewSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL);
                        series.setStacked(isStacked);
                        ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().clear();
                        ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().add((Object)series);
                        axisTypes.add(((Axis)axes.get(i)).getType());
                        ++j;
                    }
                    ++i;
                }
                currentChart.setSampleData(this.getConvertedSampleData(currentChart.getSampleData(), ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getType(), axisTypes));
            } else {
                EList axes = ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes();
                int i = 0;
                int seriesIndex = 0;
                while (i < axes.size()) {
                    if (!currentChart.getSubType().equals(sNewSubType)) {
                        if (sNewSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL)) {
                            if (!ChartPreviewPainterBase.isLivePreviewActive() && !this.isNumbericAxis((Axis)axes.get(i))) {
                                ((Axis)axes.get(i)).setType(AxisType.LINEAR_LITERAL);
                            }
                            ((Axis)axes.get(i)).setPercent(true);
                        } else {
                            ((Axis)axes.get(i)).setPercent(false);
                        }
                    }
                    EList seriesdefinitions = ((Axis)axes.get(i)).getSeriesDefinitions();
                    Series firstSeries = ((SeriesDefinition)seriesdefinitions.get(0)).getDesignTimeSeries();
                    int j = 0;
                    while (j < seriesdefinitions.size()) {
                        Series series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                        if (sNewSubType.equalsIgnoreCase(STACKED_SUBTYPE_LITERAL) || sNewSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL)) {
                            if (j != 0) {
                                series = this.getConvertedSeriesAsFirst(series, seriesIndex, firstSeries);
                            }
                            ++seriesIndex;
                            if (!ChartPreviewPainterBase.isLivePreviewActive() && !this.isNumbericAxis((Axis)axes.get(i))) {
                                ((Axis)axes.get(i)).setType(AxisType.LINEAR_LITERAL);
                            }
                            if (series.canBeStacked()) {
                                series.setStacked(true);
                            }
                            ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().clear();
                            ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().add((Object)series);
                        } else {
                            series.setStacked(false);
                        }
                        ++j;
                    }
                    ++i;
                }
                if (!currentChart.getSubType().equals(sNewSubType)) {
                    currentChart.setSubType(sNewSubType);
                }
            }
        } else {
            currentChart = ChartWithAxesImpl.create();
            this.copyChartProperties(helperModel, currentChart);
            currentChart.setType(this.fsTypeLiteral);
            currentChart.setSubType(sNewSubType);
            ((ChartWithAxes)currentChart).setOrientation(newOrientation);
            currentChart.setDimension(ChartUIUtil.getDimensionType((String)sNewDimension));
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).setOrientation(Orientation.HORIZONTAL_LITERAL);
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).setCategoryAxis(true);
            ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).setOrientation(Orientation.VERTICAL_LITERAL);
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().clear();
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().add((Object)((SeriesDefinition)((ChartWithoutAxes)helperModel).getSeriesDefinitions().get(0)));
            ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().clear();
            ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().addAll((Collection)((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getSeriesDefinitions());
            Series series = ((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getDesignTimeSeries();
            ((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getSeries().clear();
            ((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getSeries().add((Object)series);
            EList seriesdefinitions = ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions();
            int j = 0;
            while (j < seriesdefinitions.size()) {
                series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                series = this.getConvertedSeries(series, j);
                series.getLabel().setVisible(false);
                if (sNewSubType.equalsIgnoreCase(STACKED_SUBTYPE_LITERAL) || sNewSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL)) {
                    series.setStacked(true);
                } else {
                    series.setStacked(false);
                }
                ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().clear();
                ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().add((Object)series);
                ++j;
            }
            currentChart.getLegend().setItemType(LegendItemType.SERIES_LITERAL);
            title = currentChart.getTitle().getLabel().getCaption();
            if (title.getValue() == null || title.getValue().trim().length() == 0 || title.getValue().trim().equals(oldType.getDefaultTitle().trim())) {
                title.setValue(this.getDefaultTitle());
            }
        }
        if (!((ChartWithAxes)currentChart).getOrientation().equals((Object)newOrientation)) {
            ((ChartWithAxes)currentChart).setOrientation(newOrientation);
        }
        if (!currentChart.getDimension().equals((Object)ChartUIUtil.getDimensionType((String)sNewDimension))) {
            currentChart.setDimension(ChartUIUtil.getDimensionType((String)sNewDimension));
        }
        if (sNewDimension.equals(THREE_DIMENSION_TYPE) && ChartUIUtil.getDimensionType((String)sNewDimension) != oldDimension) {
            ((ChartWithAxes)currentChart).setRotation(Rotation3DImpl.create((Angle3D[])new Angle3D[]{Angle3DImpl.create((double)-20.0, (double)45.0, (double)0.0)}));
            ((ChartWithAxes)currentChart).getPrimaryBaseAxes()[0].getAncillaryAxes().clear();
            Axis zAxisAncillary = AxisImpl.create((int)3);
            zAxisAncillary.setTitlePosition(Position.BELOW_LITERAL);
            zAxisAncillary.getTitle().getCaption().setValue(Messages.getString("ChartWithAxesImpl.Z_Axis.title"));
            zAxisAncillary.getTitle().setVisible(true);
            zAxisAncillary.setPrimaryAxis(true);
            zAxisAncillary.setLabelPosition(Position.BELOW_LITERAL);
            zAxisAncillary.setOrientation(Orientation.HORIZONTAL_LITERAL);
            zAxisAncillary.getOrigin().setType(IntersectionType.MIN_LITERAL);
            zAxisAncillary.getOrigin().setValue((DataElement)NumberDataElementImpl.create((double)0.0));
            zAxisAncillary.getTitle().setVisible(false);
            zAxisAncillary.setType(AxisType.TEXT_LITERAL);
            ((ChartWithAxes)currentChart).getPrimaryBaseAxes()[0].getAncillaryAxes().add((Object)zAxisAncillary);
            SeriesDefinition sdZ = SeriesDefinitionImpl.create();
            sdZ.getSeriesPalette().shift(0);
            sdZ.getSeries().add((Object)SeriesImpl.create());
            zAxisAncillary.getSeriesDefinitions().add((Object)sdZ);
            if (currentChart.getSampleData().getAncillarySampleData().isEmpty()) {
                BaseSampleData sdAncillary = DataFactory.eINSTANCE.createBaseSampleData();
                sdAncillary.setDataSetRepresentation("Series 1");
                currentChart.getSampleData().getAncillarySampleData().add((Object)sdAncillary);
            }
            EList seriesdefinitions = ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)currentChart, (int)0);
            int j = 0;
            while (j < seriesdefinitions.size()) {
                Series series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                if (series instanceof BarSeries) {
                    ((BarSeries)series).setRiser(this.foRiserType);
                }
                series.setStacked(false);
                if (series instanceof BarSeries && series.getLabelPosition() != Position.OUTSIDE_LITERAL) {
                    series.setLabelPosition(Position.OUTSIDE_LITERAL);
                }
                ++j;
            }
        }
        ChartUIUtil.restoreLabelPositionFromCache((Chart)currentChart);
        return currentChart;
    }

    private boolean isNumbericAxis(Axis axis) {
        return axis.getType().getValue() == 0 || axis.getType().getValue() == 1;
    }

    private Series getConvertedSeries(Series series, int seriesIndex) {
        if (series.getClass().getName().equals(SeriesImpl.class.getName())) {
            return series;
        }
        BarSeries barseries = (BarSeries)ChartCacheManager.getInstance().findSeries(BarSeriesImpl.class.getName(), seriesIndex);
        if (barseries == null) {
            barseries = (BarSeries)this.getSeries();
        }
        ChartUIUtil.copyGeneralSeriesAttributes((Series)series, (Series)barseries);
        barseries.setRiser(this.foRiserType);
        return barseries;
    }

    public String[] getSupportedDimensions() {
        return new String[]{TWO_DIMENSION_TYPE, TWO_DIMENSION_WITH_DEPTH_TYPE, THREE_DIMENSION_TYPE};
    }

    public String getDefaultDimension() {
        return TWO_DIMENSION_TYPE;
    }

    public boolean supportsTransposition() {
        return true;
    }

    public boolean supportsTransposition(String dimension) {
        if (ChartUIUtil.getDimensionType((String)dimension) == ChartDimension.THREE_DIMENSIONAL_LITERAL) {
            return false;
        }
        return this.supportsTransposition();
    }

    public ISelectDataComponent getBaseUI(Chart chart, ISelectDataCustomizeUI selectDataUI, ChartWizardContext context, String sTitle) {
        return new DefaultBaseSeriesComponent((SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)chart).get(0), context, sTitle);
    }

    public String getDisplayName() {
        return Messages.getString(String.valueOf(this.fsChartTypePrefix) + "Chart.Txt.DisplayName");
    }

    protected String getDescriptionForSubtype(String subtypeLiteral) {
        if (SIDE_SUBTYPE_LITERAL.equals(subtypeLiteral)) {
            return Messages.getString(String.valueOf(this.fsChartTypePrefix) + "Chart.Txt.SideBySideDescription");
        }
        if (STACKED_SUBTYPE_LITERAL.equals(subtypeLiteral)) {
            return Messages.getString(String.valueOf(this.fsChartTypePrefix) + "Chart.Txt.StackedDescription");
        }
        if (PERCENTSTACKED_SUBTYPE_LITERAL.equals(subtypeLiteral)) {
            return Messages.getString(String.valueOf(this.fsChartTypePrefix) + "Chart.Txt.PercentStackedDescription");
        }
        return null;
    }

    public Series getSeries() {
        BarSeries barseries = (BarSeries)BarSeriesImpl.create();
        barseries.setRiser(this.foRiserType);
        return barseries;
    }

    public boolean canCombine() {
        return true;
    }

    public boolean canExpand() {
        return true;
    }
}

