/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.data;

import java.util.Collection;
import java.util.List;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.DataPackage;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.QueryImpl;
import org.eclipse.birt.chart.ui.swt.composites.GroupSortingDialog;
import org.eclipse.birt.chart.ui.swt.composites.YOptionalGroupSortingDialog;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.data.BaseDataDefinitionComponent;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.emf.ecore.EStructuralFeature;

public class YOptionalDataDefinitionComponent
extends BaseDataDefinitionComponent {
    public YOptionalDataDefinitionComponent(String queryType, SeriesDefinition seriesdefinition, Query query, ChartWizardContext context, String title) {
        super(queryType, seriesdefinition, query, context, title);
    }

    public YOptionalDataDefinitionComponent(int style, String queryType, SeriesDefinition seriesdefinition, Query query, ChartWizardContext context, String title) {
        super(style, queryType, seriesdefinition, query, context, title);
    }

    protected GroupSortingDialog createGroupSortingDialog(SeriesDefinition sdBackup) {
        return new YOptionalGroupSortingDialog(this.cmpTop.getShell(), this.context, sdBackup, false);
    }

    protected void handleGroupAction() {
        SeriesDefinition sdBackup = this.seriesdefinition.copyInstance();
        GroupSortingDialog groupDialog = this.createGroupSortingDialog(sdBackup);
        if (groupDialog.open() == 0) {
            SeriesDefinition sdf;
            if (!sdBackup.eIsSet((EStructuralFeature)DataPackage.eINSTANCE.getSeriesDefinition_Sorting())) {
                this.seriesdefinition.eUnset((EStructuralFeature)DataPackage.eINSTANCE.getSeriesDefinition_Sorting());
            } else {
                this.seriesdefinition.setSorting(sdBackup.getSorting());
            }
            this.seriesdefinition.setSortLocale(sdBackup.getSortLocale());
            if (sdBackup.isSetSortStrength()) {
                this.seriesdefinition.setSortStrength(sdBackup.getSortStrength());
            } else {
                this.seriesdefinition.unsetSortStrength();
            }
            ChartAdapter.beginIgnoreNotifications();
            List sds = ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)this.context.getModel());
            int i = 0;
            while (i < sds.size()) {
                if (i != 0) {
                    sdf = (SeriesDefinition)sds.get(i);
                    if (!sdBackup.eIsSet((EStructuralFeature)DataPackage.eINSTANCE.getSeriesDefinition_Sorting())) {
                        sdf.eUnset((EStructuralFeature)DataPackage.eINSTANCE.getSeriesDefinition_Sorting());
                    } else {
                        sdf.setSorting(sdBackup.getSorting());
                    }
                    sdf.setSortLocale(sdBackup.getSortLocale());
                    if (sdBackup.isSetSortStrength()) {
                        sdf.setSortStrength(sdBackup.getSortStrength());
                    } else {
                        sdf.unsetSortStrength();
                    }
                }
                ++i;
            }
            ChartAdapter.endIgnoreNotifications();
            this.seriesdefinition.setSortKey(sdBackup.getSortKey());
            this.seriesdefinition.getSortKey().eAdapters().addAll((Collection)this.seriesdefinition.eAdapters());
            if (this.seriesdefinition.getQuery() != null) {
                if (sdBackup.getQuery().getGrouping() == null) {
                    return;
                }
                this.seriesdefinition.getQuery().setGrouping(sdBackup.getQuery().getGrouping());
                this.seriesdefinition.getQuery().getGrouping().eAdapters().addAll((Collection)this.seriesdefinition.getQuery().eAdapters());
                ChartAdapter.beginIgnoreNotifications();
                i = 0;
                while (i < sds.size()) {
                    if (i != 0) {
                        sdf = (SeriesDefinition)sds.get(i);
                        sdf.getQuery().setGrouping(this.seriesdefinition.getQuery().getGrouping().copyInstance());
                        sdf.getQuery().getGrouping().eAdapters().addAll((Collection)sdf.getQuery().eAdapters());
                    }
                    ++i;
                }
                ChartAdapter.endIgnoreNotifications();
                ChartUIUtil.checkGroupType((ChartWizardContext)this.context, (Chart)this.context.getModel());
            }
        }
    }

    private void updateBaseSeriesSortKey() {
        String yGrouping = this.query.getDefinition();
        if (yGrouping != null && !"".equals(yGrouping)) {
            Chart cm = this.context.getModel();
            SeriesDefinition baseSD = null;
            if (cm instanceof ChartWithAxes) {
                ChartWithAxes cwa = (ChartWithAxes)cm;
                baseSD = (SeriesDefinition)cwa.getBaseAxes()[0].getSeriesDefinitions().get(0);
            } else if (cm instanceof ChartWithoutAxes) {
                ChartWithoutAxes cwoa = (ChartWithoutAxes)cm;
                baseSD = (SeriesDefinition)cwoa.getSeriesDefinitions().get(0);
            }
            if (baseSD != null && baseSD.isSetSorting()) {
                Series s = (Series)baseSD.getSeries().get(0);
                String baseExpr = ((Query)s.getDataDefinition().get(0)).getDefinition();
                if (baseSD.getSortKey() == null) {
                    Query q = QueryImpl.create((String)baseExpr);
                    baseSD.setSortKey(q);
                    q.eAdapters().addAll((Collection)baseSD.eAdapters());
                } else {
                    baseSD.getSortKey().setDefinition(baseExpr);
                }
            }
        }
    }

    public void updateQuery(String expression) {
        super.updateQuery(expression);
        this.updateBaseSeriesSortKey();
        ChartUIUtil.setAllGroupingQueryExceptFirst((Chart)this.context.getModel(), (String)expression);
    }
}

