/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.ui.frameworks.taskwizard;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.birt.core.ui.frameworks.errordisplay.ErrorDialog;
import org.eclipse.birt.core.ui.frameworks.taskwizard.ErrorsManager;
import org.eclipse.birt.core.ui.frameworks.taskwizard.TasksManager;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBaseDialog;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.IButtonHandler;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.IRegistrationListener;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.ITask;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.IWizardContext;
import org.eclipse.birt.core.ui.i18n.Messages;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WizardBase
implements IRegistrationListener {
    private transient LinkedHashMap<String, ITask> availableTasks = null;
    transient Vector<String> vTaskIDs = null;
    transient List<IButtonHandler> buttonList = null;
    transient String sCurrentActiveTask = null;
    protected transient IWizardContext context = null;
    transient String sWizardID = "";
    transient Shell shellParent = null;
    private transient Object[] errorHints = null;
    private WizardBaseDialog dialog;
    boolean packNeeded = true;
    boolean bEnterClosed = true;
    boolean isDisposed = false;

    public IWizardContext open(String[] sTasks, String topTaskId, IWizardContext initialContext) {
        this.context = initialContext;
        this.dialog.tmpTaskArray = sTasks;
        this.dialog.tmpTopTaskId = topTaskId;
        return this.dialog.open() == 0 ? this.context : null;
    }

    public IWizardContext open(IWizardContext initialContext) {
        return this.open(null, null, initialContext);
    }

    public void setMinimumSize(int iWidth, int iHeight) {
        this.dialog.setMinimumSize(iWidth, iHeight);
    }

    public void firePageChanged(IDialogPage taskPage) {
        this.dialog.firePageChanged(new PageChangedEvent((IPageChangeProvider)this.dialog, (Object)taskPage));
    }

    public void setWizardClosedWhenEnterPressed(boolean bClosed) {
        this.bEnterClosed = bClosed;
    }

    public void addCustomButton(IButtonHandler buttonHandler) {
        this.buttonList.add(buttonHandler);
    }

    protected List<IButtonHandler> getCustomButtons() {
        return this.buttonList;
    }

    public void addTask(String sTaskID) {
        ITask task = TasksManager.instance().getTask(sTaskID);
        if (task == null) {
            try {
                throw new RuntimeException("Task " + sTaskID + " is not registered!");
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                return;
            }
        }
        task.setUIProvider(this);
        if (!this.vTaskIDs.contains(sTaskID)) {
            this.availableTasks.put(sTaskID, task);
            this.vTaskIDs.add(sTaskID);
        }
    }

    public void removeTask(String sTaskID) {
        if (this.vTaskIDs.size() == 1) {
            throw new RuntimeException("There is only one task left in the wizard...you are not allowed to remove all tasks from a wizard!");
        }
        if (this.availableTasks.containsKey(sTaskID)) {
            this.availableTasks.remove(sTaskID);
            int iTaskIndex = this.vTaskIDs.indexOf(sTaskID);
            this.vTaskIDs.remove(iTaskIndex);
            this.switchTo(this.vTaskIDs.get(0));
        }
    }

    public ITask getCurrentTask() {
        return this.availableTasks.get(this.sCurrentActiveTask);
    }

    public void switchTo(String sTaskID) {
        if (this.sCurrentActiveTask != null) {
            this.context = this.getCurrentTask().getContext();
        }
        this.sCurrentActiveTask = sTaskID;
        if (this.errorHints != null) {
            this.getCurrentTask().setErrorHints(this.errorHints);
        }
        this.getCurrentTask().setContext(this.context);
        this.errorHints = null;
        ErrorsManager.instance().removeErrors();
        this.detachPopup();
        try {
            this.dialog.switchTask();
        }
        catch (Exception e) {
            WizardBase.displayException(e);
        }
    }

    public Shell createPopupContainer() {
        return this.dialog.createPopupContainer();
    }

    public Shell getPopupContainer() {
        return this.dialog.getPopupContainer();
    }

    public void attachPopup(String sPopupTitle, int iWidth, int iHeight) {
        this.dialog.attachPopup(sPopupTitle, iWidth, iHeight);
    }

    public void detachPopup() {
        this.dialog.detachPopup();
    }

    public void updateContext(IWizardContext wizardcontext) {
        this.context = wizardcontext;
    }

    public WizardBase(String sID) {
        this(null, sID, -1, -1, null, null, null, null);
    }

    public WizardBase(String sID, int iInitialWidth, int iInitialHeight, String strTitle, Image imgTitle, String strHeader, Image imgHeader) {
        this(null, sID, iInitialWidth, iInitialHeight, strTitle, imgTitle, strHeader, imgHeader);
    }

    public WizardBase(Shell parentShell, String sID, int iInitialWidth, int iInitialHeight, String strTitle, Image imgTitle, String strHeader, Image imgHeader) {
        this.shellParent = parentShell;
        this.sWizardID = sID;
        TasksManager.instance();
        ErrorsManager.instance();
        this.availableTasks = new LinkedHashMap();
        this.vTaskIDs = new Vector();
        this.buttonList = new ArrayList<IButtonHandler>(1);
        Shell shell = this.shellParent;
        if (shell == null) {
            shell = new Shell(Display.getCurrent(), 67696);
        }
        this.dialog = this.createDialog(shell, iInitialWidth, iInitialHeight, strTitle, imgTitle);
        this.dialog.setTitleImage(imgHeader);
        ErrorsManager.instance().registerWizard(this);
    }

    protected WizardBaseDialog createDialog(Shell shell, int initialWidth, int initialHeight, String strTitle, Image imgTitle) {
        return new WizardBaseDialog(this, shell, initialWidth, initialHeight, strTitle, imgTitle);
    }

    public WizardBase() {
        this("org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase");
    }

    public void clearCache() {
        this.availableTasks.clear();
        this.vTaskIDs.clear();
        this.buttonList.clear();
    }

    public static void displayException(Throwable t) {
        new ErrorDialog(null, Messages.getString("WizardBase.error.ErrorsEncountered"), Messages.getString("WizardBase.error.FollowingErrorEncountered"), t);
    }

    public static void showException(String errorMessage) {
        ErrorsManager.instance().showErrors(errorMessage);
    }

    public static void removeException() {
        ErrorsManager.instance().removeErrors();
    }

    public static String getErrors() {
        return ErrorsManager.instance().getErrors();
    }

    public void displayError(String[] sErrors, String[] sFixes, String[] sTaskIDs, IWizardContext currentContext, Object[] hints) {
        if (sErrors != null && sErrors.length > 0) {
            this.errorHints = hints;
            ErrorDialog dlg = new ErrorDialog(this.shellParent, Messages.getString("WizardBase.error.ErrorsEncountered"), Messages.getString("WizardBase.error.FollowingErrorEncountered"), sErrors, sFixes);
            dlg.getOption();
        }
    }

    @Override
    public void taskRegistered(String sTaskID) {
    }

    @Override
    public void taskDeregistered(String sTaskID) {
    }

    protected String[] validate() {
        return null;
    }

    public void dispose() {
        this.isDisposed = true;
        Iterator<ITask> tasks = this.availableTasks.values().iterator();
        while (tasks.hasNext()) {
            tasks.next().dispose();
        }
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    protected TitleAreaDialog getDialog() {
        return this.dialog;
    }

    protected void setTitle(String wizardTitle) {
        if (this.dialog != null) {
            this.dialog.wizardTitle = wizardTitle;
            this.dialog.setTitle(wizardTitle);
        }
    }

    protected String getTitle() {
        return this.dialog.wizardTitle;
    }

    public void packWizard() {
        this.dialog.packWizard();
    }

    protected boolean applyCustomPack() {
        return false;
    }
}

